/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.spell;

import java.util.Collection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.identifier.SpellSchool;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;

public class SchoolToken
implements PrimitiveToken<Spell>,
PrimitiveFilter<Spell> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;
    private CDOMSingleRef<SpellSchool> school;
    private CDOMReference<Spell> allSpells;

    @Override
    public boolean initialize(LoadContext context, Class<Spell> cl, String value, String args) {
        if (args != null) {
            return false;
        }
        this.school = context.getReferenceContext().getCDOMReference(SpellSchool.class, value);
        this.allSpells = context.getReferenceContext().getCDOMAllReference(SPELL_CLASS);
        return true;
    }

    @Override
    public String getTokenName() {
        return "SCHOOL";
    }

    @Override
    public Class<Spell> getReferenceClass() {
        return SPELL_CLASS;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getTokenName() + "=" + this.school.getLSTformat(false);
    }

    @Override
    public boolean allow(PlayerCharacter pc, Spell spell) {
        return spell.containsInList(ListKey.SPELL_SCHOOL, this.school.resolvesTo());
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SchoolToken) {
            SchoolToken other = (SchoolToken)obj;
            if (this.school == null) {
                return other.school == null;
            }
            return this.school.equals(other.school);
        }
        return false;
    }

    public int hashCode() {
        return this.school == null ? -7 : this.school.hashCode();
    }

    @Override
    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Spell, R> c) {
        return c.convert(this.allSpells, this);
    }
}

