/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.tab;

import java.io.File;
import pcgen.cdom.content.TabInfo;
import pcgen.core.utils.CoreUtility;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.system.ConfigurationSettings;
import pcgen.util.Logging;

public class ContextToken
implements CDOMPrimaryToken<TabInfo> {
    @Override
    public String getTokenName() {
        return "CONTEXT";
    }

    @Override
    public ParseResult parseToken(LoadContext context, TabInfo ti, String value) {
        if (value == null || value.length() == 0) {
            return ParseResult.SUCCESS;
        }
        String helpPath = CoreUtility.fixFilenamePath(ConfigurationSettings.getDocsDir() + File.separator + value);
        File helpFile = new File(helpPath);
        if (!helpFile.exists()) {
            Logging.log(Logging.LST_INFO, "Missing Documentation: " + helpFile.getAbsolutePath() + " in " + ti.getClass() + " " + ti.getDisplayName() + " from " + ti.getSourceURI());
            return ParseResult.SUCCESS;
        }
        ti.setHelpContext(helpFile);
        ti.setRawHelpContext(value);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, TabInfo ti) {
        String hc = ti.getRawHelpContext();
        if (hc == null) {
            return null;
        }
        return new String[]{hc};
    }

    @Override
    public Class<TabInfo> getTokenClass() {
        return TabInfo.class;
    }
}

