/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens.deprecated;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.analysis.BonusCalc;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.NonAbilityDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class TemplateToken
extends Token {
    public static final String TOKENNAME = "TEMPLATE";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String aLabel;
        String retString = "";
        CharacterDisplay display = pc.getDisplay();
        List<PCTemplate> tl = display.getOutputVisibleTemplateList();
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int indexOfTemplate = Integer.parseInt(aTok.nextToken());
        String string = aLabel = aTok.hasMoreTokens() ? aTok.nextToken() : "NAME";
        if (indexOfTemplate > -1 && indexOfTemplate < tl.size()) {
            PCTemplate template = tl.get(indexOfTemplate);
            if ("NAME".equals(aLabel)) {
                retString = TemplateToken.getOutputNameToken(template);
            } else if ("OUTPUTNAME".equals(aLabel)) {
                retString = TemplateToken.getOutputNameToken(template);
            } else if ("APPLIEDNAME".equals(aLabel)) {
                retString = this.getAppliedName(template);
            } else if ("SA".equals(aLabel)) {
                retString = TemplateToken.getSAToken(template, pc);
            } else if ("FEAT".equals(aLabel)) {
                retString = TemplateToken.getFeatToken(template, pc);
            } else if ("SR".equals(aLabel)) {
                retString = Integer.toString(TemplateToken.getSRToken(template, display));
            } else {
                if ("CR".equals(aLabel)) {
                    retString = Float.toString(TemplateToken.getCRToken(template, display));
                    String decimalPlaceValue = retString.substring(retString.length() - 2);
                    if (decimalPlaceValue.equals(".0")) {
                        retString = retString.substring(0, retString.length() - 2);
                    }
                    return retString;
                }
                retString = "DR".equals(aLabel) ? display.calcDR() : TemplateToken.getModToken(pc, template, aLabel);
            }
        }
        return retString;
    }

    private String getAppliedName(PCTemplate template) {
        FactKey fk = FactKey.valueOf("AppliedName");
        String retValue = (String)template.getResolved(fk);
        if (retValue == null) {
            retValue = template.toString();
        }
        return retValue;
    }

    public static List<CNAbilitySelection> feats(PlayerCharacter pc, PCTemplate pct, int level, int hitdice) {
        List<? extends CNAbilitySelection> featList;
        ArrayList<CNAbilitySelection> feats = new ArrayList<CNAbilitySelection>();
        for (PCTemplate rlt : pct.getSafeListFor(ListKey.REPEATLEVEL_TEMPLATES)) {
            for (PCTemplate lt : rlt.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
                List<? extends CNAbilitySelection> featList2 = pc.getTemplateFeatList(lt);
                if (featList2 == null) continue;
                feats.addAll(featList2);
            }
        }
        for (PCTemplate lt : pct.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
            featList = pc.getTemplateFeatList(lt);
            if (featList == null) continue;
            feats.addAll(featList);
        }
        for (PCTemplate lt : pct.getSafeListFor(ListKey.HD_TEMPLATES)) {
            featList = pc.getTemplateFeatList(lt);
            if (featList == null) continue;
            feats.addAll(featList);
        }
        List<? extends CNAbilitySelection> featList3 = pc.getTemplateFeatList(pct);
        if (featList3 != null) {
            feats.addAll(featList3);
        }
        return feats;
    }

    public static float getCRToken(PCTemplate template, CharacterDisplay display) {
        return template.getCR(display.getTotalLevels(), display.totalHitDice()).intValue();
    }

    public static String getFeatToken(PCTemplate template, PlayerCharacter pc) {
        CharacterDisplay display = pc.getDisplay();
        List<CNAbilitySelection> fList = TemplateToken.feats(pc, template, display.getTotalLevels(), display.totalHitDice());
        return StringUtil.join(fList, (String)", ");
    }

    public static String getModToken(PlayerCharacter pc, PCTemplate template, String aLabel) {
        StringBuilder retString = new StringBuilder();
        for (PCStat stat : pc.getDisplay().getStatSet()) {
            String modName = stat.getKeyName() + "MOD";
            if (!aLabel.equals(modName)) continue;
            if (NonAbilityDisplay.isNonAbilityForObject(stat, template)) {
                retString.append("*");
                break;
            }
            retString.append(BonusCalc.getStatMod(template, stat, pc));
            break;
        }
        return retString.toString();
    }

    public static String getNameToken(PCTemplate template) {
        return template.toString();
    }

    public static String getOutputNameToken(PCTemplate template) {
        return OutputNameFormatting.getOutputName(template);
    }

    public static String getSAToken(PCTemplate template, PlayerCharacter pc) {
        CharacterDisplay display = pc.getDisplay();
        ArrayList<SpecialAbility> saList = new ArrayList<SpecialAbility>();
        saList.addAll(display.getResolvedUserSpecialAbilities(template));
        saList.addAll(display.getResolvedSpecialAbilities(template));
        ArrayList<PCTemplate> subList = new ArrayList<PCTemplate>();
        subList.addAll(template.getConditionalTemplates(display.getTotalLevels(), display.totalHitDice()));
        for (PCTemplate subt : subList) {
            saList.addAll(display.getResolvedUserSpecialAbilities(subt));
            saList.addAll(display.getResolvedSpecialAbilities(subt));
        }
        ArrayList<String> saDescList = new ArrayList<String>();
        for (SpecialAbility sa : saList) {
            String saText;
            if (!sa.qualifies(pc, template) || (saText = sa.getParsedText(pc, pc, template)) == null || saText.equals("")) continue;
            saDescList.add(saText);
        }
        return StringUtil.join(saDescList, (String)", ");
    }

    public static int getSRToken(PCTemplate template, CharacterDisplay display) {
        return display.getTemplateSR(template, display.getTotalLevels(), display.totalHitDice());
    }
}

