/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Logging;

public class SkillpointsToken
extends Token {
    public static final String TOKENNAME = "SKILLPOINTS";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        int classNum = -1;
        String bString = aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            bString = aTok.nextToken();
        }
        if (aTok.hasMoreTokens()) {
            String pcclass = aTok.nextToken();
            try {
                classNum = Integer.parseInt(pcclass);
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("Expected class number in " + tokenSource + " but got " + pcclass + ".");
            }
        }
        if (bString.startsWith(TOKENNAME)) {
            bString = "TOTAL";
        }
        float aTotalSkillPoints = 0.0f;
        if ("TOTAL".equals(bString) || "UNUSED".equals(bString)) {
            aTotalSkillPoints = classNum >= 0 ? (aTotalSkillPoints += (float)SkillpointsToken.getUnusedSkillPoints(pc, classNum)) : (aTotalSkillPoints += (float)SkillpointsToken.getUnusedSkillPoints(pc));
        }
        if ("TOTAL".equals(bString) || "USED".equals(bString)) {
            aTotalSkillPoints = classNum >= 0 ? (aTotalSkillPoints += (float)SkillpointsToken.getUsedSkillPoints(pc, classNum)) : (aTotalSkillPoints += (float)SkillpointsToken.getUsedSkillPoints(pc));
        }
        return BigDecimalHelper.trimZeros(new BigDecimal(aTotalSkillPoints));
    }

    public static int getUnusedSkillPoints(PlayerCharacter pc) {
        float usedPoints = 0.0f;
        for (PCClass pcClass : pc.getDisplay().getClassSet()) {
            if (pcClass.getSkillPool(pc) <= 0) continue;
            usedPoints += (float)pcClass.getSkillPool(pc);
        }
        return (int)usedPoints;
    }

    public static int getUnusedSkillPoints(PlayerCharacter pc, int classNum) {
        float usedPoints = 0.0f;
        if (classNum < 0 || classNum >= pc.getDisplay().getClassCount()) {
            return 0;
        }
        PCClass pcClass = pc.getDisplay().getClassList().get(classNum);
        if (pcClass.getSkillPool(pc) > 0) {
            usedPoints += (float)pcClass.getSkillPool(pc);
        }
        return (int)usedPoints;
    }

    public static int getUsedSkillPoints(PlayerCharacter pc) {
        float usedPoints = 0.0f;
        for (Skill aSkill : pc.getDisplay().getSkillSet()) {
            for (PCClass pcc : pc.getSkillRankClasses(aSkill)) {
                Double rank = pc.getSkillRankForClass(aSkill, pcc);
                if (rank == null) {
                    rank = 0.0;
                }
                SkillCost skillCost = pc.getSkillCostForClass(aSkill, pcc);
                usedPoints = (float)((double)usedPoints + rank * (double)skillCost.getCost());
            }
        }
        return (int)usedPoints;
    }

    public static int getUsedSkillPoints(PlayerCharacter pc, int classNum) {
        CharacterDisplay display = pc.getDisplay();
        if (classNum < 0 || classNum >= display.getClassCount()) {
            return 0;
        }
        PCClass targetClass = display.getClassList().get(classNum);
        float usedPoints = 0.0f;
        for (Skill aSkill : display.getSkillSet()) {
            Integer outputIndex = pc.getSkillOrder(aSkill);
            if (!(pc.getRank(aSkill).doubleValue() > 0.0) && (outputIndex == null || outputIndex == 0)) continue;
            Double rank = pc.getSkillRankForClass(aSkill, targetClass);
            if (rank == null) {
                rank = 0.0;
            }
            SkillCost skillCost = pc.getSkillCostForClass(aSkill, targetClass);
            usedPoints = (float)((double)usedPoints + rank * (double)skillCost.getCost());
        }
        return (int)usedPoints;
    }
}

