/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import pcgen.system.LanguageBundle;

public class HtmlInfoBuilder {
    public static final String THREE_SPACES = " &nbsp; ";
    private final StringBuilder buffer = new StringBuilder(300);
    private final boolean fullDocument;

    public HtmlInfoBuilder() {
        this(null, true);
    }

    public HtmlInfoBuilder(String title) {
        this(title, true);
    }

    public HtmlInfoBuilder(String title, boolean fullDocument) {
        this.fullDocument = fullDocument;
        if (fullDocument) {
            this.buffer.append("<html>");
        }
        if (title != null) {
            this.appendTitleElement(title);
        }
    }

    public HtmlInfoBuilder append(String string) {
        this.buffer.append(string);
        return this;
    }

    public HtmlInfoBuilder appendIl8n(String key) {
        this.buffer.append(LanguageBundle.getString(key));
        return this;
    }

    public HtmlInfoBuilder append(char ch) {
        this.buffer.append(ch);
        return this;
    }

    public HtmlInfoBuilder appendLineBreak() {
        this.buffer.append("<br>");
        return this;
    }

    public HtmlInfoBuilder appendSpacer() {
        this.buffer.append(THREE_SPACES);
        return this;
    }

    public void appendSmallTitleElement(String title) {
        this.buffer.append("<b>").append(title).append("</b>");
    }

    public void appendTitleElement(String title) {
        this.buffer.append("<b><font size=+1>").append(title).append("</font></b>");
    }

    public HtmlInfoBuilder appendElement(String key, String value) {
        this.buffer.append("<b>").append(key).append(":</b>&nbsp;").append(value);
        return this;
    }

    public HtmlInfoBuilder appendI18nElement(String propertyKey, String value) {
        return this.appendElement(LanguageBundle.getString(propertyKey), value);
    }

    public HtmlInfoBuilder appendI18nFormattedElement(String propertyKey, String ... value) {
        this.buffer.append(LanguageBundle.getFormattedString(propertyKey, value));
        return this;
    }

    public void appendIconElement(String iconPath) {
        this.buffer.append("<img src=\"").append(iconPath).append("\" >&nbsp;");
    }

    public String toString() {
        if (this.fullDocument) {
            this.buffer.append("</html>");
        }
        return this.buffer.toString();
    }
}

