/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import pcgen.facade.util.event.ListEvent;
import pcgen.gui2.util.AbstractListMenu;

public abstract class AbstractRadioListMenu<E>
extends AbstractListMenu<E>
implements ItemListener {
    private final ButtonGroup group = new ButtonGroup();
    private Map<E, RadioMenuItem> menuMap = new HashMap<E, RadioMenuItem>();
    private E selectedItem = null;

    public AbstractRadioListMenu(Action action) {
        super(action);
    }

    @Override
    protected JMenuItem createMenuItem(E item, int index) {
        RadioMenuItem menuItem = new RadioMenuItem(item, item == this.selectedItem, this);
        this.group.add(menuItem);
        this.menuMap.put(item, menuItem);
        return menuItem;
    }

    @Override
    public void elementRemoved(ListEvent<E> e) {
        this.group.remove(this.getItem(e.getIndex()));
        this.menuMap.remove(e.getElement());
        super.elementRemoved(e);
    }

    public void setSelectedItem(E item) {
        JMenuItem menuItem = this.menuMap.get(item);
        if (menuItem != null) {
            menuItem.setSelected(true);
        }
    }

    public void clearSelection() {
        this.group.clearSelection();
    }

    private static class RadioMenuItem
    extends JRadioButtonMenuItem {
        private final Object item;

        public RadioMenuItem(Object item, boolean selected, ItemListener listener) {
            super(item.toString(), selected);
            this.item = item;
            this.addItemListener(listener);
        }

        @Override
        public Object[] getSelectedObjects() {
            return new Object[]{this.item};
        }
    }
}

