/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import pcgen.gui2.tools.BrowserLauncher;

class DesktopBrowserLauncher {
    private static Boolean isDesktopSupported = null;
    private static Boolean isBrowseSupported = null;
    private static Desktop desktop;

    DesktopBrowserLauncher() {
    }

    static final void browse(URI uri) throws IOException {
        if (DesktopBrowserLauncher.isDesktopSupported()) {
            DesktopBrowserLauncher.getDesktop().browse(uri);
        } else {
            BrowserLauncher.openURL(uri.toURL());
        }
    }

    private static Desktop getDesktop() {
        if (desktop == null) {
            desktop = Desktop.getDesktop();
        }
        return desktop;
    }

    static final void browse(File file) throws IOException {
        DesktopBrowserLauncher.browse(file.toURI());
    }

    private static boolean isDesktopSupported() {
        if (isDesktopSupported == null) {
            isDesktopSupported = Desktop.isDesktopSupported();
        }
        return isDesktopSupported;
    }

    static boolean isBrowseSupported() {
        if (isBrowseSupported == null) {
            isBrowseSupported = DesktopBrowserLauncher.isDesktopSupported() && DesktopBrowserLauncher.getDesktop().isSupported(Desktop.Action.BROWSE);
        }
        return isBrowseSupported;
    }
}

