/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.core.UnitSet;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.JComboBoxEx;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;

public class LanguagePanel
extends PCGenPrefsPanel {
    private static String in_language = LanguageBundle.getString("in_Prefs_language");
    private static String in_langEnglish = LanguageBundle.getString("in_Prefs_langEnglish");
    private static String in_langFrench = LanguageBundle.getString("in_Prefs_langFrench");
    private static String in_langGerman = LanguageBundle.getString("in_Prefs_langGerman");
    private static String in_langItalian = LanguageBundle.getString("in_Prefs_langItalian");
    private static String in_langSpanish = LanguageBundle.getString("in_Prefs_langSpanish");
    private static String in_langPortuguese = LanguageBundle.getString("in_Prefs_langPortuguese");
    private static String in_langSystem = LanguageBundle.getString("in_Prefs_langSystem");
    private String[] unitSetNames = null;
    private JRadioButton langEng;
    private JRadioButton langFre;
    private JRadioButton langGer;
    private JRadioButton langIt;
    private JRadioButton langEs;
    private JRadioButton langPt;
    private JRadioButton langSystem;
    private JComboBoxEx unitSetType = new JComboBoxEx();
    private String origLanguage;
    private String origUnitSet;

    public LanguagePanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_language);
        title1.setTitleJustification(4);
        this.setBorder(title1);
        this.setLayout(gridbag);
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(2, 2, 2, 2);
        ButtonGroup exclusiveGroup = new ButtonGroup();
        int line = 0;
        this.langSystem = new JRadioButton(in_langSystem);
        line = LanguagePanel.addLanguageOption(line, c, gridbag, this, this.langSystem, exclusiveGroup);
        TreeSet<JRadioButton> sorted = new TreeSet<JRadioButton>(new Comparator<JRadioButton>(){

            @Override
            public int compare(JRadioButton o1, JRadioButton o2) {
                return o1.getText().compareToIgnoreCase(o2.getText());
            }
        });
        this.langEng = new JRadioButton(in_langEnglish);
        sorted.add(this.langEng);
        this.langFre = new JRadioButton(in_langFrench);
        sorted.add(this.langFre);
        this.langGer = new JRadioButton(in_langGerman);
        sorted.add(this.langGer);
        this.langIt = new JRadioButton(in_langItalian);
        sorted.add(this.langIt);
        this.langEs = new JRadioButton(in_langSpanish);
        sorted.add(this.langEs);
        this.langPt = new JRadioButton(in_langPortuguese);
        sorted.add(this.langPt);
        for (JRadioButton b : sorted) {
            line = LanguagePanel.addLanguageOption(line, c, gridbag, this, b, exclusiveGroup);
        }
        Utility.buildConstraints(c, 0, line++, 3, 1, 0.0, 0.0);
        JLabel label = new JLabel();
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 0, line++, 3, 1, 0.0, 0.0);
        label = new JLabel();
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 0, line, 1, 1, 0.0, 0.0);
        GameMode gameMode = SettingsHandler.getGame();
        label = new JLabel(LanguageBundle.getFormattedString("in_Prefs_unitSetType", gameMode.getDisplayName()));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, line++, 1, 1, 0.0, 0.0);
        c.fill = 0;
        Collection<UnitSet> unitSets = SettingsHandler.getGame().getModeContext().getReferenceContext().getConstructedCDOMObjects(UnitSet.class);
        this.unitSetNames = new String[unitSets.size()];
        int i = 0;
        for (UnitSet unitSet : unitSets) {
            if (unitSet == null) continue;
            this.unitSetNames[i++] = unitSet.getDisplayName();
        }
        this.unitSetType = new JComboBoxEx(this.unitSetNames);
        gridbag.setConstraints(this.unitSetType, c);
        this.add(this.unitSetType);
        Utility.buildConstraints(c, 0, line++, 3, 1, 0.0, 0.0);
        label = new JLabel(LanguageBundle.getString("in_Prefs_restartInfo"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 5, line, 1, 1, 1.0, 1.0);
        c.fill = 1;
        label = new JLabel();
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    private static int addLanguageOption(int line, GridBagConstraints constraints, GridBagLayout gridbag, JPanel panel, JRadioButton button, ButtonGroup group) {
        Utility.buildConstraints(constraints, 0, line++, 2, 1, 0.0, 0.0);
        gridbag.setConstraints(button, constraints);
        panel.add(button);
        group.add(button);
        return line;
    }

    @Override
    public void applyOptionValuesToControls() {
        this.langEng.setSelected(false);
        this.langFre.setSelected(false);
        this.langGer.setSelected(false);
        this.langIt.setSelected(false);
        this.langEs.setSelected(false);
        this.langPt.setSelected(false);
        this.langSystem.setSelected(false);
        this.origLanguage = ConfigurationSettings.getLanguage();
        if (this.origLanguage == null || this.origLanguage.equals("")) {
            this.langSystem.setSelected(true);
        } else if (this.origLanguage.equals("en")) {
            this.langEng.setSelected(true);
        } else if (this.origLanguage.equals("fr")) {
            this.langFre.setSelected(true);
        } else if (this.origLanguage.equals("de")) {
            this.langGer.setSelected(true);
        } else if (this.origLanguage.equals("it")) {
            this.langIt.setSelected(true);
        } else if (this.origLanguage.equals("es")) {
            this.langEs.setSelected(true);
        } else if (this.origLanguage.equals("pt")) {
            this.langPt.setSelected(true);
        } else {
            this.langSystem.setSelected(true);
        }
        String string = this.origUnitSet = SettingsHandler.getGame() != null && SettingsHandler.getGame().getUnitSet() != null ? SettingsHandler.getGame().getUnitSet().getDisplayName() : "";
        if (this.unitSetType.getItemCount() > 0) {
            this.unitSetType.setSelectedIndex(0);
            Collection<UnitSet> unitSets = SettingsHandler.getGame().getModeContext().getReferenceContext().getConstructedCDOMObjects(UnitSet.class);
            for (int i = 0; i < unitSets.size(); ++i) {
                if (!this.unitSetNames[i].equals(SettingsHandler.getGame().getUnitSet().getDisplayName())) continue;
                this.unitSetType.setSelectedIndex(i);
            }
        }
    }

    @Override
    public String getTitle() {
        return in_language;
    }

    @Override
    public void setOptionsBasedOnControls() {
        String[] langCountry = this.getSelectedLangCountry();
        ConfigurationSettings.setLanguage(langCountry[0]);
        ConfigurationSettings.setCountry(langCountry[1]);
        SettingsHandler.getGame().selectUnitSet((String)this.unitSetType.getSelectedItem());
    }

    private String[] getSelectedLangCountry() {
        String[] langCountry = new String[2];
        if (this.langEng.isSelected()) {
            langCountry[0] = "en";
            langCountry[1] = "US";
        } else if (this.langFre.isSelected()) {
            langCountry[0] = "fr";
            langCountry[1] = "FR";
        } else if (this.langGer.isSelected()) {
            langCountry[0] = "de";
            langCountry[1] = "DE";
        } else if (this.langIt.isSelected()) {
            langCountry[0] = "it";
            langCountry[1] = "IT";
        } else if (this.langEs.isSelected()) {
            langCountry[0] = "es";
            langCountry[1] = "ES";
        } else if (this.langPt.isSelected()) {
            langCountry[0] = "pt";
            langCountry[1] = "PT";
        } else {
            langCountry[0] = "";
            langCountry[1] = "";
        }
        return langCountry;
    }

    @Override
    public boolean needsRestart() {
        String[] langCountry = this.getSelectedLangCountry();
        boolean needsRestart = !langCountry[0].equals(this.origLanguage);
        String unitSet = (String)this.unitSetType.getSelectedItem();
        if (unitSet == null) {
            unitSet = "";
        }
        return needsRestart |= !unitSet.equals(this.origUnitSet);
    }
}

