/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SizeAdjustment;
import pcgen.core.prereq.PrereqHandler;
import pcgen.rules.context.AbstractReferenceContext;

public final class WieldCategory
implements Loadable {
    private URI sourceURI;
    private String categoryName;
    private int handsRequired;
    private boolean isFinessable;
    private int sizeDifference;
    private Map<Integer, Float> damageMultiplier = new HashMap<Integer, Float>();
    private Map<Integer, CDOMSingleRef<WieldCategory>> wcSteps = new HashMap<Integer, CDOMSingleRef<WieldCategory>>();
    private List<QualifiedObject<CDOMSingleRef<WieldCategory>>> categorySwitches = new ArrayList<QualifiedObject<CDOMSingleRef<WieldCategory>>>();

    @Override
    public URI getSourceURI() {
        return this.sourceURI;
    }

    @Override
    public void setSourceURI(URI source) {
        this.sourceURI = source;
    }

    public void setKeyName(String key) {
        this.setName(key);
    }

    @Override
    public String getKeyName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.categoryName;
    }

    @Override
    public void setName(String name) {
        this.categoryName = name;
    }

    @Override
    public String getLSTformat() {
        return this.getDisplayName();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isType(String type) {
        return false;
    }

    public int getHandsRequired() {
        return this.handsRequired;
    }

    public void setHandsRequired(int hands) {
        this.handsRequired = hands;
    }

    public void setFinessable(boolean finessable) {
        this.isFinessable = finessable;
    }

    public boolean isFinessable() {
        return this.isFinessable;
    }

    public void setSizeDifference(int difference) {
        this.sizeDifference = difference;
    }

    public void setWieldCategoryStep(int location, CDOMSingleRef<WieldCategory> stepCat) {
        CDOMSingleRef<WieldCategory> previous = this.wcSteps.put(location, stepCat);
        if (previous != null) {
            // empty if block
        }
    }

    public void addDamageMult(int numHands, float mult) {
        Float previous = this.damageMultiplier.put(numHands, Float.valueOf(mult));
        if (previous != null) {
            // empty if block
        }
    }

    public WieldCategory getWieldCategoryStep(int steps) {
        CDOMSingleRef<WieldCategory> wcRef = this.wcSteps.get(steps);
        return wcRef == null ? null : wcRef.resolvesTo();
    }

    public void addCategorySwitch(QualifiedObject<CDOMSingleRef<WieldCategory>> qo) {
        this.categorySwitches.add(qo);
    }

    public int getObjectSizeInt(Equipment eq) {
        return eq.sizeInt() + this.sizeDifference;
    }

    public WieldCategory adjustForSize(PlayerCharacter pc, Equipment eq) {
        if (pc == null || eq == null || eq.get(ObjectKey.WIELD) == null) {
            return this;
        }
        SizeAdjustment oldEqSa = eq.getSizeAdjustment();
        if (pc.sizeInt() != eq.sizeInt()) {
            int aBump = 0;
            aBump += (int)pc.getTotalBonusTo("WIELDCATEGORY", eq.getWieldName());
            aBump += (int)pc.getTotalBonusTo("WIELDCATEGORY", "ALL");
            int modWield = 0;
            for (String eqType : eq.typeList()) {
                StringBuilder sB = new StringBuilder("WEAPONPROF=TYPE.");
                sB.append(eqType);
                int i = (int)pc.getTotalBonusTo(sB.toString(), "WIELDCATEGORY");
                if (i >= modWield) continue;
                modWield = i;
            }
            if ((aBump += modWield) != 0) {
                int newSizeInt = eq.sizeInt() + aBump;
                AbstractReferenceContext ref = Globals.getContext().getReferenceContext();
                SizeAdjustment sadj = ref.getSortedList(SizeAdjustment.class, IntegerKey.SIZEORDER).get(newSizeInt);
                eq.put(ObjectKey.SIZE, CDOMDirectSingleRef.getRef(sadj));
            }
        }
        WieldCategory pcWCat = this.getSwitch(pc, eq);
        eq.put(ObjectKey.SIZE, CDOMDirectSingleRef.getRef(oldEqSa));
        return pcWCat;
    }

    private WieldCategory getSwitch(PlayerCharacter pc, Equipment eq) {
        WieldCategory pcWCat = this;
        for (QualifiedObject<CDOMSingleRef<WieldCategory>> qo : this.categorySwitches) {
            if (!PrereqHandler.passesAll(qo.getPrerequisiteList(), eq, pc)) continue;
            pcWCat = qo.getRawObject().resolvesTo();
        }
        return pcWCat;
    }

    public int hashCode() {
        return this.categoryName.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof WieldCategory) {
            WieldCategory other = (WieldCategory)o;
            return this.categoryName.equals(other.categoryName);
        }
        return false;
    }
}

