/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.Collection;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.TransparentReference;

public class CDOMTransparentSingleRef<T extends Loadable>
extends CDOMSingleRef<T>
implements TransparentReference<T> {
    private CDOMSingleRef<T> subReference = null;

    public CDOMTransparentSingleRef(Class<T> objClass, String key) {
        super(objClass, key);
    }

    @Override
    public boolean contains(T item) {
        if (this.subReference == null) {
            throw new IllegalStateException("Cannot ask for contains: " + this.getReferenceClass().getName() + " Reference " + this.getName() + " has not been resolved");
        }
        return this.subReference.contains(item);
    }

    @Override
    public T resolvesTo() {
        if (this.subReference == null) {
            throw new IllegalStateException("Cannot ask for resolution: Reference has not been resolved");
        }
        return (T)((Loadable)this.subReference.resolvesTo());
    }

    @Override
    public boolean hasBeenResolved() {
        return this.subReference != null && this.subReference.hasBeenResolved();
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CDOMTransparentSingleRef) {
            CDOMTransparentSingleRef ref = (CDOMTransparentSingleRef)obj;
            return this.getReferenceClass().equals(ref.getReferenceClass()) && this.getName().equals(ref.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.getName().hashCode();
    }

    @Override
    public void addResolution(T item) {
        throw new IllegalStateException("Cannot resolve a Transparent Reference");
    }

    @Override
    public void resolve(ReferenceManufacturer<T> rm) {
        if (!rm.getReferenceClass().equals(this.getReferenceClass())) {
            throw new IllegalArgumentException("Cannot resolve a " + this.getReferenceClass().getSimpleName() + " Reference to a " + rm.getReferenceClass().getSimpleName());
        }
        this.subReference = rm.getReference(this.getName());
    }

    @Override
    public Collection<T> getContainedObjects() {
        return this.subReference.getContainedObjects();
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ALLOWS_UNION;
    }

    @Override
    public String getChoice() {
        return this.subReference == null ? null : this.subReference.getChoice();
    }

    @Override
    public void setChoice(String c) {
        throw new IllegalStateException("Cannot set Choice on a Transparent Reference");
    }
}

