/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.Collection;
import java.util.Collections;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;

public class CDOMCategorizedSingleRef<T extends Categorized<T>>
extends CDOMSingleRef<T>
implements CategorizedCDOMReference<T> {
    private T referencedObject = null;
    private final Category<T> category;
    private String choice = null;

    public CDOMCategorizedSingleRef(Class<T> objClass, Category<T> cat, String key) {
        super(objClass, key);
        if (cat == null) {
            throw new IllegalArgumentException("Cannot build CDOMCategorizedSingleRef with null category");
        }
        this.category = cat;
    }

    @Override
    public boolean contains(T item) {
        if (this.referencedObject == null) {
            throw new IllegalStateException("Cannot ask for contains: Reference has not been resolved");
        }
        return this.referencedObject.equals(item);
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getName();
    }

    @Override
    public T resolvesTo() {
        if (this.referencedObject == null) {
            throw new IllegalStateException("Cannot ask for resolution: Reference has not been resolved");
        }
        return this.referencedObject;
    }

    @Override
    public boolean hasBeenResolved() {
        return this.referencedObject != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CDOMCategorizedSingleRef) {
            CDOMCategorizedSingleRef ref = (CDOMCategorizedSingleRef)obj;
            return this.getReferenceClass().equals(ref.getReferenceClass()) && this.getName().equals(ref.getName()) && this.category.equals(ref.category);
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.getName().hashCode();
    }

    @Override
    public Category<T> getCDOMCategory() {
        return this.category;
    }

    @Override
    public void addResolution(T item) {
        Category<T> parent;
        if (this.referencedObject != null) {
            throw new IllegalStateException("Cannot resolve a Single Reference twice");
        }
        if (!item.getClass().equals(this.getReferenceClass())) {
            throw new IllegalArgumentException("Cannot resolve a " + this.getReferenceClass().getSimpleName() + " Reference to a " + item.getClass().getSimpleName());
        }
        if (!this.category.equals(item.getCDOMCategory()) && (parent = this.category.getParentCategory()) != null && !parent.equals(item.getCDOMCategory())) {
            throw new IllegalArgumentException("Cannot resolve " + this.getReferenceClass().getSimpleName() + " " + this.getName() + item.getCDOMCategory() + " Reference to category " + this.category);
        }
        this.referencedObject = item;
    }

    @Override
    public Collection<T> getContainedObjects() {
        return Collections.singleton(this.referencedObject);
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ALLOWS_UNION;
    }

    @Override
    public void setChoice(String c) {
        this.choice = c;
    }

    @Override
    public String getChoice() {
        return this.choice;
    }

    @Override
    public String getLSTCategory() {
        return this.category.getLSTformat();
    }
}

