/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.SubScopeFacetChangeEvent;
import pcgen.cdom.facet.event.SubScopeFacetChangeListener;

public class AbstractSubScopeFacet<S1, S2, T>
extends AbstractStorageFacet<CharID> {
    private final Map<Integer, SubScopeFacetChangeListener<? super S1, ? super S2, ? super T>[]> listeners = new TreeMap<Integer, SubScopeFacetChangeListener<? super S1, ? super S2, ? super T>[]>();

    private Map<S1, Map<S2, Map<T, Set<Object>>>> getConstructingInfo(CharID id) {
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(id);
        if (map == null) {
            map = new IdentityHashMap<S1, Map<S2, Map<T, Set<Object>>>>();
            this.setCache(id, map);
        }
        return map;
    }

    private Map<S1, Map<S2, Map<T, Set<Object>>>> getInfo(CharID id) {
        return (Map)this.getCache(id);
    }

    public void add(CharID id, S1 scope1, S2 scope2, T obj, Object source) {
        WrappedMapSet sources;
        boolean isNew;
        Map<T, Set<Object>> scope2Map;
        if (scope1 == null) {
            throw new IllegalArgumentException("Scope 1 cannot be null");
        }
        if (scope2 == null) {
            throw new IllegalArgumentException("Scope 2 cannot be null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getConstructingInfo(id);
        Map<S2, Map<T, Set<Object>>> scope1Map = map.get(scope1);
        if (scope1Map == null) {
            scope1Map = new IdentityHashMap<S2, Map<T, Set<Object>>>();
            map.put(scope1, scope1Map);
        }
        if ((scope2Map = scope1Map.get(scope2)) == null) {
            scope2Map = new IdentityHashMap<T, Set<Object>>();
            scope1Map.put(scope2, scope2Map);
        }
        boolean bl = isNew = (sources = scope2Map.get(obj)) == null;
        if (isNew) {
            sources = new WrappedMapSet(IdentityHashMap.class);
            scope2Map.put(obj, (Set<Object>)sources);
        }
        sources.add((Object)source);
        if (isNew) {
            this.fireSubScopeFacetChangeEvent(id, scope1, scope2, obj, 0);
        }
    }

    public void remove(CharID id, S1 scope1, S2 scope2, T obj, Object source) {
        if (scope1 == null) {
            throw new IllegalArgumentException("Scope 1 cannot be null");
        }
        if (scope2 == null) {
            throw new IllegalArgumentException("Scope 2 cannot be null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(id);
        if (map == null) {
            return;
        }
        Map<S2, Map<T, Set<Object>>> scope1Map = map.get(scope1);
        if (scope1Map == null) {
            return;
        }
        Map<T, Set<Object>> scope2Map = scope1Map.get(scope2);
        if (scope2Map == null) {
            return;
        }
        Set<Object> sources = scope2Map.get(obj);
        if (sources == null) {
            return;
        }
        if (sources.remove(source) && sources.isEmpty()) {
            this.fireSubScopeFacetChangeEvent(id, scope1, scope2, obj, 1);
            scope2Map.remove(obj);
        }
        if (scope2Map.isEmpty()) {
            scope1Map.remove(scope2);
        }
        if (scope1Map.isEmpty()) {
            map.remove(scope1);
        }
        if (map.isEmpty()) {
            this.removeCache(id);
        }
    }

    public Collection<T> getSet(CharID id, S1 scope1, S2 scope2) {
        if (scope1 == null) {
            throw new IllegalArgumentException("Scope 1 cannot be null");
        }
        if (scope2 == null) {
            throw new IllegalArgumentException("Scope 2 cannot be null");
        }
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(id);
        if (map == null) {
            return Collections.emptyList();
        }
        Map<S2, Map<T, Set<Object>>> scope1Map = map.get(scope1);
        if (scope1Map == null) {
            return Collections.emptyList();
        }
        Map<T, Set<Object>> scope2Map = scope1Map.get(scope2);
        if (scope2Map == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(scope2Map.keySet());
    }

    public int getSize(CharID id, S1 scope1, S2 scope2) {
        if (scope1 == null) {
            throw new IllegalArgumentException("Scope 1 cannot be null");
        }
        if (scope2 == null) {
            throw new IllegalArgumentException("Scope 2 cannot be null");
        }
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(id);
        if (map == null) {
            return 0;
        }
        Map<S2, Map<T, Set<Object>>> scope1Map = map.get(scope1);
        if (scope1Map == null) {
            return 0;
        }
        Map<T, Set<Object>> scope2Map = scope1Map.get(scope2);
        if (scope2Map == null) {
            return 0;
        }
        return scope2Map.size();
    }

    public boolean contains(CharID id, S1 scope1, S2 scope2, T obj) {
        if (scope1 == null) {
            throw new IllegalArgumentException("Scope 1 cannot be null");
        }
        if (scope2 == null) {
            throw new IllegalArgumentException("Scope 2 cannot be null");
        }
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(id);
        if (map == null) {
            return false;
        }
        Map<S2, Map<T, Set<Object>>> scope1Map = map.get(scope1);
        if (scope1Map == null) {
            return false;
        }
        Map<T, Set<Object>> scope2Map = scope1Map.get(scope2);
        return scope2Map != null && scope2Map.containsKey(obj);
    }

    public Collection<S1> getScopes1(CharID id) {
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(id);
        if (map == null) {
            return Collections.emptyList();
        }
        return new ArrayList<S1>(map.keySet());
    }

    public Collection<S2> getScopes2(CharID id, S1 scope1) {
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(id);
        if (map == null) {
            return Collections.emptyList();
        }
        Map<S2, Map<T, Set<Object>>> submap = map.get(scope1);
        if (submap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<S2>(submap.keySet());
    }

    public void removeAllFromSource(CharID id, Object source) {
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(id);
        if (map != null) {
            Iterator<Map.Entry<S1, Map<S2, Map<T, Set<Object>>>>> s1it = map.entrySet().iterator();
            while (s1it.hasNext()) {
                Map.Entry<S1, Map<S2, Map<T, Set<Object>>>> s1entry = s1it.next();
                S1 scope1 = s1entry.getKey();
                Map<S2, Map<T, Set<Object>>> scope1Map = s1entry.getValue();
                Iterator<Map.Entry<S2, Map<T, Set<Object>>>> s2it = scope1Map.entrySet().iterator();
                while (s2it.hasNext()) {
                    Map.Entry<S2, Map<T, Set<Object>>> s2entry = s2it.next();
                    S2 scope2 = s2entry.getKey();
                    Map<T, Set<Object>> scope2Map = s2entry.getValue();
                    Iterator<Map.Entry<T, Set<Object>>> lmit = scope2Map.entrySet().iterator();
                    while (lmit.hasNext()) {
                        Map.Entry<T, Set<Object>> lme = lmit.next();
                        Set<Object> sources = lme.getValue();
                        if (!sources.remove(source) || !sources.isEmpty()) continue;
                        T obj = lme.getKey();
                        lmit.remove();
                        this.fireSubScopeFacetChangeEvent(id, scope1, scope2, obj, 1);
                    }
                    if (!scope2Map.isEmpty()) continue;
                    s2it.remove();
                }
                if (!scope1Map.isEmpty()) continue;
                s1it.remove();
            }
            if (map.isEmpty()) {
                this.removeCache(id);
            }
        }
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(source);
        if (map != null) {
            for (Map.Entry<S1, Map<S2, Map<T, Set<Object>>>> l1me : map.entrySet()) {
                S1 scope1 = l1me.getKey();
                for (Map.Entry<S2, Map<T, Set<Object>>> l2me : l1me.getValue().entrySet()) {
                    S2 scope2 = l2me.getKey();
                    for (Map.Entry<T, Set<Object>> ome : l2me.getValue().entrySet()) {
                        T sp = ome.getKey();
                        for (Object spsource : ome.getValue()) {
                            this.add(copy, scope1, scope2, sp, spsource);
                        }
                    }
                }
            }
        }
    }

    public void addSubScopeFacetChangeListener(SubScopeFacetChangeListener<? super S1, ? super S2, ? super T> listener) {
        this.addSubScopeFacetChangeListener(0, listener);
    }

    public void addSubScopeFacetChangeListener(int priority, SubScopeFacetChangeListener<? super S1, ? super S2, ? super T> listener) {
        SubScopeFacetChangeListener<? super S1, ? super S2, ? super T>[] dfcl = this.listeners.get(priority);
        int newSize = dfcl == null ? 1 : dfcl.length + 1;
        SubScopeFacetChangeListener[] newArray = new SubScopeFacetChangeListener[newSize];
        if (dfcl != null) {
            System.arraycopy(dfcl, 0, newArray, 1, dfcl.length);
        }
        newArray[0] = listener;
        this.listeners.put(priority, newArray);
    }

    public void removeSubScopeFacetChangeListener(SubScopeFacetChangeListener<? super S1, ? super S2, ? super T> listener) {
        this.removeSubScopeFacetChangeListener(0, listener);
    }

    public void removeSubScopeFacetChangeListener(int priority, SubScopeFacetChangeListener<? super S1, ? super S2, ? super T> listener) {
        int newSize;
        SubScopeFacetChangeListener<? super S1, ? super S2, ? super T>[] dfcl = this.listeners.get(priority);
        if (dfcl == null) {
            return;
        }
        int foundLoc = -1;
        for (int i = newSize = dfcl.length - 1; i >= 0; --i) {
            if (dfcl[i] != listener) continue;
            foundLoc = i;
            break;
        }
        if (foundLoc != -1) {
            if (dfcl.length == 1) {
                this.listeners.remove(priority);
            } else {
                SubScopeFacetChangeListener[] newArray = new SubScopeFacetChangeListener[newSize];
                if (foundLoc != 0) {
                    System.arraycopy(dfcl, 0, newArray, 0, foundLoc);
                }
                if (foundLoc != newSize) {
                    System.arraycopy(dfcl, foundLoc + 1, newArray, foundLoc, newSize - foundLoc);
                }
                this.listeners.put(priority, newArray);
            }
        }
    }

    protected void fireSubScopeFacetChangeEvent(CharID id, S1 scope1, S2 scope2, T node, int type) {
        for (SubScopeFacetChangeListener<? super S1, ? super S2, ? super T>[] dfclArray : this.listeners.values()) {
            SubScopeFacetChangeEvent<S1, S2, T> ccEvent = null;
            block5: for (int i = dfclArray.length - 1; i >= 0; --i) {
                if (ccEvent == null) {
                    ccEvent = new SubScopeFacetChangeEvent<S1, S2, T>(id, scope1, scope2, node, this, type);
                }
                SubScopeFacetChangeListener<S1, S2, T> dfcl = dfclArray[i];
                switch (ccEvent.getEventType()) {
                    case 0: {
                        dfcl.dataAdded(ccEvent);
                        continue block5;
                    }
                    case 1: {
                        dfcl.dataRemoved(ccEvent);
                        continue block5;
                    }
                }
            }
        }
    }

    public boolean containsFor(CharID id, S1 scope1) {
        Map<S1, Map<S2, Map<T, Set<Object>>>> map = this.getInfo(id);
        return map != null && map.containsKey(scope1);
    }
}

