/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.BasicClassIdentity;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseInformationUtilities;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.ClassIdentity;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.helper.SpellLevel;
import pcgen.cdom.helper.SpellLevelInfo;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.CDOMChoiceManager;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.rules.context.LoadContext;

public class SpellLevelChooseInformation
implements ChooseInformation<SpellLevel> {
    private static final ClassIdentity<SpellLevel> SPELLLEVEL_INFO = BasicClassIdentity.getInstance(SpellLevel.class);
    private final List<SpellLevelInfo> info;
    private final String setName;
    private String title = null;
    private Chooser<SpellLevel> choiceActor;

    public SpellLevelChooseInformation(String name, List<SpellLevelInfo> choice) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (choice == null) {
            throw new IllegalArgumentException("PrimitiveChoiceSet cannot be null");
        }
        this.info = new ArrayList<SpellLevelInfo>(choice);
        if (this.info.isEmpty()) {
            throw new IllegalArgumentException("PrimitiveChoiceSet cannot be null");
        }
        this.setName = name;
    }

    @Override
    public void setChoiceActor(Chooser<SpellLevel> actor) {
        this.choiceActor = actor;
    }

    @Override
    public String encodeChoice(SpellLevel choice) {
        return this.choiceActor.encodeChoice(choice);
    }

    @Override
    public SpellLevel decodeChoice(LoadContext context, String persistenceFormat) {
        return (SpellLevel)this.choiceActor.decodeChoice(context, persistenceFormat);
    }

    @Override
    public Chooser<SpellLevel> getChoiceActor() {
        return this.choiceActor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpellLevelChooseInformation) {
            SpellLevelChooseInformation other = (SpellLevelChooseInformation)obj;
            if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
                return false;
            }
            return this.setName.equals(other.setName) && this.info.equals(other.info);
        }
        return false;
    }

    public int hashCode() {
        return this.setName.hashCode() + 29;
    }

    @Override
    public String getLSTformat() {
        return StringUtil.join(this.info, (String)"|");
    }

    @Override
    public ClassIdentity<SpellLevel> getClassIdentity() {
        return SPELLLEVEL_INFO;
    }

    @Override
    public Collection<SpellLevel> getSet(PlayerCharacter pc) {
        HashSet<SpellLevel> list = new HashSet<SpellLevel>();
        for (SpellLevelInfo sli : this.info) {
            list.addAll(sli.getLevels(pc));
        }
        return list;
    }

    @Override
    public String getName() {
        return this.setName;
    }

    public void setTitle(String choiceTitle) {
        this.title = choiceTitle;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ALLOWS_NONE;
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, SpellLevel choice) {
        this.choiceActor.restoreChoice(pc, owner, choice);
    }

    @Override
    public ChoiceManagerList<SpellLevel> getChoiceManager(ChooseDriver owner, int cost) {
        return new CDOMChoiceManager<SpellLevel>(owner, this, null, cost);
    }

    @Override
    public CharSequence composeDisplay(Collection<? extends SpellLevel> collection) {
        return ChooseInformationUtilities.buildEncodedString(this, collection);
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, SpellLevel item) {
        this.choiceActor.removeChoice(pc, owner, item);
    }
}

