/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.StatLock;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCStat;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class DefineStatLst
implements CDOMPrimaryToken<CDOMObject> {
    private static final Class<PCStat> PCSTAT_CLASS = PCStat.class;

    public String getTokenName() {
        return "DEFINESTAT";
    }

    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        DefineStatSubToken subToken;
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        if (!sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + " may not be empty", context);
        }
        String firstItem = sep.next();
        try {
            subToken = DefineStatSubToken.valueOf(firstItem);
        }
        catch (IllegalArgumentException e1) {
            return new ParseResult.Fail("Found unexpected sub tag " + firstItem + " in " + this.getTokenName() + ":" + value + ". Must be one of " + StringUtils.join((Object[])DefineStatSubToken.values(), (String)", ") + ".", context);
        }
        if (!sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + ":" + (Object)((Object)subToken) + "| must be followed by a stat.", context);
        }
        String statKey = sep.next();
        CDOMSingleRef stat = context.getReferenceContext().getCDOMReference(PCSTAT_CLASS, statKey);
        Formula f = null;
        if (subToken == DefineStatSubToken.LOCK || subToken == DefineStatSubToken.MINVALUE || subToken == DefineStatSubToken.MAXVALUE) {
            if (!sep.hasNext()) {
                return new ParseResult.Fail(this.getTokenName() + ":" + (Object)((Object)subToken) + "| must be followed by both a stat and a value.", context);
            }
            String formula = sep.next();
            f = FormulaFactory.getFormulaFor((String)formula);
            if (!f.isValid()) {
                return new ParseResult.Fail("Formula in " + this.getTokenName() + " was not valid: " + f.toString(), context);
            }
        }
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + ":" + value + " has too many pipe separated item.", context);
        }
        switch (subToken) {
            case LOCK: {
                context.getObjectContext().addToList(obj, ListKey.STAT_LOCKS, (Object)new StatLock(stat, f));
                break;
            }
            case UNLOCK: {
                context.getObjectContext().addToList(obj, ListKey.UNLOCKED_STATS, (Object)stat);
                break;
            }
            case NONSTAT: {
                context.getObjectContext().addToList(obj, ListKey.NONSTAT_STATS, (Object)stat);
                break;
            }
            case STAT: {
                context.getObjectContext().addToList(obj, ListKey.NONSTAT_TO_STAT_STATS, (Object)stat);
                break;
            }
            case MINVALUE: {
                context.getObjectContext().addToList(obj, ListKey.STAT_MINVALUE, (Object)new StatLock(stat, f));
                break;
            }
            case MAXVALUE: {
                context.getObjectContext().addToList(obj, ListKey.STAT_MAXVALUE, (Object)new StatLock(stat, f));
            }
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes lockChanges = context.getObjectContext().getListChanges(obj, ListKey.STAT_LOCKS);
        Changes ulchanges = context.getObjectContext().getListChanges(obj, ListKey.UNLOCKED_STATS);
        Changes nonStatChanges = context.getObjectContext().getListChanges(obj, ListKey.NONSTAT_STATS);
        Changes nonStatToStatChanges = context.getObjectContext().getListChanges(obj, ListKey.NONSTAT_TO_STAT_STATS);
        Changes minValueChanges = context.getObjectContext().getListChanges(obj, ListKey.STAT_MINVALUE);
        Changes maxValueChanges = context.getObjectContext().getListChanges(obj, ListKey.STAT_MAXVALUE);
        TreeSet<String> set = new TreeSet<String>();
        if (lockChanges != null && !lockChanges.isEmpty()) {
            if (lockChanges.includesGlobalClear()) {
                context.addWriteMessage("DEFINE:LOCK does not support .CLEAR");
                return null;
            }
            if (lockChanges.hasAddedItems()) {
                for (StatLock sl : lockChanges.getAdded()) {
                    set.add("LOCK|" + sl.getLSTformat() + "|" + sl.getLockValue());
                }
            }
        }
        if (ulchanges != null && !ulchanges.isEmpty()) {
            if (ulchanges.includesGlobalClear()) {
                context.addWriteMessage("DEFINE:UNLOCK does not support .CLEAR");
                return null;
            }
            if (ulchanges.hasAddedItems()) {
                for (CDOMSingleRef st : ulchanges.getAdded()) {
                    set.add("UNLOCK|" + st.getLSTformat(false));
                }
            }
        }
        if (nonStatChanges != null && !nonStatChanges.isEmpty() && nonStatChanges.hasAddedItems()) {
            for (CDOMSingleRef st : nonStatChanges.getAdded()) {
                set.add("NONSTAT|" + st.getLSTformat(false));
            }
        }
        if (nonStatToStatChanges != null && !nonStatToStatChanges.isEmpty() && nonStatToStatChanges.hasAddedItems()) {
            for (CDOMSingleRef st : nonStatToStatChanges.getAdded()) {
                set.add("STAT|" + st.getLSTformat(false));
            }
        }
        if (minValueChanges != null && !minValueChanges.isEmpty() && minValueChanges.hasAddedItems()) {
            for (StatLock sl : minValueChanges.getAdded()) {
                set.add("MINVALUE|" + sl.getLSTformat() + "|" + sl.getLockValue());
            }
        }
        if (maxValueChanges != null && !maxValueChanges.isEmpty() && maxValueChanges.hasAddedItems()) {
            for (StatLock sl : maxValueChanges.getAdded()) {
                set.add("MAXVALUE|" + sl.getLSTformat() + "|" + sl.getLockValue());
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public static enum DefineStatSubToken {
        LOCK,
        UNLOCK,
        NONSTAT,
        STAT,
        MINVALUE,
        MAXVALUE;

    }
}

