/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDParser;
import com.wutka.jox.DescCacheKey;
import com.wutka.jox.JOXDateHandler;
import com.wutka.jox.JOXOutput;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class JOXBeanOutput {
    public static final int WRITE_AS_ATTRIBUTE = 1;
    public static final int WRITE_AS_ELEMENT = 2;
    public static final int WRITE_AS_INDEXED_ELEMENT = 3;
    protected DateFormat dateFormat = JOXDateHandler.determineDateFormat();
    protected boolean dateFormatIsDefault = true;
    protected static Object[] getParams = new Object[0];
    protected Hashtable nameTranslation;
    protected Hashtable attrTranslation;
    protected Hashtable childTranslation;
    protected Hashtable propertyDescCache;
    protected static Hashtable beanCache = new Hashtable();
    protected DTD dtd;
    protected JOXOutput outputStream;
    protected boolean writeAttributes;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;

    protected JOXBeanOutput() {
    }

    public JOXBeanOutput(String string, JOXOutput jOXOutput) throws IOException {
        this.outputStream = jOXOutput;
        this.dtd = this.readDTD(string);
        this.setupNameTranslation();
        this.propertyDescCache = new Hashtable();
        this.writeAttributes = false;
    }

    public JOXBeanOutput(DTD dTD, JOXOutput jOXOutput) throws IOException {
        this.outputStream = jOXOutput;
        this.dtd = dTD;
        this.setupNameTranslation();
        this.propertyDescCache = new Hashtable();
        this.writeAttributes = false;
    }

    public JOXBeanOutput(JOXOutput jOXOutput, boolean bl) {
        this.outputStream = jOXOutput;
        this.writeAttributes = bl;
        this.nameTranslation = null;
    }

    synchronized void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.dateFormatIsDefault = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DTD readDTD(String string) throws IOException {
        Reader reader = null;
        try {
            try {
                URL uRL = new URL(string);
                DTDParser dTDParser = new DTDParser(uRL, false);
                DTD dTD = dTDParser.parse(false);
                Object var7_8 = null;
                if (reader == null) return dTD;
                try {
                    reader.close();
                    return dTD;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return dTD;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (reader == null) throw throwable;
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            reader.close();
            throw throwable;
        }
    }

    public void writeObject(String string, Object object) throws IOException {
        String string2 = this.getTranslatedEntityName(string);
        if (string2 == null) {
            return;
        }
        this.outputStream.writeString("<");
        this.outputStream.writeString(string2);
        this.writeObjectFields(string2, object, 1);
        this.outputStream.writeString(">\n");
        this.writeObjectFields(string2, object, 2);
        this.outputStream.writeString("</");
        this.outputStream.writeString(string2);
        this.outputStream.writeString(">\n");
    }

    public void writeObjectFields(String string, Object object, int n) throws IOException {
        if (object == null) {
            return;
        }
        try {
            BeanInfo beanInfo = (BeanInfo)beanCache.get(object.getClass());
            if (beanInfo == null) {
                beanInfo = Introspector.getBeanInfo(object.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = JOXBeanOutput.class$("java.lang.Object")) : class$java$lang$Object);
                beanCache.put(object.getClass(), beanInfo);
            }
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (this.dtd != null && n == 2) {
                propertyDescriptorArray = this.filterPropertyDescriptors(propertyDescriptorArray, string, object.getClass());
            }
            int n2 = 0;
            while (n2 < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n2] instanceof IndexedPropertyDescriptor) {
                    if (n == 2) {
                        this.writeIndexedProperty(string, object, (IndexedPropertyDescriptor)propertyDescriptorArray[n2]);
                    }
                } else {
                    this.writeProperty(string, object, propertyDescriptorArray[n2], n);
                }
                ++n2;
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new IOException("Got introspection exception " + introspectionException.toString());
        }
    }

    public void writeProperty(String string, Object object, PropertyDescriptor propertyDescriptor, int n) throws IOException {
        try {
            Method method = propertyDescriptor.getReadMethod();
            if (method == null) {
                return;
            }
            Object object2 = method.invoke(object, getParams);
            this.writePropertyValue(string, object2, propertyDescriptor, n);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Unable to read property " + propertyDescriptor.getName() + ": " + invocationTargetException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to read property " + propertyDescriptor.getName() + ": " + illegalAccessException.toString());
        }
    }

    public void writeIndexedProperty(String string, Object object, IndexedPropertyDescriptor indexedPropertyDescriptor) throws IOException {
        try {
            Method method = indexedPropertyDescriptor.getReadMethod();
            if (method == null) {
                return;
            }
            Object[] objectArray = (Object[])method.invoke(object, getParams);
            this.writePropertyValue(string, objectArray, indexedPropertyDescriptor, 3);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Unable to read property " + indexedPropertyDescriptor.getName() + ": " + invocationTargetException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to read property " + indexedPropertyDescriptor.getName() + ": " + illegalAccessException.toString());
        }
    }

    public void writePropertyValue(String string, Object object, PropertyDescriptor propertyDescriptor, int n) throws IOException {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz.isArray() && object != null) {
            clazz = clazz.getComponentType();
            int n2 = Array.getLength(object);
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = Array.get(object, n3);
                this.writePropertyValueByType(string, object2, propertyDescriptor, n, clazz);
                ++n3;
            }
        } else {
            this.writePropertyValueByType(string, object, propertyDescriptor, n, clazz);
        }
    }

    public void writePropertyValueByType(String string, Object object, PropertyDescriptor propertyDescriptor, int n, Class clazz) throws IOException {
        if (clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Byte.TYPE) || clazz.equals(Boolean.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Double.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXBeanOutput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXBeanOutput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXBeanOutput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXBeanOutput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXBeanOutput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXBeanOutput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXBeanOutput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz)) {
            if (object != null) {
                this.writeBasicType(string, propertyDescriptor.getName(), object, n);
            }
        } else if ((class$java$lang$String == null ? (class$java$lang$String = JOXBeanOutput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            if (object != null) {
                this.writeString(string, propertyDescriptor.getName(), object, n);
            }
        } else if ((class$java$util$Date == null ? (class$java$util$Date = JOXBeanOutput.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz)) {
            if (object != null) {
                this.writeDate(string, propertyDescriptor.getName(), object, n);
            }
        } else if ((n == 2 || n == 3) && object != null) {
            this.writeObject(propertyDescriptor.getName(), object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBasicType(String string, String string2, Object object, int n) throws IOException {
        String string3 = this.getTranslatedChildName(string, string2);
        if (string3 == null) {
            return;
        }
        if ((this.writeAttributes || this.writeAsAttribute(string, string3)) && n != 3) {
            if (n != 1) return;
            this.outputStream.writeString(" ");
            this.outputStream.writeString(string3);
            this.outputStream.writeString("=\"");
            this.outputStream.writeString(object.toString());
            this.outputStream.writeString("\"");
            return;
        } else {
            if (n == 1) return;
            this.outputStream.writeString("<");
            this.outputStream.writeString(string3);
            this.outputStream.writeString(">");
            this.outputStream.writeString(object.toString());
            this.outputStream.writeString("</");
            this.outputStream.writeString(string3);
            this.outputStream.writeString(">\n");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeString(String string, String string2, Object object, int n) throws IOException {
        String string3 = this.getTranslatedChildName(string, string2);
        if (string3 == null) {
            return;
        }
        if ((this.writeAttributes || this.writeAsAttribute(string, string3)) && n != 3) {
            if (n != 1) return;
            this.outputStream.writeString(" ");
            this.outputStream.writeString(string3);
            this.outputStream.writeString("=\"");
            this.outputStream.writeString((String)object);
            this.outputStream.writeString("\"");
            return;
        } else {
            if (n == 1) return;
            this.outputStream.writeString("<");
            this.outputStream.writeString(string3);
            this.outputStream.writeString(">");
            String string4 = (String)object;
            if (string4.indexOf(60) >= 0 || string4.indexOf(62) >= 0 || string4.indexOf(38) >= 0) {
                this.outputStream.writeString("<![CDATA[\n");
                this.outputStream.writeString(string4);
                this.outputStream.writeString("]]>\n");
            } else {
                this.outputStream.writeString(string4);
            }
            this.outputStream.writeString("</");
            this.outputStream.writeString(string3);
            this.outputStream.writeString(">\n");
        }
    }

    public void writeDate(String string, String string2, Object object, int n) throws IOException {
        String string3 = this.getTranslatedChildName(string, string2);
        if (string3 == null) {
            return;
        }
        if ((this.writeAttributes || this.writeAsAttribute(string, string3)) && n != 3) {
            if (n == 1) {
                this.outputStream.writeString(" ");
                this.outputStream.writeString(string3);
                this.outputStream.writeString("=\"");
                this.outputStream.writeString(this.dateFormat.format((Date)object));
                this.outputStream.writeString("\"");
            }
        } else if (n != 1) {
            this.outputStream.writeString("<");
            this.outputStream.writeString(string3);
            if (!this.dateFormatIsDefault) {
                try {
                    SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.dateFormat;
                    this.outputStream.writeString(" format=\"");
                    this.outputStream.writeString(simpleDateFormat.toPattern());
                    this.outputStream.writeString("\"");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.outputStream.writeString(">");
            this.outputStream.writeString(this.dateFormat.format((Date)object));
            this.outputStream.writeString("</");
            this.outputStream.writeString(string3);
            this.outputStream.writeString(">\n");
        }
    }

    public String stripName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = Character.toLowerCase(string.charAt(n2));
            if (c != '-' && c != '_' && c != '.' && c != ':') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void setupNameTranslation() {
        this.nameTranslation = new Hashtable();
        this.attrTranslation = new Hashtable();
        this.childTranslation = new Hashtable();
        Enumeration enumeration = this.dtd.elements.elements();
        while (enumeration.hasMoreElements()) {
            DTDElement dTDElement = (DTDElement)enumeration.nextElement();
            String string = this.stripName(dTDElement.name);
            this.nameTranslation.put(string, dTDElement.name);
            Hashtable hashtable = new Hashtable();
            DTDItem dTDItem = dTDElement.getContent();
            if (dTDItem instanceof DTDContainer) {
                this.expandChildElements((DTDContainer)dTDItem, hashtable);
            }
            this.childTranslation.put(string, hashtable);
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Enumeration enumeration2 = dTDElement.attributes.elements();
            while (enumeration2.hasMoreElements()) {
                DTDAttribute dTDAttribute = (DTDAttribute)enumeration2.nextElement();
                String string2 = this.stripName(dTDAttribute.getName());
                hashtable2.put(string2, dTDAttribute.getName());
            }
            this.attrTranslation.put(string, hashtable2);
        }
    }

    public void expandChildElements(DTDContainer dTDContainer, Hashtable hashtable) {
        Enumeration enumeration = dTDContainer.getItemsVec().elements();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            Object e = enumeration.nextElement();
            if (e instanceof DTDElement) {
                string2 = ((DTDElement)e).getName();
                string = this.stripName(string2);
                hashtable.put(string, string2);
                continue;
            }
            if (e instanceof DTDContainer) {
                this.expandChildElements((DTDContainer)e, hashtable);
                continue;
            }
            if (!(e instanceof DTDName)) continue;
            string2 = ((DTDName)e).getValue();
            string = this.stripName(string2);
            hashtable.put(string, string2);
        }
    }

    public String getTranslatedEntityName(String string) {
        if (this.nameTranslation == null) {
            return string;
        }
        String string2 = (String)this.nameTranslation.get(this.stripName(string));
        return string2;
    }

    public String getTranslatedChildName(String string, String string2) {
        String string3;
        if (this.nameTranslation == null) {
            return string2;
        }
        String string4 = this.stripName(string);
        Hashtable hashtable = (Hashtable)this.childTranslation.get(string4);
        Hashtable hashtable2 = (Hashtable)this.attrTranslation.get(string4);
        if (hashtable == null && hashtable2 == null) {
            return this.getTranslatedEntityName(string2);
        }
        String string5 = this.stripName(string2);
        if (hashtable2 != null && (string3 = (String)hashtable2.get(string5)) != null) {
            return string3;
        }
        if (hashtable != null && (string3 = (String)hashtable.get(string5)) != null) {
            return string3;
        }
        return null;
    }

    public boolean writeAsAttribute(String string, String string2) {
        if (this.nameTranslation == null) {
            return false;
        }
        Hashtable hashtable = (Hashtable)this.attrTranslation.get(this.stripName(string));
        if (hashtable == null) {
            return false;
        }
        return hashtable.get(this.stripName(string2)) != null;
    }

    protected PropertyDescriptor[] filterPropertyDescriptors(PropertyDescriptor[] propertyDescriptorArray, String string, Class clazz) {
        Object[] objectArray;
        PropertyDescriptor[] propertyDescriptorArray2 = (PropertyDescriptor[])this.propertyDescCache.get(new DescCacheKey(string, clazz));
        if (propertyDescriptorArray2 != null) {
            return propertyDescriptorArray2;
        }
        Vector vector = new Vector();
        DTDElement dTDElement = (DTDElement)this.dtd.elements.get(this.getTranslatedEntityName(string));
        if (dTDElement == null) {
            this.propertyDescCache.put(new DescCacheKey(string, clazz), propertyDescriptorArray);
            return propertyDescriptorArray;
        }
        DTDItem dTDItem = dTDElement.content;
        if (!(dTDItem instanceof DTDContainer)) {
            this.propertyDescCache.put(new DescCacheKey(string, clazz), propertyDescriptorArray);
            return propertyDescriptorArray;
        }
        Hashtable<Object[], PropertyDescriptor> hashtable = new Hashtable<Object[], PropertyDescriptor>();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            objectArray = this.getTranslatedChildName(string, propertyDescriptorArray[n].getName());
            if (objectArray != null) {
                hashtable.put(objectArray, propertyDescriptorArray[n]);
            }
            ++n;
        }
        this.extractPropertyOrder((DTDContainer)dTDItem, hashtable, vector);
        objectArray = new PropertyDescriptor[vector.size()];
        vector.copyInto(objectArray);
        this.propertyDescCache.put(new DescCacheKey(string, clazz), objectArray);
        return objectArray;
    }

    protected void extractPropertyOrder(DTDContainer dTDContainer, Hashtable hashtable, Vector vector) {
        Enumeration enumeration = dTDContainer.getItemsVec().elements();
        while (enumeration.hasMoreElements()) {
            DTDItem dTDItem = (DTDItem)enumeration.nextElement();
            if (dTDItem instanceof DTDName) {
                DTDName dTDName = (DTDName)dTDItem;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)hashtable.get(dTDName.value);
                if (propertyDescriptor == null || vector.contains(propertyDescriptor)) continue;
                vector.addElement(propertyDescriptor);
                continue;
            }
            if (!(dTDItem instanceof DTDContainer)) continue;
            this.extractPropertyOrder((DTDContainer)dTDItem, hashtable, vector);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

