/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.pivots;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.internal.FluentButtonFactory;
import com.jgoodies.fluent.pivots.Pivot;
import com.jgoodies.fluent.pivots.PivotModel;
import com.jgoodies.layout.builder.FormBuilder;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public final class PivotBar
extends JPanel {
    private final PivotModel model;
    private final PivotBarFactory factory;
    private final List<JToggleButton> buttons = new ArrayList<JToggleButton>();
    private ButtonGroup buttonGroup = new ButtonGroup();

    public PivotBar(PivotModel model) {
        this(model, null);
    }

    public PivotBar(PivotModel model, Theme theme) {
        this.model = Preconditions.checkNotNull(model, "The %s must not be null.", "tab set");
        this.factory = new PivotBarFactory(theme);
        this.initEventHandling();
        this.rebuildPanel();
    }

    private void initEventHandling() {
        this.model.addPropertyChangeListener("selectedIndex", this::onSelectedIndexChanged);
        this.model.addPropertyChangeListener("views", this::onViewsChanged);
    }

    private void onSelectedIndexChanged(PropertyChangeEvent evt) {
        if (this.buttons.isEmpty()) {
            return;
        }
        int index = (Integer)evt.getNewValue();
        JToggleButton button = this.buttons.get(index);
        button.setSelected(true);
        this.scrollRectToVisible(button.getBounds());
    }

    private void onViewsChanged(PropertyChangeEvent evt) {
        this.rebuildPanel();
    }

    private void rebuildPanel() {
        this.removeAll();
        this.buttons.clear();
        this.buttonGroup = new ButtonGroup();
        List<Pivot> pivots = this.model.getPivots();
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("14epx, %s*(pref)", pivots.size() + 1)).rows("f:[40epx, p]", new Object[0])).panel(this)).background(this.factory.getTheme().background());
        int x = 2;
        for (Pivot pivot : pivots) {
            Pivot.DefaultPivot defaultPivot;
            JToggleButton tabButton = this.factory.createPivotButton(this.model, pivot);
            if (pivot instanceof Pivot.DefaultPivot && (defaultPivot = (Pivot.DefaultPivot)pivot).getOnContextMenu() != null) {
                tabButton.addMouseListener(Listeners.contextMenu(defaultPivot.getOnContextMenu()));
            }
            builder.add(tabButton).xy(x++, 1);
            this.buttonGroup.add(tabButton);
            this.buttons.add(tabButton);
        }
        this.revalidate();
        this.repaint();
    }

    static final class PivotBarFactory
    extends FluentButtonFactory {
        PivotBarFactory(Theme theme) {
            super(theme);
        }

        public JToggleButton createPivotButton(PivotModel pivotModel, Pivot item) {
            FluentButtonFactory.NavigationToggleButton button = this.createToggleButton(new PivotButtonAction(pivotModel, item), FluentButtonFactory.SelectionMarkerMode.HORIZONTAL);
            button.setSelected(item == pivotModel.getSelectedPivot());
            button.setDeselectedFont(this.fluentResources.getAppBarButtonFont());
            button.setSelectedFont(this.fluentResources.getAppBarButtonSelectedFont());
            return button;
        }
    }

    static final class PivotButtonAction
    extends AbstractAction {
        private final PivotModel tabSet;
        private final Pivot item;

        PivotButtonAction(PivotModel tabSet, Pivot item) {
            super(item.getTextWithBadge());
            this.tabSet = tabSet;
            this.item = item;
            this.putValue("ShortDescription", item.getToolTipText());
            this.putValue("AcceleratorKey", item.getAccelerator());
            this.putValue("AccessibleNameKey", item.getAccessibleName());
            item.addPropertyChangeListener(this::onItemPropertyChanged);
        }

        private void onItemPropertyChanged(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("text".equals(propertyName) || "badge".equals(propertyName)) {
                this.putValue("Name", this.item.getTextWithBadge());
            }
            if ("toolTipText".equals(propertyName)) {
                this.putValue("ShortDescription", this.item.getToolTipText());
            }
            if ("accelerator".equals(propertyName)) {
                this.putValue("AcceleratorKey", this.item.getAccelerator());
            }
            if ("accessibleName".equals(propertyName)) {
                this.putValue("AccessibleNameKey", this.item.getAccessibleName());
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((JToggleButton)evt.getSource()).setSelected(true);
            this.tabSet.setSelectedPivot(this.item);
        }
    }
}

