/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.condition;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.spockframework.runtime.condition.IObjectRenderer;
import org.spockframework.runtime.condition.IObjectRendererService;
import org.spockframework.util.InternalSpockError;

public class ObjectRendererService
implements IObjectRendererService {
    private final HashMap<Class<?>, IObjectRenderer<?>> renderers = new HashMap();

    @Override
    public <T> void addRenderer(Class<T> type, IObjectRenderer<? super T> renderer) {
        this.renderers.put(type, renderer);
    }

    @Override
    public String render(Object object) {
        if (object == null) {
            return "null\n";
        }
        Set<Class<?>> types = Collections.singleton(object.getClass());
        while (!types.isEmpty()) {
            for (Class<?> type : types) {
                IObjectRenderer<?> renderer = this.renderers.get(type);
                if (renderer == null) continue;
                return renderer.render(object);
            }
            types = this.getParents(types);
        }
        IObjectRenderer<?> renderer = this.renderers.get(Object.class);
        if (renderer != null) {
            return renderer.render(object);
        }
        throw new InternalSpockError("no renderer for type Object found");
    }

    private Set<Class<?>> getParents(Set<Class<?>> types) {
        HashSet parents = new HashSet();
        for (Class<?> type : types) {
            Class<?> superclass = type.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                parents.add(superclass);
            }
            parents.addAll(Arrays.asList(type.getInterfaces()));
        }
        return parents;
    }
}

