/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.Board;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.InfernoTracker;
import megamek.common.xml.BuildingEncoder;
import megamek.common.xml.CoordsEncoder;
import megamek.common.xml.HexEncoder;

public class BoardEncoder {
    public static void encode(IBoard iBoard, Writer writer) throws IOException {
        if (null == iBoard) {
            throw new IllegalArgumentException("The board is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<board version=\"1.0\" >");
        writer.write("<boardData width=\"");
        writer.write(Integer.toString(iBoard.getWidth()));
        writer.write("\" height=\"");
        writer.write(Integer.toString(iBoard.getHeight()));
        writer.write("\" roadsAutoExit=\"");
        writer.write(iBoard.getRoadsAutoExit() ? "true" : "false");
        writer.write("\" >");
        for (int i = 0; i < iBoard.getHeight(); ++i) {
            for (int j = 0; j < iBoard.getWidth(); ++j) {
                HexEncoder.encode(iBoard.getHex(j, i), writer);
            }
        }
        writer.write("</boardData>");
        Enumeration<Serializable> enumeration = iBoard.getBuildings();
        if (enumeration.hasMoreElements()) {
            writer.write("<buildings>");
            while (enumeration.hasMoreElements()) {
                BuildingEncoder.encode((Building)enumeration.nextElement(), writer);
            }
            writer.write("</buildings>");
        }
        if ((enumeration = iBoard.getInfernoBurningCoords()).hasMoreElements()) {
            writer.write("<infernos>");
            while (enumeration.hasMoreElements()) {
                Coords coords = (Coords)enumeration.nextElement();
                writer.write("<inferno>");
                CoordsEncoder.encode(coords, writer);
                int n = iBoard.getInfernoIVBurnTurns(coords);
                if (n > 0) {
                    writer.write("<arrowiv turns=\"");
                    writer.write(Integer.toString(n));
                    writer.write("\" />");
                }
                n -= iBoard.getInfernoBurnTurns(coords);
                if ((n = -n) > 0) {
                    writer.write("<standard turns=\"");
                    writer.write(Integer.toString(n));
                    writer.write("\" />");
                }
                writer.write("</inferno>");
            }
            writer.write("</infernos>");
        }
        writer.write("</board>");
    }

    public static IBoard decode(ParsedXML parsedXML, IGame iGame) {
        String string = null;
        int n = 0;
        Board board = null;
        Vector<Building> vector = new Vector<Building>();
        Hashtable<Coords, InfernoTracker> hashtable = new Hashtable<Coords, InfernoTracker>();
        int n2 = 0;
        int n3 = 0;
        IHex[] iHexArray = null;
        Coords coords = null;
        Enumeration enumeration = null;
        ParsedXML parsedXML2 = null;
        if (null == parsedXML) {
            throw new IllegalArgumentException("The board is null.");
        }
        if (!parsedXML.getName().equals("board")) {
            throw new IllegalStateException("Not passed a board node.");
        }
        Enumeration enumeration2 = parsedXML.elements();
        while (enumeration2.hasMoreElements()) {
            ParsedXML parsedXML3 = (ParsedXML)enumeration2.nextElement();
            String string2 = parsedXML3.getName();
            if (null == string2) continue;
            if (string2.equals("boardData")) {
                if (null != iHexArray) {
                    throw new IllegalStateException("More than one 'boardData' node in a board node.");
                }
                string = parsedXML3.getAttribute("height");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode the boardData for a board node.");
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Couldn't get an integer from " + string);
                }
                n2 = n;
                if (n2 < 0 || n2 > 511) {
                    throw new IllegalStateException("Illegal value for height: " + string);
                }
                string = parsedXML3.getAttribute("width");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode the boardData for a board node.");
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Couldn't get an integer from " + string);
                }
                n3 = n;
                if (n3 < 0 || n3 > 1048575) {
                    throw new IllegalStateException("Illegal value for width: " + string);
                }
                iHexArray = new IHex[n2 * n3];
                int n4 = 0;
                enumeration = parsedXML3.elements();
                while (enumeration.hasMoreElements()) {
                    parsedXML2 = (ParsedXML)enumeration.nextElement();
                    if (!parsedXML2.getName().equals("hex")) continue;
                    if (iHexArray.length == n4) {
                        throw new IllegalStateException("Too many hexes in a board node.");
                    }
                    iHexArray[n4] = HexEncoder.decode(parsedXML2, iGame);
                    ++n4;
                }
                if (n4 >= iHexArray.length) continue;
                throw new IllegalStateException("Not enough hexes in a board node.");
            }
            if (string2.equals("infernos")) {
                enumeration = parsedXML3.elements();
                while (enumeration.hasMoreElements()) {
                    parsedXML2 = (ParsedXML)enumeration.nextElement();
                    if (!parsedXML2.getName().equals("inferno")) continue;
                    coords = null;
                    InfernoTracker infernoTracker = new InfernoTracker();
                    Enumeration enumeration3 = parsedXML2.elements();
                    while (enumeration3.hasMoreElements()) {
                        ParsedXML parsedXML4 = (ParsedXML)enumeration3.nextElement();
                        if (parsedXML4.getName().equals("coords")) {
                            coords = CoordsEncoder.decode(parsedXML4, iGame);
                            continue;
                        }
                        if (parsedXML4.getName().equals("arrowiv")) {
                            string = parsedXML4.getAttribute("turns");
                            if (null == string) {
                                throw new IllegalStateException("Couldn't decode the burn turns for an Arrow IV inferno round.");
                            }
                            try {
                                n = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalStateException("Couldn't get an integer from " + string);
                            }
                            infernoTracker.add(InfernoTracker.INFERNO_IV_TURN, n);
                            continue;
                        }
                        if (!parsedXML4.getName().equals("standard")) continue;
                        string = parsedXML4.getAttribute("turns");
                        if (null == string) {
                            throw new IllegalStateException("Couldn't decode the burn turns for a standard inferno round.");
                        }
                        try {
                            n = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalStateException("Couldn't get an integer from " + string);
                        }
                        infernoTracker.add(InfernoTracker.STANDARD_TURN, n);
                    }
                    if (null == coords) {
                        throw new IllegalStateException("Couldn't decode the coordinates for an inferno round.");
                    }
                    hashtable.put(coords, infernoTracker);
                }
                continue;
            }
            if (!string2.equals("buildings")) continue;
            enumeration = parsedXML3.elements();
            while (enumeration.hasMoreElements()) {
                Building building;
                parsedXML2 = (ParsedXML)enumeration.nextElement();
                if (!parsedXML2.getName().equals("building") || null == (building = BuildingEncoder.decode(parsedXML2, iGame))) continue;
                vector.addElement(building);
            }
        }
        if (null == iHexArray) {
            throw new IllegalStateException("Couldn't locate the boardData for a board node.");
        }
        board = new Board(n3, n2, iHexArray, vector, hashtable);
        return board;
    }
}

