/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.net;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import megamek.common.net.AbstractConnection;

class ObjectStreamConnection
extends AbstractConnection {
    private ObjectInputStream in;
    private ObjectOutputStream out;

    public ObjectStreamConnection(Socket socket, int n) {
        super(socket, n);
    }

    public ObjectStreamConnection(String string, int n, int n2) {
        super(string, n, n2);
    }

    protected AbstractConnection.INetworkPacket readNetworkPacket() throws Exception {
        NetworkPacket networkPacket = null;
        if (this.in == null) {
            this.in = new ObjectInputStream(this.getInputStream());
        }
        networkPacket = (NetworkPacket)this.in.readObject();
        return networkPacket;
    }

    protected void sendNetworkPacket(byte[] byArray, boolean bl) throws Exception {
        if (this.out == null) {
            this.out = new ObjectOutputStream(this.getOutputStream());
            this.out.flush();
        }
        this.out.reset();
        this.out.writeObject(new NetworkPacket(bl, this.marshallingType, byArray));
        this.out.flush();
    }

    private static class NetworkPacket
    implements AbstractConnection.INetworkPacket,
    Serializable {
        private static final long serialVersionUID = -6526944082619874044L;
        private boolean compressed;
        private int marshallingType;
        private byte[] data;

        NetworkPacket(boolean bl, int n, byte[] byArray) {
            this.compressed = bl;
            this.marshallingType = n;
            this.data = byArray;
        }

        public int getMarshallingType() {
            return this.marshallingType;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean isCompressed() {
            return this.compressed;
        }
    }
}

