/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.PMAreasGroup;
import megamek.client.ui.AWT.widget.PMSimpleLabel;
import megamek.client.ui.AWT.widget.PMSimplePolygonArea;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.PMValueLabel;
import megamek.client.ui.AWT.widget.WidgetUtils;
import megamek.common.Entity;
import megamek.common.Jumpship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarshipMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private Component comp;
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[7];
    private PMSimpleLabel[] labels = new PMSimpleLabel[13];
    private PMValueLabel[] vLabels = new PMValueLabel[13];
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private Polygon noseArmor = new Polygon(new int[]{0, 25, 75, 100}, new int[]{50, 0, 0, 50}, 4);
    private Polygon Structure = new Polygon(new int[]{35, 65, 65, 35}, new int[]{50, 50, 150, 150}, 4);
    private Polygon leftFSArmor = new Polygon(new int[]{0, 35, 35, 0}, new int[]{50, 50, 110, 110}, 4);
    private Polygon leftASArmor = new Polygon(new int[]{0, 35, 35, 0}, new int[]{110, 110, 150, 150}, 4);
    private Polygon rightFSArmor = new Polygon(new int[]{65, 100, 100, 65}, new int[]{50, 50, 110, 110}, 4);
    private Polygon rightASArmor = new Polygon(new int[]{65, 100, 100, 65}, new int[]{110, 110, 150, 150}, 4);
    private Polygon aftArmor = new Polygon(new int[]{0, -10, 40, 40, 60, 60, 110, 100}, new int[]{150, 200, 190, 200, 200, 190, 200, 150}, 8);
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public WarshipMapSet(Component component) {
        this.comp = component;
        this.setAreas();
        this.setLabels();
        this.setBackGround();
        this.translateAreas();
        this.setContent();
    }

    public void setRest() {
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        Jumpship jumpship = (Jumpship)entity;
        int n = 1;
        int n2 = 1;
        for (int i = 0; i < 6; ++i) {
            n = jumpship.getArmor(i);
            n2 = jumpship.getOArmor(i);
            this.vLabels[i].setValue(jumpship.getArmorString(i));
            WidgetUtils.setAreaColor(this.areas[i], this.vLabels[i], (double)n / (double)n2);
        }
        n = jumpship.getSI();
        n2 = jumpship.get0SI();
        this.vLabels[6].setValue(Integer.toString(jumpship.getSI()));
        WidgetUtils.setAreaColor(this.areas[6], this.vLabels[6], (double)n / (double)n2);
        this.vLabels[7].setValue(this.getCriticalHitTally(jumpship.getAvionicsHits(), 3));
        this.vLabels[8].setValue(this.getCriticalHitTally(jumpship.getCICHits(), 3));
        this.vLabels[9].setValue(this.getCriticalHitTally(jumpship.getEngineHits(), jumpship.getMaxEngineHits()));
        this.vLabels[10].setValue(this.getCriticalHitTally(jumpship.getSensorHits(), 3));
        this.vLabels[11].setValue(this.getCriticalHitTally(jumpship.getLeftThrustHits(), 3));
        this.vLabels[12].setValue(this.getCriticalHitTally(jumpship.getRightThrustHits(), 3));
    }

    private void setContent() {
        for (int i = 0; i < 6; ++i) {
            this.content.addArea(this.areas[i]);
            this.content.addArea(this.labels[i]);
            this.content.addArea(this.vLabels[i]);
        }
        this.content.addArea(this.areas[6]);
        this.content.addArea(this.labels[6]);
        this.content.addArea(this.vLabels[6]);
        this.content.addArea(this.labels[7]);
        this.content.addArea(this.vLabels[7]);
        this.content.addArea(this.labels[8]);
        this.content.addArea(this.vLabels[8]);
        this.content.addArea(this.labels[9]);
        this.content.addArea(this.vLabels[9]);
        this.content.addArea(this.labels[10]);
        this.content.addArea(this.vLabels[10]);
        this.content.addArea(this.labels[11]);
        this.content.addArea(this.vLabels[11]);
        this.content.addArea(this.labels[12]);
        this.content.addArea(this.vLabels[12]);
    }

    private void setAreas() {
        this.areas[0] = new PMSimplePolygonArea(this.noseArmor);
        this.areas[1] = new PMSimplePolygonArea(this.leftFSArmor);
        this.areas[2] = new PMSimplePolygonArea(this.rightFSArmor);
        this.areas[4] = new PMSimplePolygonArea(this.leftASArmor);
        this.areas[5] = new PMSimplePolygonArea(this.rightASArmor);
        this.areas[3] = new PMSimplePolygonArea(this.aftArmor);
        this.areas[6] = new PMSimplePolygonArea(this.Structure);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.labels[0] = WidgetUtils.createLabel("NOS", fontMetrics, Color.black, 50, 15);
        this.labels[1] = WidgetUtils.createLabel("FLS", fontMetrics, Color.black, 17, 70);
        this.labels[2] = WidgetUtils.createLabel("FRS", fontMetrics, Color.black, 83, 70);
        this.labels[4] = WidgetUtils.createLabel("ALS", fontMetrics, Color.black, 17, 120);
        this.labels[5] = WidgetUtils.createLabel("ARS", fontMetrics, Color.black, 83, 120);
        this.labels[3] = WidgetUtils.createLabel("AFT", fontMetrics, Color.black, 50, 160);
        this.labels[6] = WidgetUtils.createLabel("SI", fontMetrics, Color.black, 50, 90);
        this.labels[7] = WidgetUtils.createLabel("Avionics:", fontMetrics, Color.white, 10, 210);
        this.labels[8] = WidgetUtils.createLabel("CIC:", fontMetrics, Color.white, 10, 225);
        this.labels[9] = WidgetUtils.createLabel("Engine:", fontMetrics, Color.white, 10, 240);
        this.labels[10] = WidgetUtils.createLabel("Sensors:", fontMetrics, Color.white, 10, 255);
        this.labels[11] = WidgetUtils.createLabel("L Thrust:", fontMetrics, Color.white, 90, 210);
        this.labels[12] = WidgetUtils.createLabel("R Thrust:", fontMetrics, Color.white, 90, 225);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.vLabels[0] = WidgetUtils.createValueLabel(50, 30, "", fontMetrics);
        this.vLabels[1] = WidgetUtils.createValueLabel(17, 85, "", fontMetrics);
        this.vLabels[2] = WidgetUtils.createValueLabel(83, 85, "", fontMetrics);
        this.vLabels[4] = WidgetUtils.createValueLabel(17, 135, "", fontMetrics);
        this.vLabels[5] = WidgetUtils.createValueLabel(83, 135, "", fontMetrics);
        this.vLabels[3] = WidgetUtils.createValueLabel(50, 175, "", fontMetrics);
        this.vLabels[6] = WidgetUtils.createValueLabel(50, 105, "", fontMetrics);
        this.vLabels[7] = WidgetUtils.createValueLabel(40, 210, "", fontMetrics);
        this.vLabels[8] = WidgetUtils.createValueLabel(40, 225, "", fontMetrics);
        this.vLabels[9] = WidgetUtils.createValueLabel(40, 240, "", fontMetrics);
        this.vLabels[10] = WidgetUtils.createValueLabel(40, 255, "", fontMetrics);
        this.vLabels[11] = WidgetUtils.createValueLabel(130, 210, "", fontMetrics);
        this.vLabels[12] = WidgetUtils.createValueLabel(130, 225, "", fontMetrics);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void translateAreas() {
    }

    private String getCriticalHitTally(int n, int n2) {
        String string = "";
        if (n < 1) {
            return string;
        }
        if (n >= n2) {
            string = "Out";
            return string;
        }
        while (n > 0) {
            string = string + "X";
            --n;
        }
        return string;
    }
}

