/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.TileTextureManager;
import megamek.common.Coords;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.actions.ArtilleryAttackAction;

class ArtilleryAttackModel
extends BranchGroup {
    public ArtilleryAttackModel(int n, ArtilleryAttackAction artilleryAttackAction, IGame iGame, TileTextureManager tileTextureManager) {
        this(n, artilleryAttackAction.getTarget(iGame).getPosition(), iGame, tileTextureManager);
        this.setUserData(artilleryAttackAction);
    }

    public ArtilleryAttackModel(int n, Coords coords, IGame iGame, TileTextureManager tileTextureManager) {
        IHex iHex = iGame.getBoard().getHex(coords);
        Vector3d vector3d = new Vector3d((Tuple3d)BoardModel.getHexLocation(coords, iHex.surface()));
        Transform3D transform3D = new Transform3D();
        if (n == 2) {
            transform3D.rotX(1.5707963267948966);
            vector3d.z += 30.0;
        }
        transform3D.setScale(new Vector3d(2.0 * BoardModel.HEX_SIDE_LENGTH, 30.0, 1.0));
        transform3D.setTranslation(vector3d);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        transformGroup.addChild((Node)tileTextureManager.getArtilleryTarget(n));
        TransformGroup transformGroup2 = new TransformGroup(transform3D);
        transformGroup2.addChild((Node)transformGroup);
        this.addChild((Node)transformGroup2);
        this.setCapability(17);
    }
}

