/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.AimedShotDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.ConfirmDialog;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.SingleChoiceDialog;
import megamek.client.ui.AWT.StatusBarPhaseDisplay;
import megamek.client.ui.AWT.widget.IndexedCheckbox;
import megamek.client.ui.Messages;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.BuildingTarget;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.GameTurn;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.BAVibroClawAttackAction;
import megamek.common.actions.BreakGrappleAttackAction;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DodgeAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.GrappleAttackAction;
import megamek.common.actions.JumpJetAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.LayExplosivesAttackAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.ThrashAttackAction;
import megamek.common.actions.TripAttackAction;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;

public class PhysicalDisplay
extends StatusBarPhaseDisplay
implements GameListener,
ActionListener,
DoneButtoned,
KeyListener,
BoardViewListener {
    private static final long serialVersionUID = -3621285458197917442L;
    public static final String PHYSICAL_PUNCH = "punch";
    public static final String PHYSICAL_KICK = "kick";
    public static final String PHYSICAL_CLUB = "club";
    public static final String PHYSICAL_BRUSH_OFF = "brushOff";
    public static final String PHYSICAL_THRASH = "thrash";
    public static final String PHYSICAL_DODGE = "dodge";
    public static final String PHYSICAL_PUSH = "push";
    public static final String PHYSICAL_TRIP = "trip";
    public static final String PHYSICAL_GRAPPLE = "grapple";
    public static final String PHYSICAL_JUMPJET = "jumpjet";
    public static final String PHYSICAL_NEXT = "next";
    public static final String PHYSICAL_PROTO = "protoPhysical";
    public static final String PHYSICAL_SEARCHLIGHT = "fireSearchlight";
    public static final String PHYSICAL_EXPLOSIVES = "explosives";
    public static final String PHYSICAL_VIBRO = "vibro";
    private static final int NUM_BUTTON_LAYOUTS = 3;
    ClientGUI clientgui;
    private Client client;
    private Container panButtons;
    private Button butPunch;
    private Button butKick;
    private Button butPush;
    private Button butTrip;
    private Button butGrapple;
    private Button butJumpJet;
    private Button butClub;
    private Button butBrush;
    private Button butThrash;
    private Button butDodge;
    private Button butProto;
    private Button butExplosives;
    private Button butVibro;
    private Button butNext;
    private Button butDone;
    private Button butMore;
    private Button butSpace;
    private Button butSpace2;
    private Button butSearchlight;
    private int buttonLayout;
    private int cen = -1;
    Targetable target;
    private Vector<EntityAction> attacks;
    private AimedShotHandler ash = new AimedShotHandler();

    public PhysicalDisplay(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(this);
        clientGUI.getBoardView().addBoardViewListener(this);
        this.attacks = new Vector();
        this.setupStatusBar(Messages.getString("PhysicalDisplay.waitingForPhysicalAttackPhase"));
        this.butSpace = new Button(".");
        this.butSpace.setEnabled(false);
        this.butSpace2 = new Button(".");
        this.butSpace2.setEnabled(false);
        this.butPunch = new Button(Messages.getString("PhysicalDisplay.Punch"));
        this.butPunch.addActionListener(this);
        this.butPunch.setEnabled(false);
        this.butPunch.setActionCommand(PHYSICAL_PUNCH);
        this.butKick = new Button(Messages.getString("PhysicalDisplay.Kick"));
        this.butKick.addActionListener(this);
        this.butKick.setEnabled(false);
        this.butKick.setActionCommand(PHYSICAL_KICK);
        this.butPush = new Button(Messages.getString("PhysicalDisplay.Push"));
        this.butPush.addActionListener(this);
        this.butPush.setEnabled(false);
        this.butPush.setActionCommand(PHYSICAL_PUSH);
        this.butTrip = new Button(Messages.getString("PhysicalDisplay.Trip"));
        this.butTrip.addActionListener(this);
        this.butTrip.setEnabled(false);
        this.butTrip.setActionCommand(PHYSICAL_TRIP);
        this.butGrapple = new Button(Messages.getString("PhysicalDisplay.Grapple"));
        this.butGrapple.addActionListener(this);
        this.butGrapple.setEnabled(false);
        this.butGrapple.setActionCommand(PHYSICAL_GRAPPLE);
        this.butJumpJet = new Button(Messages.getString("PhysicalDisplay.JumpJet"));
        this.butJumpJet.addActionListener(this);
        this.butJumpJet.setEnabled(false);
        this.butJumpJet.setActionCommand(PHYSICAL_JUMPJET);
        this.butClub = new Button(Messages.getString("PhysicalDisplay.Club"));
        this.butClub.addActionListener(this);
        this.butClub.setEnabled(false);
        this.butClub.setActionCommand(PHYSICAL_CLUB);
        this.butBrush = new Button(Messages.getString("PhysicalDisplay.BrushOff"));
        this.butBrush.addActionListener(this);
        this.butBrush.setEnabled(false);
        this.butBrush.setActionCommand(PHYSICAL_BRUSH_OFF);
        this.butThrash = new Button(Messages.getString("PhysicalDisplay.Trash"));
        this.butThrash.addActionListener(this);
        this.butThrash.setEnabled(false);
        this.butThrash.setActionCommand(PHYSICAL_THRASH);
        this.butDodge = new Button(Messages.getString("PhysicalDisplay.Dodge"));
        this.butDodge.addActionListener(this);
        this.butDodge.setEnabled(false);
        this.butDodge.setActionCommand(PHYSICAL_DODGE);
        this.butProto = new Button(Messages.getString("PhysicalDisplay.ProtoPhysical"));
        this.butProto.addActionListener(this);
        this.butProto.setEnabled(false);
        this.butProto.setActionCommand(PHYSICAL_PROTO);
        this.butExplosives = new Button(Messages.getString("PhysicalDisplay.Explosives"));
        this.butExplosives.addActionListener(this);
        this.butExplosives.setEnabled(false);
        this.butExplosives.setActionCommand(PHYSICAL_EXPLOSIVES);
        this.butVibro = new Button(Messages.getString("PhysicalDisplay.Vibro"));
        this.butVibro.addActionListener(this);
        this.butVibro.setEnabled(false);
        this.butVibro.setActionCommand(PHYSICAL_VIBRO);
        this.butDone = new Button(Messages.getString("PhysicalDisplay.Done"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.butNext = new Button(Messages.getString("PhysicalDisplay.NextUnit"));
        this.butNext.addActionListener(this);
        this.butNext.setEnabled(false);
        this.butNext.setActionCommand(PHYSICAL_NEXT);
        this.butMore = new Button(Messages.getString("PhysicalDisplay.More"));
        this.butMore.addActionListener(this);
        this.butMore.setEnabled(false);
        this.butSearchlight = new Button(Messages.getString("FiringDisplay.Searchlight"));
        this.butSearchlight.addActionListener(this);
        this.butSearchlight.addKeyListener(this);
        this.butSearchlight.setActionCommand(PHYSICAL_SEARCHLIGHT);
        this.butSearchlight.setEnabled(false);
        this.panButtons = new Panel();
        this.buttonLayout = 0;
        this.setupButtonPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    private void setupButtonPanel() {
        this.panButtons.removeAll();
        this.panButtons.setLayout(new GridLayout(0, 6));
        switch (this.buttonLayout) {
            case 0: {
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butPunch);
                this.panButtons.add(this.butKick);
                this.panButtons.add(this.butPush);
                this.panButtons.add(this.butClub);
                this.panButtons.add(this.butMore);
                break;
            }
            case 1: {
                this.panButtons.add(this.butBrush);
                this.panButtons.add(this.butThrash);
                this.panButtons.add(this.butVibro);
                this.panButtons.add(this.butProto);
                this.panButtons.add(this.butJumpJet);
                this.panButtons.add(this.butMore);
                break;
            }
            case 2: {
                this.panButtons.add(this.butDodge);
                this.panButtons.add(this.butTrip);
                this.panButtons.add(this.butGrapple);
                this.panButtons.add(this.butSearchlight);
                this.panButtons.add(this.butExplosives);
                this.panButtons.add(this.butMore);
            }
        }
        this.validate();
    }

    public void selectEntity(int n) {
        Object object;
        int n2;
        if (this.client.game.getEntity(n) == null) {
            System.err.println("PhysicalDisplay: tried to select non-existant entity: " + n);
            return;
        }
        this.cen = n;
        this.clientgui.setSelectedEntityNum(n);
        Entity entity = this.ce();
        this.target(null);
        if (entity instanceof Mech && (n2 = ((Mech)entity).getGrappled()) != -1 && (object = this.client.game.getEntity(n2)) != null) {
            this.target((Targetable)object);
        }
        this.clientgui.getBoardView().highlight(this.ce().getPosition());
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.mechD.displayEntity(entity);
        this.clientgui.mechD.showPanel("movement");
        this.clientgui.bv.centerOnHex(entity.getPosition());
        this.clientgui.getMenuBar().setEntity(this.ce());
        String string = null;
        for (Mounted mounted : entity.getClubs()) {
            String string2 = mounted.getName().endsWith("Club") ? Messages.getString("PhysicalDisplay.Club") : mounted.getName();
            if (string == null) {
                string = string2;
                continue;
            }
            string = string + "/" + string2;
        }
        if (string == null) {
            string = Messages.getString("PhysicalDisplay.Club");
        }
        this.butClub.setLabel(string);
        if (entity instanceof Mech && !entity.isProne() && entity.getCrew().getOptions().booleanOption("dodge_maneuver")) {
            this.setDodgeEnabled(true);
        }
    }

    private void beginMyTurn() {
        GameTurn gameTurn = this.client.getMyTurn();
        if (gameTurn instanceof GameTurn.CounterGrappleTurn) {
            this.disableButtons();
            this.selectEntity(((GameTurn.CounterGrappleTurn)gameTurn).getEntityNum());
            this.grapple(true);
            this.ready();
        } else {
            this.target(null);
            this.selectEntity(this.client.getFirstEntityNum());
            this.setNextEnabled(true);
            this.butDone.setEnabled(true);
            this.butMore.setEnabled(true);
        }
        this.clientgui.setDisplayVisible(true);
        this.clientgui.getBoardView().select(null);
    }

    private void endMyTurn() {
        Entity entity = this.client.game.getNextEntity(this.client.game.getTurnIndex());
        if (IGame.Phase.PHASE_PHYSICAL == this.client.game.getPhase() && null != entity && null != this.ce() && entity.getOwnerId() != this.ce().getOwnerId()) {
            this.clientgui.setDisplayVisible(false);
        }
        this.cen = -1;
        this.target(null);
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.bv.clearMovementData();
        this.disableButtons();
    }

    private void disableButtons() {
        this.setKickEnabled(false);
        this.setPunchEnabled(false);
        this.setPushEnabled(false);
        this.setTripEnabled(false);
        this.setGrappleEnabled(false);
        this.setJumpJetEnabled(false);
        this.setClubEnabled(false);
        this.setBrushOffEnabled(false);
        this.setThrashEnabled(false);
        this.setDodgeEnabled(false);
        this.setProtoEnabled(false);
        this.setVibroEnabled(false);
        this.setExplosivesEnabled(false);
        this.butDone.setEnabled(false);
        this.setNextEnabled(false);
    }

    private void ready() {
        if (this.attacks.isEmpty() && GUIPreferences.getInstance().getNagForNoAction()) {
            ConfirmDialog confirmDialog = this.clientgui.doYesNoBotherDialog(Messages.getString("PhysicalDisplay.DontPhysicalAttackDialog.title"), Messages.getString("PhysicalDisplay.DontPhysicalAttackDialog.message"));
            if (!confirmDialog.getShowAgain()) {
                GUIPreferences.getInstance().setNagForNoAction(false);
            }
            if (!confirmDialog.getAnswer()) {
                return;
            }
        }
        this.disableButtons();
        this.client.sendAttackData(this.cen, this.attacks);
        this.attacks.removeAllElements();
        this.ash.closeDialog();
        this.endMyTurn();
    }

    private void clearattacks() {
        if (this.attacks.size() > 0) {
            this.attacks.removeAllElements();
        }
        this.clientgui.mechD.wPan.displayMech(this.ce());
        this.updateTarget();
        Entity entity = this.client.game.getEntity(this.cen);
        entity.dodging = true;
    }

    public void punch() {
        ToHitData toHitData = PunchAttackAction.toHit(this.client.game, this.cen, this.target, 1);
        ToHitData toHitData2 = PunchAttackAction.toHit(this.client.game, this.cen, this.target, 2);
        String string = Messages.getString("PhysicalDisplay.PunchDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.PunchDialog.message", new Object[]{toHitData2.getValueAsString(), new Double(Compute.oddsAbove(toHitData2.getValue())), toHitData2.getDesc(), new Integer(PunchAttackAction.getDamageFor(this.ce(), 2, this.target instanceof Infantry && !(this.target instanceof BattleArmor))), toHitData2.getTableDesc(), toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), new Integer(PunchAttackAction.getDamageFor(this.ce(), 1, this.target instanceof Infantry && !(this.target instanceof BattleArmor))), toHitData.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            boolean bl = false;
            boolean bl2 = false;
            if (this.ce() instanceof Mech && this.target instanceof Entity && this.clientgui.client.game.getOptions().booleanOption("tacops_retractable_blades") && toHitData.getValue() != Integer.MAX_VALUE && ((Mech)this.ce()).hasRetractedBlade(5)) {
                bl = this.clientgui.doYesNoDialog(Messages.getString("PhysicalDisplay.ExtendBladeDialog.title"), Messages.getString("PhysicalDisplay.ExtendBladeDialog.message", new Object[]{this.ce().getLocationName(5)}));
            }
            if (this.ce() instanceof Mech && this.target instanceof Entity && this.clientgui.client.game.getOptions().booleanOption("tacops_retractable_blades") && toHitData2.getValue() != Integer.MAX_VALUE && ((Mech)this.ce()).hasRetractedBlade(4)) {
                bl2 = this.clientgui.doYesNoDialog(Messages.getString("PhysicalDisplay.ExtendBladeDialog.title"), Messages.getString("PhysicalDisplay.ExtendBladeDialog.message", new Object[]{this.ce().getLocationName(4)}));
            }
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            if (toHitData.getValue() != Integer.MAX_VALUE && toHitData2.getValue() != Integer.MAX_VALUE) {
                this.attacks.addElement(new PunchAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 0, bl, bl2));
            } else if (toHitData.getValue() < toHitData2.getValue()) {
                this.attacks.addElement(new PunchAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 1, bl, bl2));
            } else {
                this.attacks.addElement(new PunchAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 2, bl, bl2));
            }
            this.ready();
        }
    }

    private void doSearchlight() {
        if (this.ce() == null || this.target == null) {
            throw new IllegalArgumentException("current searchlight parameters are invalid");
        }
        if (!SearchlightAttackAction.isPossible(this.client.game, this.cen, this.target, null)) {
            return;
        }
        SearchlightAttackAction searchlightAttackAction = new SearchlightAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId());
        this.attacks.addElement(searchlightAttackAction);
        this.client.game.addAction(searchlightAttackAction);
        this.clientgui.bv.addAttack(searchlightAttackAction);
        this.clientgui.minimap.drawMap();
        this.setSearchlightEnabled(false);
        this.updateTarget();
    }

    public void kick() {
        ToHitData toHitData = KickAttackAction.toHit(this.client.game, this.cen, this.target, 1);
        ToHitData toHitData2 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 2);
        ToHitData toHitData3 = null;
        ToHitData toHitData4 = null;
        int n = 1;
        int n2 = toHitData.getValue();
        ToHitData toHitData5 = toHitData;
        if (n2 > toHitData2.getValue()) {
            n2 = toHitData2.getValue();
            n = 2;
            toHitData5 = toHitData2;
        }
        if (this.client.game.getEntity(this.cen) instanceof QuadMech) {
            toHitData3 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 4);
            toHitData4 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 3);
            if (n2 > toHitData3.getValue()) {
                n2 = toHitData3.getValue();
                n = 4;
                toHitData5 = toHitData3;
            }
            if (n2 > toHitData4.getValue()) {
                n2 = toHitData4.getValue();
                n = 3;
                toHitData5 = toHitData4;
            }
        }
        String string = Messages.getString("PhysicalDisplay.KickDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.KickDialog.message", new Object[]{toHitData5.getValueAsString(), new Double(Compute.oddsAbove(toHitData5.getValue())), toHitData5.getDesc(), KickAttackAction.getDamageFor(this.ce(), n, this.target instanceof Infantry && !(this.target instanceof BattleArmor)) + toHitData5.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new KickAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), n));
            this.ready();
        }
    }

    public void push() {
        ToHitData toHitData = PushAttackAction.toHit(this.client.game, this.cen, this.target);
        String string = Messages.getString("PhysicalDisplay.PushDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.PushDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new PushAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), this.target.getPosition()));
            this.ready();
        }
    }

    public void trip() {
        ToHitData toHitData = TripAttackAction.toHit(this.client.game, this.cen, this.target);
        String string = Messages.getString("PhysicalDisplay.TripDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.TripDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new TripAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId()));
            this.ready();
        }
    }

    public void doGrapple() {
        if (((Mech)this.ce()).getGrappled() == -1) {
            this.grapple(false);
        } else {
            this.breakGrapple();
        }
    }

    private void grapple(boolean bl) {
        ToHitData toHitData = GrappleAttackAction.toHit(this.client.game, this.cen, this.target);
        String string = Messages.getString("PhysicalDisplay.GrappleDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.GrappleDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc()});
        if (bl) {
            string2 = Messages.getString("PhysicalDisplay.CounterGrappleDialog.message", new Object[]{this.target.getDisplayName(), toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc()});
        }
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new GrappleAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId()));
            this.ready();
        }
    }

    private void breakGrapple() {
        ToHitData toHitData = BreakGrappleAttackAction.toHit(this.client.game, this.cen, this.target);
        String string = Messages.getString("PhysicalDisplay.BreakGrappleDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.BreakGrappleDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new BreakGrappleAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId()));
            this.ready();
        }
    }

    public void jumpjetatt() {
        Object object;
        Object object2;
        int n;
        int n2;
        Object object3;
        if (this.ce().isProne()) {
            object3 = JumpJetAttackAction.toHit(this.client.game, this.cen, this.target, 0);
            n2 = 0;
            n = JumpJetAttackAction.getDamageFor(this.ce(), 0);
        } else {
            object2 = JumpJetAttackAction.toHit(this.client.game, this.cen, this.target, 1);
            object = JumpJetAttackAction.toHit(this.client.game, this.cen, this.target, 2);
            int n3 = JumpJetAttackAction.getDamageFor(this.ce(), 1);
            int n4 = JumpJetAttackAction.getDamageFor(this.ce(), 2);
            if ((double)n3 * Compute.oddsAbove(((TargetRoll)object2).getValue()) > (double)n4 * Compute.oddsAbove(((TargetRoll)object).getValue())) {
                object3 = object2;
                n2 = 1;
                n = n3;
            } else {
                object3 = object;
                n2 = 2;
                n = n4;
            }
        }
        object2 = Messages.getString("PhysicalDisplay.JumpJetDialog.title", new Object[]{this.target.getDisplayName()});
        object = Messages.getString("PhysicalDisplay.JumpJetDialog.message", new Object[]{((TargetRoll)object3).getValueAsString(), new Double(Compute.oddsAbove(((TargetRoll)object3).getValue())), ((TargetRoll)object3).getDesc(), n});
        if (this.clientgui.doYesNoDialog((String)object2, (String)object)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new JumpJetAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), n2));
            this.ready();
        }
    }

    private Mounted chooseClub() {
        List<Mounted> list = this.ce().getClubs();
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1) {
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                Mounted mounted = list.get(i);
                stringArray[i] = Messages.getString("PhysicalDisplay.ChooseClubDialog.line", new Object[]{mounted.getName(), ClubAttackAction.toHit(this.client.game, this.cen, this.target, mounted, this.ash.getAimTable()).getValueAsString(), ClubAttackAction.getDamageFor(this.ce(), mounted, this.target instanceof Infantry && !(this.target instanceof BattleArmor))});
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("PhysicalDisplay.ChooseClubDialog.title"), Messages.getString("PhysicalDisplay.ChooseClubDialog.message"), stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                return list.get(singleChoiceDialog.getChoice());
            }
        }
        return null;
    }

    public void club() {
        Mounted mounted = this.chooseClub();
        if (null == mounted) {
            return;
        }
        ToHitData toHitData = ClubAttackAction.toHit(this.client.game, this.cen, this.target, mounted, this.ash.getAimTable());
        String string = Messages.getString("PhysicalDisplay.ClubDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.ClubDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), ClubAttackAction.getDamageFor(this.ce(), mounted, this.target instanceof Infantry && !(this.target instanceof BattleArmor)) + toHitData.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new ClubAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), mounted, this.ash.getAimTable()));
            this.ready();
        }
    }

    public void club(Mounted mounted) {
        if (null == mounted) {
            return;
        }
        ToHitData toHitData = ClubAttackAction.toHit(this.client.game, this.cen, this.target, mounted, this.ash.getAimTable());
        String string = Messages.getString("PhysicalDisplay.ClubDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.ClubDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), ClubAttackAction.getDamageFor(this.ce(), mounted, this.target instanceof Infantry && !(this.target instanceof BattleArmor)) + toHitData.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new ClubAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), mounted, this.ash.getAimTable()));
            this.ready();
        }
    }

    private void proto() {
        ToHitData toHitData = ProtomechPhysicalAttackAction.toHit(this.client.game, this.cen, this.target);
        String string = Messages.getString("PhysicalDisplay.ProtoMechAttackDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.ProtoMechAttackDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), ProtomechPhysicalAttackAction.getDamageFor(this.ce()) + toHitData.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new ProtomechPhysicalAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId()));
            this.ready();
        }
    }

    private void explosives() {
        ToHitData toHitData = LayExplosivesAttackAction.toHit(this.client.game, this.cen, this.target);
        String string = Messages.getString("PhysicalDisplay.LayExplosivesAttackDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.LayExplosivesAttackDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            this.attacks.addElement(new LayExplosivesAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId()));
            this.ready();
        }
    }

    private void brush() {
        ToHitData toHitData = BrushOffAttackAction.toHit(this.client.game, this.cen, this.target, 1);
        ToHitData toHitData2 = BrushOffAttackAction.toHit(this.client.game, this.cen, this.target, 2);
        boolean bl = Integer.MAX_VALUE != toHitData.getValue();
        boolean bl2 = Integer.MAX_VALUE != toHitData2.getValue();
        int n = 0;
        int n2 = 0;
        String string = null;
        StringBuffer stringBuffer = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String[] stringArray = null;
        SingleChoiceDialog singleChoiceDialog = null;
        if (!bl && !bl2) {
            this.clientgui.doAlertDialog(Messages.getString("PhysicalDisplay.AlertDialog.title"), Messages.getString("PhysicalDisplay.AlertDialog.message"));
            return;
        }
        if (bl && bl2) {
            string4 = Messages.getString("PhysicalDisplay.bothArms");
            stringBuffer = new StringBuffer(Messages.getString("PhysicalDisplay.whichArm"));
            string = Messages.getString("PhysicalDisplay.chooseBrushOff");
        } else {
            stringBuffer = new StringBuffer(Messages.getString("PhysicalDisplay.confirmArm"));
            string = Messages.getString("PhysicalDisplay.confirmBrushOff");
        }
        if (11 == this.target.getTargetType()) {
            stringBuffer.append(Messages.getString("PhysicalDisplay.brushOff1", new Object[]{this.target}));
        } else {
            stringBuffer.append(Messages.getString("PhysicalDisplay.brushOff2"));
        }
        if (bl) {
            n = BrushOffAttackAction.getDamageFor(this.ce(), 1);
            string2 = Messages.getString("PhysicalDisplay.LAHit", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), new Integer(n)});
        }
        if (bl2) {
            n2 = BrushOffAttackAction.getDamageFor(this.ce(), 2);
            string3 = Messages.getString("PhysicalDisplay.RAHit", new Object[]{toHitData2.getValueAsString(), new Double(Compute.oddsAbove(toHitData2.getValue())), new Integer(n2)});
        }
        if (bl && bl2) {
            stringArray = new String[]{string2, string3, string4};
            singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, string, stringBuffer.toString(), stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                this.disableButtons();
                switch (singleChoiceDialog.getChoice()) {
                    case 0: {
                        this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 1));
                        break;
                    }
                    case 1: {
                        this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 2));
                        break;
                    }
                    case 2: {
                        this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 0));
                    }
                }
                this.ready();
            }
        } else if (bl) {
            stringArray = new String[]{string2};
            singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, string, stringBuffer.toString(), stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                this.disableButtons();
                this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 1));
                this.ready();
            }
        } else if (bl2) {
            stringArray = new String[]{string3};
            singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, string, stringBuffer.toString(), stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                this.disableButtons();
                this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 2));
                this.ready();
            }
        }
    }

    public void thrash() {
        ThrashAttackAction thrashAttackAction = new ThrashAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId());
        ToHitData toHitData = thrashAttackAction.toHit(this.client.game);
        String string = Messages.getString("PhysicalDisplay.TrashDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.TrashDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), ThrashAttackAction.getDamageFor(this.ce()) + toHitData.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            this.attacks.addElement(thrashAttackAction);
            this.ready();
        }
    }

    public void vibroclawatt() {
        BAVibroClawAttackAction bAVibroClawAttackAction = new BAVibroClawAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId());
        ToHitData toHitData = bAVibroClawAttackAction.toHit(this.client.game);
        String string = Messages.getString("PhysicalDisplay.BAVibroClawDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.BAVibroClawDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), this.ce().getVibroClaws() + toHitData.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            this.attacks.addElement(bAVibroClawAttackAction);
            this.ready();
        }
    }

    public void dodge() {
        if (this.clientgui.doYesNoDialog(Messages.getString("PhysicalDisplay.DodgeDialog.title"), Messages.getString("PhysicalDisplay.DodgeDialog.message"))) {
            this.disableButtons();
            Entity entity = this.client.game.getEntity(this.cen);
            entity.dodging = true;
            DodgeAction dodgeAction = new DodgeAction(this.cen);
            this.attacks.addElement(dodgeAction);
            this.ready();
        }
    }

    void target(Targetable targetable) {
        this.target = targetable;
        this.updateTarget();
        this.ash.showDialog();
    }

    void updateTarget() {
        if (this.cen != -1 && this.target != null) {
            boolean bl;
            ToHitData toHitData;
            ToHitData toHitData2;
            if (this.target.getTargetType() != 11) {
                ToHitData toHitData3;
                toHitData2 = PunchAttackAction.toHit(this.client.game, this.cen, this.target, 1);
                toHitData = PunchAttackAction.toHit(this.client.game, this.cen, this.target, 2);
                bl = toHitData2.getValue() != Integer.MAX_VALUE || toHitData.getValue() != Integer.MAX_VALUE;
                this.setPunchEnabled(bl);
                ToHitData toHitData4 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 1);
                ToHitData toHitData5 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 2);
                boolean bl2 = toHitData4.getValue() != Integer.MAX_VALUE || toHitData5.getValue() != Integer.MAX_VALUE;
                ToHitData toHitData6 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 4);
                ToHitData toHitData7 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 3);
                this.setKickEnabled(bl2 |= toHitData7.getValue() != Integer.MAX_VALUE || toHitData6.getValue() != Integer.MAX_VALUE);
                ToHitData toHitData8 = PushAttackAction.toHit(this.client.game, this.cen, this.target);
                this.setPushEnabled(toHitData8.getValue() != Integer.MAX_VALUE);
                ToHitData toHitData9 = TripAttackAction.toHit(this.client.game, this.cen, this.target);
                this.setTripEnabled(toHitData9.getValue() != Integer.MAX_VALUE);
                ToHitData toHitData10 = GrappleAttackAction.toHit(this.client.game, this.cen, this.target);
                ToHitData toHitData11 = BreakGrappleAttackAction.toHit(this.client.game, this.cen, this.target);
                this.setGrappleEnabled(toHitData10.getValue() != Integer.MAX_VALUE || toHitData11.getValue() != Integer.MAX_VALUE);
                ToHitData toHitData12 = JumpJetAttackAction.toHit(this.client.game, this.cen, this.target, 1);
                ToHitData toHitData13 = JumpJetAttackAction.toHit(this.client.game, this.cen, this.target, 2);
                ToHitData toHitData14 = JumpJetAttackAction.toHit(this.client.game, this.cen, this.target, 0);
                this.setJumpJetEnabled(toHitData12.getValue() != Integer.MAX_VALUE || toHitData13.getValue() != Integer.MAX_VALUE || toHitData14.getValue() != Integer.MAX_VALUE);
                boolean bl3 = false;
                boolean bl4 = false;
                for (Mounted serializable2 : this.ce().getClubs()) {
                    if (serializable2 == null) continue;
                    toHitData3 = ClubAttackAction.toHit(this.client.game, this.cen, this.target, serializable2, this.ash.getAimTable());
                    bl3 |= toHitData3.getValue() != Integer.MAX_VALUE;
                    if (!serializable2.getType().hasSubType(8L) && !serializable2.getType().hasSubType(4L) && !serializable2.getType().hasSubType(16384L) && !serializable2.getType().hasSubType(32768L) && !serializable2.getType().hasSubType(65536L) && !serializable2.getType().hasSubType(64L) && !serializable2.getType().hasSubType(16L) && !serializable2.getType().hasSubType(8192L) && !serializable2.getType().hasSubType(0x1000000L) && !serializable2.getType().hasSubType(0x800000L)) continue;
                    bl4 = true;
                }
                this.setClubEnabled(bl3);
                this.ash.setCanAim(bl4);
                ToHitData toHitData15 = new ThrashAttackAction(this.cen, this.target).toHit(this.client.game);
                this.setThrashEnabled(toHitData15.getValue() != Integer.MAX_VALUE);
                ToHitData toHitData16 = ProtomechPhysicalAttackAction.toHit(this.client.game, this.cen, this.target);
                this.setProtoEnabled(toHitData16.getValue() != Integer.MAX_VALUE);
                toHitData3 = LayExplosivesAttackAction.toHit(this.client.game, this.cen, this.target);
                this.setExplosivesEnabled(toHitData3.getValue() != Integer.MAX_VALUE);
                ToHitData toHitData17 = BAVibroClawAttackAction.toHit(this.clientgui.getClient().game, this.cen, this.target);
                this.setVibroEnabled(toHitData17.getValue() != Integer.MAX_VALUE);
            }
            toHitData2 = BrushOffAttackAction.toHit(this.client.game, this.cen, this.target, 2);
            toHitData = BrushOffAttackAction.toHit(this.client.game, this.cen, this.target, 1);
            bl = toHitData2.getValue() != Integer.MAX_VALUE || toHitData.getValue() != Integer.MAX_VALUE;
            this.setBrushOffEnabled(bl);
        } else {
            this.setPunchEnabled(false);
            this.setPushEnabled(false);
            this.setTripEnabled(false);
            this.setGrappleEnabled(false);
            this.setJumpJetEnabled(false);
            this.setKickEnabled(false);
            this.setClubEnabled(false);
            this.setBrushOffEnabled(false);
            this.setThrashEnabled(false);
            this.setProtoEnabled(false);
            this.setVibroEnabled(false);
        }
        this.setSearchlightEnabled(this.ce() != null && this.target != null && this.ce().isUsingSpotlight());
    }

    Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if ((boardViewEvent.getModifiers() & 2) != 0) {
            return;
        }
        if (this.client.isMyTurn() && (boardViewEvent.getModifiers() & 0x10) != 0) {
            if (boardViewEvent.getType() == 2) {
                if (!boardViewEvent.getCoords().equals(this.clientgui.getBoardView().getLastCursor())) {
                    this.clientgui.getBoardView().cursor(boardViewEvent.getCoords());
                }
            } else if (boardViewEvent.getType() == 0) {
                this.clientgui.getBoardView().select(boardViewEvent.getCoords());
            }
        }
    }

    public void hexSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && boardViewEvent.getCoords() != null && this.ce() != null) {
            Targetable targetable = this.chooseTarget(boardViewEvent.getCoords());
            if (targetable != null) {
                this.target(targetable);
            } else {
                this.target(null);
            }
        }
    }

    private Targetable chooseTarget(Coords coords) {
        String[] stringArray;
        Targetable targetable = null;
        Enumeration<Entity> enumeration = this.client.game.getEntities(coords);
        Vector<Targetable> vector = new Vector<Targetable>();
        while (enumeration.hasMoreElements()) {
            targetable = enumeration.nextElement();
            if (this.ce().equals(targetable)) continue;
            vector.addElement(targetable);
        }
        Building building = this.client.game.getBoard().getBuildingAt(coords);
        if (building != null) {
            vector.addElement(new BuildingTarget(coords, this.client.game.getBoard(), false));
        }
        if (this.ce().getPosition().equals(coords)) {
            stringArray = this.ce().getINarcPodsAttached();
            while (stringArray.hasNext()) {
                targetable = stringArray.next();
                vector.addElement(targetable);
            }
        }
        if (vector.size() == 1) {
            targetable = (Targetable)vector.elementAt(0);
        } else if (vector.size() > 1) {
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((Targetable)vector.elementAt(i)).getDisplayName();
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("PhysicalDisplay.ChooseTargetDialog.title"), Messages.getString("PhysicalDisplay.ChooseTargetDialog.message", new Object[]{coords.getBoardNum()}), stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                targetable = (Targetable)vector.elementAt(singleChoiceDialog.getChoice());
            }
        }
        return targetable;
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.game.getPhase() == IGame.Phase.PHASE_PHYSICAL) {
            if (this.client.isMyTurn()) {
                if (this.cen == -1) {
                    this.beginMyTurn();
                }
                this.setStatusBarText(Messages.getString("PhysicalDisplay.its_your_turn"));
            } else {
                this.endMyTurn();
                this.setStatusBarText(Messages.getString("PhysicalDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
            }
        } else {
            System.err.println("PhysicalDisplay: got turnchange event when it's not the physical attacks phase");
        }
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.client.game.getPhase() != IGame.Phase.PHASE_PHYSICAL) {
            this.endMyTurn();
        }
        if (this.client.game.getPhase() == IGame.Phase.PHASE_PHYSICAL) {
            this.setStatusBarText(Messages.getString("PhysicalDisplay.waitingForPhysicalAttackPhase"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            this.ready();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_PUNCH)) {
            this.punch();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_KICK)) {
            this.kick();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_PUSH)) {
            this.push();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_TRIP)) {
            this.trip();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_GRAPPLE)) {
            this.doGrapple();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_JUMPJET)) {
            this.jumpjetatt();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_CLUB)) {
            this.club();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_BRUSH_OFF)) {
            this.brush();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_THRASH)) {
            this.thrash();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_DODGE)) {
            this.dodge();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_PROTO)) {
            this.proto();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_EXPLOSIVES)) {
            this.explosives();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_VIBRO)) {
            this.vibroclawatt();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_NEXT)) {
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_SEARCHLIGHT)) {
            this.doSearchlight();
        } else if (actionEvent.getSource() == this.butMore) {
            ++this.buttonLayout;
            if (this.buttonLayout >= 3) {
                this.buttonLayout = 0;
            }
            this.setupButtonPanel();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 27) {
            this.clearattacks();
        } else if (keyEvent.getKeyCode() != 10 || !keyEvent.isControlDown() || this.client.isMyTurn()) {
            // empty if block
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void finishedMovingUnits(BoardViewEvent boardViewEvent) {
    }

    public void unitSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        Entity entity = this.client.game.getEntity(boardViewEvent.getEntityId());
        if (this.client.isMyTurn()) {
            if (this.client.getMyTurn().isValidEntity(entity, this.client.game)) {
                this.selectEntity(entity.getId());
            }
        } else {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.mechD.displayEntity(entity);
            if (entity.isDeployed()) {
                this.clientgui.bv.centerOnHex(entity.getPosition());
            }
        }
    }

    public void setThrashEnabled(boolean bl) {
        this.butThrash.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalThrashEnabled(bl);
    }

    public void setPunchEnabled(boolean bl) {
        this.butPunch.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalPunchEnabled(bl);
    }

    public void setKickEnabled(boolean bl) {
        this.butKick.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalKickEnabled(bl);
    }

    public void setPushEnabled(boolean bl) {
        this.butPush.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalPushEnabled(bl);
    }

    public void setTripEnabled(boolean bl) {
        this.butTrip.setEnabled(bl);
    }

    public void setGrappleEnabled(boolean bl) {
        this.butGrapple.setEnabled(bl);
    }

    public void setJumpJetEnabled(boolean bl) {
        this.butJumpJet.setEnabled(bl);
    }

    public void setClubEnabled(boolean bl) {
        this.butClub.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalClubEnabled(bl);
    }

    public void setBrushOffEnabled(boolean bl) {
        this.butBrush.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalBrushOffEnabled(bl);
    }

    public void setDodgeEnabled(boolean bl) {
        this.butDodge.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalDodgeEnabled(bl);
    }

    public void setProtoEnabled(boolean bl) {
        this.butProto.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalProtoEnabled(bl);
    }

    public void setVibroEnabled(boolean bl) {
        this.butVibro.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalVibroEnabled(bl);
    }

    public void setExplosivesEnabled(boolean bl) {
        this.butExplosives.setEnabled(bl);
    }

    public void setNextEnabled(boolean bl) {
        this.butNext.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalNextEnabled(bl);
    }

    private void setSearchlightEnabled(boolean bl) {
        this.butSearchlight.setEnabled(bl);
        this.clientgui.getMenuBar().setFireSearchlightEnabled(bl);
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
    }

    public Button getDoneButton() {
        return this.butDone;
    }

    private class AimedShotHandler
    implements ActionListener,
    ItemListener {
        private int aimingAt = -1;
        private int aimingMode = 0;
        private AimedShotDialog asd;
        private boolean canAim;

        public int getAimTable() {
            switch (this.aimingAt) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }

        public void setCanAim(boolean bl) {
            this.canAim = bl;
        }

        public void showDialog() {
            int n;
            if (PhysicalDisplay.this.ce() == null || PhysicalDisplay.this.target == null) {
                return;
            }
            if (this.asd != null) {
                n = this.aimingMode;
                this.closeDialog();
                this.aimingMode = n;
            }
            if (this.canAim) {
                n = PhysicalDisplay.this.ce().getElevation() + PhysicalDisplay.this.ce().getGame().getBoard().getHex(PhysicalDisplay.this.ce().getPosition()).getElevation();
                int n2 = PhysicalDisplay.this.target.getElevation() + PhysicalDisplay.this.ce().getGame().getBoard().getHex(PhysicalDisplay.this.target.getPosition()).getElevation();
                if (PhysicalDisplay.this.target instanceof Mech && PhysicalDisplay.this.ce() instanceof Mech && n == n2) {
                    String[] stringArray = new String[]{PhysicalDisplay.PHYSICAL_PUNCH, PhysicalDisplay.PHYSICAL_KICK};
                    boolean[] blArray = new boolean[]{true, true};
                    this.asd = new AimedShotDialog(PhysicalDisplay.this.clientgui.frame, Messages.getString("PhysicalDisplay.AimedShotDialog.title"), Messages.getString("PhysicalDisplay.AimedShotDialog.message"), stringArray, blArray, this.aimingAt, this, this);
                    this.asd.setVisible(true);
                    PhysicalDisplay.this.updateTarget();
                }
            }
        }

        public void closeDialog() {
            if (this.asd != null) {
                this.aimingAt = -1;
                this.aimingMode = 0;
                this.asd.setVisible(false);
                this.asd = null;
                PhysicalDisplay.this.updateTarget();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.closeDialog();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            IndexedCheckbox indexedCheckbox = (IndexedCheckbox)itemEvent.getSource();
            this.aimingAt = indexedCheckbox.getIndex();
            PhysicalDisplay.this.updateTarget();
        }
    }
}

