/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.ui.AWT.BoardView1;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.FiringDisplay;
import megamek.client.ui.AWT.MovementDisplay;
import megamek.client.ui.AWT.PhysicalDisplay;
import megamek.client.ui.AWT.TargetingPhaseDisplay;
import megamek.client.ui.Messages;
import megamek.common.AmmoType;
import megamek.common.BipedMech;
import megamek.common.BuildingTarget;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.HexTarget;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.MinefieldTarget;
import megamek.common.Mounted;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.BAVibroClawAttackAction;
import megamek.common.actions.BreakGrappleAttackAction;
import megamek.common.actions.GrappleAttackAction;
import megamek.common.options.GameOptions;
import megamek.common.weapons.CLFireExtinguisher;
import megamek.common.weapons.ISFireExtinguisher;

public class MapMenu
extends PopupMenu
implements ActionListener {
    private static final long serialVersionUID = 2879345079968414986L;
    Coords coords;
    IGame game;
    Component currentPanel;
    IBoard board;
    GameOptions options;
    Client client;
    ClientGUI gui;
    Entity selectedEntity;
    Entity myEntity;
    Targetable myTarget = null;

    public MapMenu(Coords coords, Client client, Component component, ClientGUI clientGUI) {
        this.coords = coords;
        this.game = client.game;
        this.currentPanel = component;
        this.board = client.getBoard();
        this.options = client.game.getOptions();
        this.client = client;
        this.gui = clientGUI;
        this.selectedEntity = this.myEntity = this.game.getEntity(clientGUI.getSelectedEntityNum());
        this.createMenu();
    }

    private boolean canSelectEntities() {
        return this.client.isMyTurn() && (this.currentPanel instanceof FiringDisplay || this.currentPanel instanceof PhysicalDisplay || this.currentPanel instanceof MovementDisplay || this.currentPanel instanceof TargetingPhaseDisplay);
    }

    private boolean canTargetEntities() {
        return this.client.isMyTurn() && (this.currentPanel instanceof FiringDisplay || this.currentPanel instanceof PhysicalDisplay || this.currentPanel instanceof TargetingPhaseDisplay);
    }

    private void createMenu() {
        this.removeAll();
        Menu menu = this.createSelectMenu();
        if (menu.getItemCount() > 0) {
            this.add(menu);
        }
        if ((menu = this.createViewMenu()).getItemCount() > 0) {
            this.add(menu);
        }
        if (this.client.isMyTurn() && this.myEntity != null) {
            this.selectTarget();
            menu = this.createTargetMenu();
            if (menu.getItemCount() > 0) {
                this.add(menu);
            }
            if (this.currentPanel instanceof MovementDisplay) {
                menu = this.createMovementMenu(this.myEntity.getPosition().equals(this.coords));
                if (this.getItemCount() > 0) {
                    this.addSeparator();
                }
                if (menu.getItemCount() > 0) {
                    this.add(menu);
                }
                if ((menu = this.createTurnMenu()).getItemCount() > 0) {
                    this.add(menu);
                }
                if ((menu = this.createStandMenu()).getItemCount() > 0) {
                    this.add(menu);
                }
                if ((menu = this.createPhysicalMenu(true)).getItemCount() > 0) {
                    this.addSeparator();
                    this.add(menu);
                }
            } else if (this.currentPanel instanceof FiringDisplay && this.client.isMyTurn()) {
                if (this.getItemCount() > 0) {
                    this.addSeparator();
                }
                if ((menu = this.createWeaponsFireMenu()).getItemCount() > 0) {
                    this.add(menu);
                }
                if ((menu = this.createModeMenu()).getItemCount() > 0) {
                    this.add(menu);
                }
                if ((menu = this.createTorsoTwistMenu()).getItemCount() > 0) {
                    this.add(menu);
                }
            } else if (this.currentPanel instanceof PhysicalDisplay && this.client.isMyTurn() && (menu = this.createPhysicalMenu(false)).getItemCount() > 0) {
                this.addSeparator();
                this.add(menu);
            }
        }
    }

    private MenuItem TargetMenuItem(Targetable targetable) {
        MenuItem menuItem = new MenuItem(Messages.getString("ClientGUI.targetMenuItem") + targetable.getDisplayName());
        String string = "";
        string = targetable instanceof Entity ? "E|" + ((Entity)targetable).getId() : (targetable instanceof BuildingTarget ? "B|" + targetable.getPosition().x + "|" + targetable.getPosition().y + "|" + (targetable.getTargetType() == 4) : (targetable instanceof MinefieldTarget ? "M|" + targetable.getPosition().x + "|" + targetable.getPosition().y : "H|" + targetable.getPosition().x + "|" + targetable.getPosition().y + "|" + targetable.getTargetType()));
        menuItem.setActionCommand(string);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapMenu.this.myTarget = MapMenu.this.decodeTargetInfo(actionEvent.getActionCommand());
                if (MapMenu.this.currentPanel instanceof FiringDisplay) {
                    ((FiringDisplay)MapMenu.this.currentPanel).target(MapMenu.this.myTarget);
                } else if (MapMenu.this.currentPanel instanceof PhysicalDisplay) {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).target(MapMenu.this.myTarget);
                } else if (MapMenu.this.currentPanel instanceof TargetingPhaseDisplay) {
                    ((TargetingPhaseDisplay)MapMenu.this.currentPanel).target(MapMenu.this.myTarget);
                }
            }
        });
        return menuItem;
    }

    private MenuItem createChargeMenuItem() {
        MenuItem menuItem = new MenuItem(Messages.getString("MovementDisplay.butCharge"));
        if (!this.client.game.getEntities(this.coords).hasMoreElements()) {
            return null;
        }
        menuItem.setActionCommand("moveCharge");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapMenu.this.plotCourse(actionEvent);
            }
        });
        return menuItem;
    }

    private MenuItem createDFAMenuItem() {
        MenuItem menuItem = new MenuItem(Messages.getString("MovementDisplay.butDfa"));
        if (!this.client.game.getEntities(this.coords).hasMoreElements()) {
            return null;
        }
        menuItem.setActionCommand("moveDFA");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapMenu.this.plotCourse(actionEvent);
            }
        });
        return menuItem;
    }

    private MenuItem SelectMenuItem(Entity entity) {
        MenuItem menuItem = new MenuItem(Messages.getString("ClientGUI.selectMenuItem") + entity.getDisplayName());
        menuItem.setActionCommand(Integer.toString(entity.getId()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Entity entity;
                    MapMenu.this.selectedEntity = entity = MapMenu.this.game.getEntity(Integer.parseInt(actionEvent.getActionCommand()));
                    if (MapMenu.this.currentPanel instanceof MovementDisplay) {
                        ((MovementDisplay)MapMenu.this.currentPanel).selectEntity(MapMenu.this.selectedEntity.getId());
                    } else if (MapMenu.this.currentPanel instanceof FiringDisplay) {
                        ((FiringDisplay)MapMenu.this.currentPanel).selectEntity(MapMenu.this.selectedEntity.getId());
                    } else if (MapMenu.this.currentPanel instanceof PhysicalDisplay) {
                        ((PhysicalDisplay)MapMenu.this.currentPanel).selectEntity(MapMenu.this.selectedEntity.getId());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem ViewMenuItem(Entity entity) {
        MenuItem menuItem = new MenuItem(Messages.getString("ClientGUI.viewMenuItem") + entity.getDisplayName());
        menuItem.setActionCommand(Integer.toString(entity.getId()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MapMenu.this.selectedEntity = MapMenu.this.game.getEntity(Integer.parseInt(actionEvent.getActionCommand()));
                    MapMenu.this.gui.setDisplayVisible(true);
                    MapMenu.this.gui.mechD.displayEntity(MapMenu.this.selectedEntity);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private Menu createSelectMenu() {
        Menu menu = new Menu("Select");
        if (this.canSelectEntities()) {
            Enumeration<Entity> enumeration = this.client.game.getEntities(this.coords);
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                if (!this.client.getMyTurn().isValidEntity(entity, this.client.game)) continue;
                menu.add(this.SelectMenuItem(entity));
            }
        }
        return menu;
    }

    private Menu createViewMenu() {
        Menu menu = new Menu("View");
        Enumeration<Entity> enumeration = this.client.game.getEntities(this.coords);
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            menu.add(this.ViewMenuItem(entity));
        }
        return menu;
    }

    private Menu createMovementMenu(boolean bl) {
        Menu menu = new Menu("Movement");
        if (this.myEntity == null) {
            return menu;
        }
        if (bl) {
            MenuItem menuItem = new MenuItem(Messages.getString("MovementDisplay.butWalk"));
            menuItem.setActionCommand("moveWalk");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            menu.add(menuItem);
            menuItem = new MenuItem(Messages.getString("MovementDisplay.butBackup"));
            menuItem.setActionCommand("moveBackUp");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            menu.add(menuItem);
            if (this.myEntity.getJumpMP() > 0) {
                menuItem = new MenuItem(Messages.getString("CommonMenuBar.moveJump"));
                menuItem.setActionCommand("moveJump");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                menu.add(menuItem);
            }
            if (this.game.getOptions().booleanOption("tacops_evade")) {
                menuItem = new MenuItem(Messages.getString("MovementDisplay.butEvade"));
                menuItem.setActionCommand("MoveEvade");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                menu.add(menuItem);
            }
            if (this.game.getPlanetaryConditions().isRecklessConditions() && !this.game.getBoard().inSpace()) {
                menuItem = new MenuItem(Messages.getString("MovementDisplay.butReckless"));
                menuItem.setActionCommand("moveReckless");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                menu.add(menuItem);
            }
        } else {
            MenuItem menuItem = new MenuItem(Messages.getString("MovementDisplay.butWalk"));
            menuItem.setActionCommand("moveWalk");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MapMenu.this.plotCourse(actionEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            menu.add(menuItem);
            menuItem = new MenuItem(Messages.getString("MovementDisplay.butBackup"));
            menuItem.setActionCommand("moveBackUp");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MapMenu.this.plotCourse(actionEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            menu.add(menuItem);
            if (this.myEntity.getJumpMP() > 0) {
                menuItem = new MenuItem(Messages.getString("CommonMenuBar.moveJump"));
                menuItem.setActionCommand("moveJump");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            MapMenu.this.plotCourse(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                menu.add(menuItem);
            }
            if (this.game.getOptions().booleanOption("tacops_evade")) {
                menuItem = new MenuItem(Messages.getString("MovementDisplay.butEvade"));
                menuItem.setActionCommand("MoveEvade");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            MapMenu.this.plotCourse(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                menu.add(menuItem);
            }
            if (this.game.getPlanetaryConditions().isRecklessConditions() && !this.game.getBoard().inSpace()) {
                menuItem = new MenuItem(Messages.getString("MovementDisplay.butReckless"));
                menuItem.setActionCommand("moveReckless");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            MapMenu.this.plotCourse(actionEvent);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                menu.add(menuItem);
            }
        }
        return menu;
    }

    private Menu createTurnMenu() {
        Menu menu = new Menu(Messages.getString("MovementDisplay.butTurn"));
        MenuItem menuItem = new MenuItem(Messages.getString("MovementDisplay.butTurnRight"));
        menuItem.setActionCommand("MoveTurnRight");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        menu.add(menuItem);
        menuItem = new MenuItem(Messages.getString("MovementDisplay.butTurnLeft"));
        menuItem.setActionCommand("MoveTurnLeft");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        menu.add(menuItem);
        menuItem = new MenuItem("About Face");
        menuItem.setActionCommand("MoveTurnRight");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        menu.add(menuItem);
        return menu;
    }

    private Menu createWeaponsFireMenu() {
        Menu menu = new Menu("Weapons");
        menu.add(this.createFireMenuItem());
        menu.add(this.createSkipMenuItem());
        menu.add(this.createAlphaStrikeMenuItem());
        if (this.myEntity.canFlipArms()) {
            menu.add(this.createFlipArmsMenuItem());
        }
        return menu;
    }

    private MenuItem createSkipMenuItem() {
        MenuItem menuItem = new MenuItem("Skip");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((FiringDisplay)MapMenu.this.currentPanel).nextWeapon();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createAlphaStrikeMenuItem() {
        MenuItem menuItem = new MenuItem("Alpha Strike");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Mounted mounted;
                    int n;
                    int n2;
                    FiringDisplay firingDisplay = (FiringDisplay)MapMenu.this.currentPanel;
                    int n3 = MapMenu.this.myEntity.getWeaponList().size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = MapMenu.this.gui.mechD.wPan.getSelectedWeaponNum();
                        mounted = MapMenu.this.myEntity.getEquipment(n);
                        if (mounted.getType().hasFlag(131072L) && mounted.usedInPhase() == IGame.Phase.PHASE_UNKNOWN) {
                            firingDisplay.fire();
                            continue;
                        }
                        firingDisplay.nextWeapon();
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = MapMenu.this.gui.mechD.wPan.getSelectedWeaponNum();
                        mounted = MapMenu.this.myEntity.getEquipment(n);
                        if (mounted.getType().hasFlag(65536L) && mounted.usedInPhase() == IGame.Phase.PHASE_UNKNOWN) {
                            firingDisplay.fire();
                            continue;
                        }
                        firingDisplay.nextWeapon();
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = MapMenu.this.gui.mechD.wPan.getSelectedWeaponNum();
                        mounted = MapMenu.this.myEntity.getEquipment(n);
                        if (mounted.usedInPhase() == IGame.Phase.PHASE_UNKNOWN) {
                            firingDisplay.fire();
                            continue;
                        }
                        firingDisplay.nextWeapon();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createFlipArmsMenuItem() {
        MenuItem menuItem = new MenuItem("Flip Arms");
        menuItem.setActionCommand(Integer.toString(this.myEntity.getId()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FiringDisplay firingDisplay = (FiringDisplay)MapMenu.this.currentPanel;
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    firingDisplay.updateFlipArms(!MapMenu.this.game.getEntity(n).getArmsFlipped());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createFireMenuItem() {
        MenuItem menuItem = new MenuItem("Fire");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((FiringDisplay)MapMenu.this.currentPanel).fire();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private Menu createPhysicalMenu(boolean bl) {
        Menu menu = new Menu("Physicals");
        if (bl) {
            MenuItem menuItem;
            if (this.myEntity.canCharge() && (menuItem = this.createChargeMenuItem()) != null) {
                menu.add(menuItem);
            }
            if (this.myEntity.canDFA() && (menuItem = this.createDFAMenuItem()) != null) {
                menu.add(menuItem);
            }
        } else {
            ToHitData toHitData;
            Serializable serializable;
            MenuItem menuItem = null;
            if (!(this.myEntity.isHullDown() || this.myEntity.isProne() || this.myEntity.hasHipCrit())) {
                menuItem = this.createKickMenuItem();
                if (menuItem != null) {
                    menu.add(menuItem);
                }
                if ((menuItem = this.createTripMenuItem()) != null) {
                    menu.add(menuItem);
                }
            }
            if (!(!(this.myEntity instanceof BipedMech) || this.myEntity.isLocationBad(5) && this.myEntity.isLocationBad(4) || (menuItem = this.createPunchMenuItem()) == null)) {
                menu.add(menuItem);
            }
            if (this.myEntity instanceof BipedMech && !this.myEntity.isLocationBad(5) && !this.myEntity.isLocationBad(4) && (menuItem = this.createPushMenuItem()) != null) {
                menu.add(menuItem);
            }
            if (this.myEntity.getJumpMP() > 0 && (menuItem = this.createJumpJetAttackMenuItem()) != null) {
                menu.add(menuItem);
            }
            if (this.myEntity.isProne() && (menuItem = this.createThrashMenuItem()) != null) {
                menu.add(menuItem);
            }
            if ((menuItem = this.createDodgeMenuItem()) != null) {
                menu.add(menuItem);
            }
            if (this.myEntity.getClubs().size() > 0 && ((Menu)(serializable = this.createClubMenu())).getItemCount() > 0) {
                menu.add((MenuItem)serializable);
            }
            serializable = GrappleAttackAction.toHit(this.client.game, this.myEntity.getId(), this.myTarget);
            ToHitData toHitData2 = BreakGrappleAttackAction.toHit(this.client.game, this.myEntity.getId(), this.myTarget);
            if ((((TargetRoll)serializable).getValue() != Integer.MAX_VALUE || toHitData2.getValue() != Integer.MAX_VALUE) && (menuItem = this.createGrappleMenuItem()) != null) {
                menu.add(menuItem);
            }
            if (this.myTarget != null && (toHitData = BAVibroClawAttackAction.toHit(this.client.game, this.myEntity.getId(), this.myTarget)).getValue() != Integer.MAX_VALUE && (menuItem = this.createVibroClawMenuItem()) != null) {
                menu.add(menuItem);
            }
        }
        return menu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private Menu createStandMenu() {
        Menu menu = new Menu();
        if (this.selectedEntity.isProne()) {
            menu.setLabel("Stand");
            menu.add(this.createStandMenuItem(false));
            if (this.game.getOptions().booleanOption("tacops_careful_stand") && this.myEntity.getWalkMP() > 2 && this.myEntity.moved < 1) {
                menu.add(this.createStandMenuItem(true));
            }
            if (this.game.getOptions().booleanOption("tacops_hull_down")) {
                menu.add(this.createHullDownMenuItem());
            }
        } else if (this.selectedEntity.isHullDown()) {
            menu.setLabel("Stand");
            menu.add(this.createStandMenuItem(false));
            if (this.game.getOptions().booleanOption("tacops_careful_stand")) {
                menu.add(this.createStandMenuItem(true));
            }
            menu.add(this.createProneMenuItem());
        } else {
            menu.setLabel("Prone");
            menu.add(this.createProneMenuItem());
            if (this.game.getOptions().booleanOption("tacops_hull_down")) {
                menu.add(this.createHullDownMenuItem());
            }
        }
        return menu;
    }

    private MenuItem createStandMenuItem(boolean bl) {
        MenuItem menuItem = new MenuItem(Messages.getString("MovementDisplay.butUp"));
        if (bl) {
            menuItem.setLabel("Careful Stand");
            menuItem.setActionCommand("moveCarefulStand");
        } else {
            menuItem.setActionCommand("moveGetUp");
        }
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createHullDownMenuItem() {
        MenuItem menuItem = new MenuItem(Messages.getString("MovementDisplay.butHullDown"));
        menuItem.setActionCommand("moveHullDown");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createProneMenuItem() {
        MenuItem menuItem = new MenuItem(Messages.getString("MovementDisplay.butDown"));
        menuItem.setActionCommand("moveGoProne");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((MovementDisplay)MapMenu.this.currentPanel).actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private Menu createTargetMenu() {
        Menu menu = new Menu("Target");
        if (this.canTargetEntities()) {
            Object object = this.client.game.getEntities(this.coords);
            while (object.hasMoreElements()) {
                Entity entity = object.nextElement();
                menu.add(this.TargetMenuItem(entity));
            }
            if (this.currentPanel instanceof FiringDisplay || this.currentPanel instanceof PhysicalDisplay || this.currentPanel instanceof TargetingPhaseDisplay) {
                object = this.board.getHex(this.coords);
                if (object != null && this.currentPanel instanceof FiringDisplay && !this.board.inSpace() && !this.board.inAtmosphere()) {
                    menu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 1)));
                    if (this.client.game.getOptions().booleanOption("tacops_start_fire") && (object.containsTerrain(1) || object.containsTerrain(5) || object.containsTerrain(9) || this.hasMunitionType(0x20000000L) || this.hasMunitionType(0x8000000000L) || this.hasMunitionType(0x1000000L))) {
                        menu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 2)));
                    }
                }
                if (object != null && object.containsTerrain(29)) {
                    menu.add(this.TargetMenuItem(new BuildingTarget(this.coords, this.board, false)));
                    if (this.client.game.getOptions().booleanOption("tacops_start_fire")) {
                        menu.add(this.TargetMenuItem(new BuildingTarget(this.coords, this.board, true)));
                    }
                }
                if (object != null && object.containsTerrain(22)) {
                    menu.add(this.TargetMenuItem(new BuildingTarget(this.coords, this.board, false)));
                    if (this.client.game.getOptions().booleanOption("tacops_start_fire")) {
                        menu.add(this.TargetMenuItem(new BuildingTarget(this.coords, this.board, true)));
                    }
                }
                if (object != null && this.currentPanel instanceof FiringDisplay) {
                    if (this.board.inSpace() && this.hasAmmoType(62)) {
                        menu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 17)));
                    } else {
                        if ((this.hasAmmoType(7) || this.hasAmmoType(45)) && (this.hasMunitionType(0x4000000000L) || this.hasMunitionType(0x400000L) || this.hasMunitionType(0x4000000L) || this.hasMunitionType(0x800000L) || this.hasMunitionType(0x1000000L) || this.hasMunitionType(0x2000000L))) {
                            menu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 6)));
                        }
                        if (this.hasMunitionType(262144L)) {
                            menu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 13)));
                        }
                        if (this.hasAmmoType(25)) {
                            menu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 14)));
                        }
                        if (this.hasAmmoType(15) || this.hasAmmoType(17) || this.hasAmmoType(68) || this.hasAmmoType(63) || this.hasAmmoType(57) || this.hasAmmoType(16) || this.hasAmmoType(18)) {
                            menu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 7)));
                        }
                        if (this.client.game.getOptions().booleanOption("tacops_start_fire") && object.containsTerrain(19) && this.hasFireExtinguisher()) {
                            menu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 8)));
                        }
                    }
                }
                if (object != null && this.currentPanel instanceof TargetingPhaseDisplay && !this.board.inSpace() && !this.board.inAtmosphere() && (this.hasAmmoType(15) || this.hasAmmoType(17) || this.hasAmmoType(68) || this.hasAmmoType(63) || this.hasAmmoType(57) || this.hasAmmoType(16) || this.hasAmmoType(18))) {
                    menu.add(this.TargetMenuItem(new HexTarget(this.coords, this.board, 7)));
                }
            }
        }
        return menu;
    }

    private void plotCourse(ActionEvent actionEvent) {
        ((MovementDisplay)this.currentPanel).actionPerformed(actionEvent);
        ((BoardView1)this.gui.bv).mouseAction(this.coords, 3, 16);
        ((BoardView1)this.gui.bv).mouseAction(this.coords, 1, 16);
    }

    private Targetable decodeTargetInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("E")) {
            return this.game.getEntity(Integer.parseInt(stringTokenizer.nextToken()));
        }
        Coords coords = new Coords(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        if (string2.equals("B")) {
            return new BuildingTarget(coords, this.board, Boolean.parseBoolean(stringTokenizer.nextToken()));
        }
        if (string2.equals("M")) {
            return new MinefieldTarget(coords, this.board);
        }
        return new HexTarget(coords, this.board, Integer.parseInt(stringTokenizer.nextToken()));
    }

    private boolean hasAmmoType(int n) {
        if (this.myEntity.getAmmo().size() < 1) {
            return false;
        }
        for (Mounted mounted : this.myEntity.getAmmo()) {
            if (((AmmoType)mounted.getType()).getAmmoType() != n) continue;
            return true;
        }
        return false;
    }

    private boolean hasMunitionType(long l) {
        if (this.myEntity.getAmmo().size() < 1) {
            return false;
        }
        for (Mounted mounted : this.myEntity.getAmmo()) {
            if (((AmmoType)mounted.getType()).getMunitionType() != l) continue;
            return true;
        }
        return false;
    }

    private boolean hasFireExtinguisher() {
        if (this.myEntity.getWeaponList().size() < 1) {
            return false;
        }
        for (Mounted mounted : this.myEntity.getWeaponList()) {
            if (!((WeaponType)mounted.getType() instanceof ISFireExtinguisher) && !((WeaponType)mounted.getType() instanceof CLFireExtinguisher)) continue;
            return true;
        }
        return false;
    }

    private MenuItem createTorsoTwistMenuItem(int n) {
        MenuItem menuItem = new MenuItem();
        if (n == 1) {
            menuItem.setLabel("Right");
        } else {
            menuItem.setLabel("Left");
        }
        menuItem.setActionCommand(Integer.toString(n));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    ((FiringDisplay)MapMenu.this.currentPanel).torsoTwist(n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createTorsoTwistMenuItem(Coords coords) {
        MenuItem menuItem = new MenuItem("Twist");
        menuItem.setActionCommand(coords.x + "|" + coords.y);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(actionEvent.getActionCommand(), "|");
                    Coords coords = new Coords(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                    ((FiringDisplay)MapMenu.this.currentPanel).torsoTwist(coords);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private Menu createTorsoTwistMenu() {
        Menu menu = new Menu();
        if (this.myEntity instanceof BipedMech) {
            menu.setLabel("Torso Twist");
            if (this.coords.equals(this.myEntity.getPosition())) {
                menu.add(this.createTorsoTwistMenuItem(1));
                menu.add(this.createTorsoTwistMenuItem(0));
            } else {
                menu.add(this.createTorsoTwistMenuItem(this.coords));
            }
        } else if (this.myEntity instanceof Tank && ((Tank)this.myEntity).getInternal(5) > -1) {
            menu.setLabel("Turret Twist");
            if (this.coords.equals(this.myEntity.getPosition())) {
                menu.add(this.createTorsoTwistMenuItem(1));
                menu.add(this.createTorsoTwistMenuItem(0));
            } else {
                menu.add(this.createTorsoTwistMenuItem(this.coords));
            }
        }
        return menu;
    }

    private void selectTarget() {
        Vector<Entity> vector = new Vector<Entity>();
        for (Entity entity : this.game.getEntitiesVector(this.coords)) {
            if (!entity.isEnemyOf(this.myEntity)) continue;
            vector.add(entity);
        }
        if (vector.size() == 1) {
            this.selectedEntity = (Entity)vector.firstElement();
            this.myTarget = this.selectedEntity;
            if (this.currentPanel instanceof FiringDisplay) {
                FiringDisplay firingDisplay = (FiringDisplay)this.currentPanel;
                firingDisplay.target(this.myTarget);
            } else if (this.currentPanel instanceof PhysicalDisplay) {
                ((PhysicalDisplay)this.currentPanel).target(this.myTarget);
            } else if (this.currentPanel instanceof TargetingPhaseDisplay) {
                ((TargetingPhaseDisplay)this.currentPanel).target(this.myTarget);
            }
        }
    }

    private Menu createModeMenu() {
        Menu menu = new Menu("Modes");
        int n = this.gui.mechD.wPan.getSelectedWeaponNum();
        Mounted mounted = this.myEntity.getEquipment(n);
        if (mounted != null && mounted.getType().hasModes()) {
            for (int i = 0; i < mounted.getType().getModesCount(); ++i) {
                menu.add(this.createModeMenuItem(mounted, i));
            }
        }
        return menu;
    }

    private MenuItem createModeMenuItem(Mounted mounted, int n) {
        MenuItem menuItem = new MenuItem();
        EquipmentMode equipmentMode = mounted.getType().getMode(n);
        if (equipmentMode.equals(mounted.curMode())) {
            menuItem.setLabel("* " + equipmentMode.getDisplayableName());
        } else {
            menuItem.setLabel(equipmentMode.getDisplayableName());
        }
        menuItem.setActionCommand(Integer.toString(n));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    int n2 = MapMenu.this.gui.mechD.wPan.getSelectedWeaponNum();
                    Mounted mounted = MapMenu.this.myEntity.getEquipment(n2);
                    mounted.setMode(n);
                    MapMenu.this.client.sendModeChange(MapMenu.this.myEntity.getId(), n2, n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createPunchMenuItem() {
        MenuItem menuItem = new MenuItem("Punch");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).punch();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createKickMenuItem() {
        MenuItem menuItem = new MenuItem("Kick");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).kick();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createPushMenuItem() {
        MenuItem menuItem = new MenuItem("Push");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).push();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createJumpJetAttackMenuItem() {
        MenuItem menuItem = new MenuItem("Jump Jet Attack");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).jumpjetatt();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createVibroClawMenuItem() {
        MenuItem menuItem = new MenuItem("Vibro Claw Attack");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).vibroclawatt();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createThrashMenuItem() {
        MenuItem menuItem = new MenuItem("Thrash");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).thrash();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createGrappleMenuItem() {
        MenuItem menuItem = new MenuItem("Grapple");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).doGrapple();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createTripMenuItem() {
        MenuItem menuItem = new MenuItem("Trip");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).trip();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private MenuItem createDodgeMenuItem() {
        MenuItem menuItem = new MenuItem("Dodge");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((PhysicalDisplay)MapMenu.this.currentPanel).dodge();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private Menu createClubMenu() {
        Menu menu = new Menu("Weapon");
        for (int i = 0; i < this.myEntity.getClubs().size(); ++i) {
            Mounted mounted = this.myEntity.getClubs().get(i);
            if (mounted.isDestroyed()) continue;
            menu.add(this.createClubMenuItem(mounted.getName(), i));
        }
        return menu;
    }

    private MenuItem createClubMenuItem(String string, int n) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setActionCommand(Integer.toString(n));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Mounted mounted = MapMenu.this.myEntity.getClubs().get(Integer.parseInt(actionEvent.getActionCommand()));
                    ((PhysicalDisplay)MapMenu.this.currentPanel).club(mounted);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    public void show(Component component, int n, int n2) {
        if (this.client.isMyTurn() && this.myEntity != null) {
            this.selectTarget();
        }
        super.show(component, n, n2);
    }
}

