#! /bin/sh

BIN=/usr/bin

  while true
  do
	clear
	echo
	echo "	Welcome to the LINUX/Pro NET-2 Maintenance"
	echo
	echo "This procedure will try to help you install the NET-2 networking"
	echo "package on your system, and to configure it. Not all of this work"
	echo "can be automated, but many of the dull things can be..."
	echo
	echo
	echo
	echo "	[1] Set/Change Hostname		[2] Set/Change Domainname"
	echo
	echo "	[3] Change Hosts		[4] Change Networks"
	echo
	echo "	[5] Change Hosts.Equiv		[6] Change Hosts.Lpd"
	echo
	echo "	[7] Change Services		[8] Change Protocols"
	echo

	echo
	echo -n "Enter your choice: "
	read cmd
	MENU=""
	case ${cmd} in
		0)	clear
			exit 0
			;;
		1)	MENU=hostname
			;;
		2)	MENU=domainname
			;;
		3)	MENU=hosts
			;;
		4)	MENU=networks
			;;
		5)	MENU=hostequiv
			;;
		6)	MENU=hostlpd
			;;
		7)	MENU=services
			;;
		8)	MENU=protocols
			;;
		*)	echo
			echo "	**** Invalid choice - please try again ****"
			MENU="XXXNONE"
			sleep 1
			;;
	esac

	if [ "x${MENU}" != "xXXXNONE" ]
	then
		if [ -f `pwd`/${MENU}.sh ]
		then
			/bin/sh `pwd`/${MENU}.sh
		else
			echo
			echo "	**** This menu is not available ****"
			sleep 1
		fi
	fi
  done

exit 0
  echo -n "Enter \"bin\" directory name [${BIN}]: "
  read ans
  if [ -n "${ans}" ]; then BIN="${ans}"; fi

  echo
  echo -n "Enter the name of this host (without domain): "
  read ans
  if [ ! -n "${ans}" ]
  then
	echo "You must supply a host name.  Aborting installation!"
	exit 1
  fi
  HOST="${ans}"

  echo
  echo -n "Enter the domainname of this host: "
  read ans
  if [ ! -n "${ans}" ]
  then
	echo "You must supply a domain name.  Aborting installation!"
	exit 1
  fi
  DOMAIN="${ans}"

  exit 0
