/* refreshhelp.c
   ------------------------------------------------------------------------
   Updates the in-line help in a C or AMLprogram from its associated .help
   file.
   
   You keep the .help file current, then run refreshhelp to insert the
   help into the main C or AML program.
   
   If you don't specify an extension on the input program file, it will
   first look for .c then .aml.  You can specify the .c or .aml if you
   wish.
   
   Written: 12/28/94 Randy Deardorff
   
   ----------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <rbdpaths.h>
#include MISC_H

#define TRUE 1
#define FALSE 0
#define MAXRECLEN 1024
#undef DEBUGGING

int main(argc, argv)
     int  argc;
     char *argv[];
{
  
  int    numargs, done, ipos, opos, ccode;
  char   progfile[128], helpfile[128], tempfile[128], cmd[512];
  char   iline[MAXRECLEN+1], oline[MAXRECLEN+1], temp[MAXRECLEN+1];
  FILE   *ioprog, *iohelp, *iotemp;
  
  
  /* Get arguments. */
  
  numargs = argc - 1;
  if (numargs != 1)
    {
      printf("Usage: refreshhelp <C_or_AML_program_file>\n");
      return (1);
    }
  
  
  /* Build filenames. */
  
  ccode=FALSE;
  strcpy(temp,argv[1]);
  ipos=strfind(temp,".",0);
  if (ipos >= 0)
    {
      /* Dot supplied in filename. */
      
      if (temp[ipos+1] == 'c')
        ccode=TRUE;
      strcpy(progfile,argv[1]);
      strbefore(progfile,".",temp);
    }
  else
    {
      /* NO dot supplied in filename. */
      /* Try C first. */
      
      strcpy(progfile,argv[1]);
      strcat(progfile,".c");
      if (sysstat(progfile,"exists"))
        {
          ccode=TRUE;
          strcpy(temp,argv[1]);
        }
      else
        {
          /* Not C, try AML. */
          
          strcpy(progfile,argv[1]);
          strcat(progfile,".aml");
          if (sysstat(progfile,"exists"))
            {
              ccode=FALSE;
              strcpy(temp,argv[1]);
            }
          else
            {
              printf("Can't find program file as C or AML.\n");
              return FALSE;
            }
        }
    }
  strcpy(helpfile,temp);
  strcat(helpfile,".help");
  strcpy(tempfile,temp);
  strcat(tempfile,".xxtemp");

  
#ifdef DEBUGGING
  printf("progfile=%s\n",progfile);
  printf("helpfile=%s\n",helpfile);
  printf("tempfile=%s\n",tempfile);
  if (ccode)
    printf("Doing C code.\n");
  else
    printf("Doing AML code.\n");
#endif
  
  
  /* Open files */
  
  if ((iohelp = fopen(helpfile,"r")) == NULL)
    {
      printf("Could not open %s\n",helpfile);
      return (1);
    }
  
  if ((ioprog = fopen(progfile,"r")) == NULL)
    {
      printf("Could not open %s\n",progfile);
      fclose(iohelp);
      return (1);
    }
  
  if ((iotemp = fopen(tempfile,"w")) == NULL)
    {
      printf("Could not open %s\n",tempfile);
      fclose(iohelp);
      fclose(ioprog);
      return (1);
    }
  
  
  /* Copy lines from the program file to the temp file until we get to the
     start of the in-line help statements, or end of file. */
  
  done=FALSE;
  while ((fgets(iline, MAXRECLEN, ioprog) != NULL) && (!done))
    {
      
      /* Check for the magic comment at start of in-line help. */

      if (ccode)
        {
          if (strcmp(iline,"  /* @ begin help */\n")==0)
            done=TRUE;
        }
      else
        {
          if (strcmp(iline,"/* @ begin help\n")==0)
            done=TRUE;
        }
      
      
      /* Write the current line to the temporary file. */
      
      fprintf(iotemp,"%s",iline);
    }
  
  
  /* Make sure we found magic help comment. */
  
  if (!done)
    {
      fclose(ioprog);
      fclose(iohelp);
      fclose(iotemp);
      sysdel(tempfile);
      printf("Could not find magic help comment in %s.\n",progfile);
      return FALSE;
    }
  
  
  /* Read the help file, creating in-line program code and write to
     the temp file. */
  
  while (fgets(iline, MAXRECLEN, iohelp) != NULL)
    {
      iline[strlen(iline)-1] = 0;        /* change LF to NULL */
      
      if (ccode)
        strcpy(oline,"  fprintf(io,\"");
      else
        strcpy(oline,"&s x [write %io% '");
      
      opos=strlen(oline);

      if (ccode)
        {
          for (ipos = 0; ipos < strlen(iline); ipos++)
            {
              if (iline[ipos]==34)
                oline[opos++]=92;

              if (iline[ipos]=='%')
                oline[opos++]='%';
              
              oline[opos++]=iline[ipos];
            }
          oline[opos++]=92;
          oline[opos++]='n';
          oline[opos++]=34;
          oline[opos++]=')';
          oline[opos++]=';';
          oline[opos++]='\0';
        }
      else
        {
          for (ipos = 0; ipos < strlen(iline); ipos++)
            {
              if (iline[ipos]==39)
                oline[opos++]=39;
              oline[opos++]=iline[ipos];
            }
          oline[opos++]=39;
          oline[opos++]=']';
          oline[opos++]='\0';
        }
      
      
      /* Write the current line to the temporary file. */
      
      fprintf(iotemp,"%s\n",oline);
    }
  
  
  /* Skip past the old in-line help in the program file (if any).  Then copy
     the remaining program code to the temporary file. */
  
  while (fgets(iline, MAXRECLEN, ioprog) != NULL)
    {
      if (ccode)
        {
          strext(iline,1,temp,',');
          strtrim(temp,"both",' ');
          if (strcmp(temp,"fprintf(io")!=0)
            fprintf(iotemp,"%s",iline);
        }
      else
        {
          strext(iline,2,temp,' ');
          strtrim(temp,"both",' ');
          if (strcmp(temp,"x")!=0)
            fprintf(iotemp,"%s",iline);
        }
    }
  
  
  /* Close files */
  
  if (fclose(ioprog) != 0)
    {
      printf("Could not close %s.\n",progfile);
      return (1);
    }
  
  if (fclose(iohelp) != 0)
    {
      printf("Could not close %s.\n",helpfile);
      return (1);
    }
  
  if (fclose(iotemp) != 0)
    {
      printf("Could not close %s.\n",tempfile);
      return (1);
    }


  /* Overwrite the program file with the output we just created. */

  sysrename(tempfile,progfile);

  
  /* All done. */
  
  return (0);
}
