/* dbftouch.c
   ------------------------------------------------------------------------
   Changes the last update date to today.
   In order that this can be used by dbfinstall verify phase, it is written
   as stand alone code.  No libraries or headers required.  To compile:
   cc -o dbftouch dbftouch.c
   
   Written: 07/11/94 Randy Deardorff.  USEPA Seattle.  
   --------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifndef SEEK_SET
#define SEEK_SET 0L
#endif

#define TRUE 1
#define FALSE 0

int main(argc, argv)
     int   argc;
     char  *argv[];
{
  int            numargs, i, numtoskip;
  FILE           *io;
  char           targetfile[80];
  unsigned char  m, d, y, mx, dx, yx, c, cdate[3];
  long           datestart;

  /* Set program datails. */

  char *progname="DBFTOUCH";
  char *progargs="<dbf_file>";
  char *progver= "5.7 July 13, 1998";
  int  authorid=TRUE;

  
  /* Get arguments. */
  
  numargs = argc - 1;
  if (numargs < 1 || numargs > 1)
    {
      usage(progname,progver,progargs,authorid);
      return FALSE;
    }
  
  
  /* Check arguments. */
  
  strcpy(targetfile,argv[1]);
  if (!(sysexist(targetfile)))
    {
      strcat(targetfile,".dbf");
      if (!(sysexist(targetfile)))
        {
          printf("%s: File \"%s\" not found.\n",progname,argv[1]);
          return FALSE;
        }
    }

  
  /* Get today's date. */
  
  if (!(getcurdate(&m,&d,&y)))
    {
      printf("%s: Could not get current date.\n",progname);
      return FALSE;
    }
  cdate[0]=y;
  cdate[1]=m;
  cdate[2]=d;

  
  /* Open the file in read/write mode. */
  
  if ((io = fopen(targetfile, "r+")) == NULL)
    {
      printf("%s: Could not open file \"%s\".\n",progname,targetfile);
      return FALSE;
    }

  
  /* Skip to where the date is.
     The date occupies 3 bytes starting at byte 2, arranged as y m d.
     The first byte in the file is the dbfid. */
  
  numtoskip=1;
  for (i=0; i < numtoskip; i++)
    if (fread(&c,sizeof(unsigned char),1,io) != sizeof(unsigned char))
      {
        printf("%s: Error reading file \"%s\".\n",progname,targetfile);
        fclose(io);
        return FALSE;
      }

  
  /* Set file position to the begining of the date. */
  
  datestart=ftell(io);
  if (fseek(io,datestart,SEEK_SET) != 0)
    {
      printf("%s: 999 Error writing file \"%s\".\n",progname,targetfile);
      fclose(io);
      return FALSE;
    }

  
  /* Overwrite the old date with the new date. */
  
  for (i=0; i <= 2; i++)
    {
      c=cdate[i];
      if (fwrite(&c,sizeof(unsigned char),1,io) != sizeof(unsigned char))
        {
          printf("%s: %d Error writing file \"%s\".\n",progname,i,targetfile);
          fclose(io);
          return FALSE;
        }
    }  
  
  
  /* Close file. */
  
  fclose(io);
  
  
  /* Done. */
  
  return TRUE;
}




/* sysexist
   Returns true if file exists and can be opened. */

int sysexist(filename)
     char *filename;
{
  FILE *io;
  if ((io = fopen(filename, "r")) == NULL)
    return FALSE;
  fclose(io);
  return TRUE;
}


/* getcurdate.c
   Sets m, d, and y to today. */

int getcurdate(m,d,y)
     unsigned char *m, *d, *y;
{
  int      i;
  long     current_time=time(0);
  char     timebuff[26], buff[5], month[4];
  unsigned char mc, dc, yc;
  
  /* Get time/date string from operating system.
     
     000000000011111111112222
     012345678901234567890123
     Wed Oct  7 08:37:47 1992
     */
  
  strcpy(timebuff,ctime(&current_time));
  
  /* Extract month. */
  
  month[0]=timebuff[4];
  month[1]=timebuff[5];
  month[2]=timebuff[6];
  month[3]='\0';
  upcase(month);
  mc=0;
  if (strcmp("JAN",month) == 0)
    mc=1;
  else
    if (strcmp("FEB",month) == 0)
      mc=2;
    else
      if (strcmp("MAR",month) == 0)
        mc=3;
      else
        if (strcmp("APR",month) == 0)
          mc=4;
        else
          if (strcmp("MAY",month) == 0)
            mc=5;
          else
            if (strcmp("JUN",month) == 0)
              mc=6;
            else
              if (strcmp("JUL",month) == 0)
                mc=7;
              else
                if (strcmp("AUG",month) == 0)
                  mc=8;
                else
                  if (strcmp("SEP",month) == 0)
                    mc=9;
                  else
                    if (strcmp("OCT",month) == 0)
                      mc=10;
                    else
                      if (strcmp("NOV",month) == 0)
                        mc=11;
                      else
                        if (strcmp("DEC",month) == 0)
                          mc=12;
  if (mc < 1 || mc > 12)
    return FALSE;
  
  /* Extract day. */
  
  if (timebuff[8]==' ' || timebuff[8]=='0')
    {
      buff[0]=timebuff[9];
      buff[1]='\0';
    }
  else
    {
      buff[0]=timebuff[8];
      buff[1]=timebuff[9];
      buff[2]='\0';
    }
  dc=atoi(buff);
  if (dc < 1 || dc > 31)
    return FALSE;
  
  /* Extract year. */

  if (timebuff[22]==' ' || timebuff[22]=='0')
    {
      buff[0]=timebuff[23];
      buff[1]='\0';
    }
  else
    {
      buff[0]=timebuff[22];
      buff[1]=timebuff[23];
      buff[2]='\0';
    }
  yc=atoi(buff);
  if (yc < 1 || yc > 99)
    return FALSE;
  
  /* Set return values. */
  
  *m=mc;
  *d=dc;
  *y=yc;
  return TRUE;
}

/* usage.c
   Gives usage, version, and author information. */

int usage(progname,progver,progargs,authorid)
     char *progname, *progver, *progargs;
     int  authorid;
{
  printf("%s Version %s.\n",progname,progver);
  if (authorid)
    {
      printf("Randy Deardorff, US EPA Region 10, Seattle.");
      printf(" (rdeardor@r0serv.r10.epa.gov)\n");
    }
  locase(progname);
  printf("Usage: %s %s\n",progname,progargs);
  return 1;
}
   
int locase(str)
     char *str;
{
  while(*str != '\0')
    {
      if(*str >= 'A' && *str <= 'Z')
        *str=*str+32;
      *str++;
    }
  return 1;
}

int upcase(str)
     char *str;
{
  while(*str != '\0')
    {
      if(*str >= 'a' && *str <= 'z')
        *str=*str-32;
      *str++;
    }
  return 1;
}
