/* LiTE
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Denis Oliver Kropp <dok@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __LITE__WINDOW_H__
#define __LITE__WINDOW_H__

#include <directfb.h>

#include "box.h"

#define LITE_WINDOW(l) ((LiteWindow*)(l))

typedef enum {
     LITE_BLEND_ALWAYS,
     LITE_BLEND_NEVER,
     LITE_BLEND_AUTO
} LiteBlendMode;

typedef struct _LiteWindow {
  LiteBox           box;

  int               width;
  int               height;

  DFBWindowID       id;

  char             *title;
  IDirectFBWindow  *window;
  IDirectFBSurface *surface;

  int               moving;
  int               old_x;
  int               old_y;

  DFBWindowEvent    last_resize;
  DFBWindowEvent    last_motion;

  int               has_focus;

  LiteBlendMode     content_mode;
  LiteBlendMode     opacity_mode;

  struct {
       DFBBoolean   enabled;
       DFBColor     color;
  } bg;

  LiteBox          *entered_box;
  LiteBox          *focused_box;

  int (*OnMove)     (struct _LiteWindow *self, int x, int y);
  int (*OnResize)   (struct _LiteWindow *self, int width, int height);

  int (*OnClose)    (struct _LiteWindow *self);
  int (*OnDestroy)  (struct _LiteWindow *self);

  int (*OnFocusIn)  (struct _LiteWindow *self);
  int (*OnFocusOut) (struct _LiteWindow *self);

  int (*OnEnter)    (struct _LiteWindow *self, int x, int y);
  int (*OnLeave)    (struct _LiteWindow *self, int x, int y);
} LiteWindow;
  


LiteWindow *lite_new_window            (IDirectFBDisplayLayer  *layer,
                                        int                     width,
                                        int                     height,
                                        DFBWindowCapabilities   caps,
                                        const char             *title);

DFBResult   lite_window_event_loop     (LiteWindow             *window);

void        lite_set_window_title      (LiteWindow             *window,
                                        const char             *title);

void        lite_set_window_opacity    (LiteWindow             *window,
                                        __u8                    opacity);

void        lite_set_window_background (LiteWindow             *window,
                                        DFBColor               *color);

void        lite_set_window_blend_mode (LiteWindow             *window,
                                        LiteBlendMode           content,
                                        LiteBlendMode           opacity);

void        lite_resize_window         (LiteWindow             *window,
                                        unsigned int            width,
                                        unsigned int            height);

void        lite_focus_box             (LiteWindow             *window,
                                        LiteBox                *box);

int         lite_handle_window_event   (LiteWindow             *window,
                                        DFBWindowEvent         *event);

void        lite_flush_window_events   (LiteWindow             *window);

LiteWindow *lite_find_my_window        (LiteBox                *box);

void        lite_close_window          (LiteWindow             *window);

void        lite_destroy_window        (LiteWindow             *window);

#endif /*  __LITE__WINDOW_H__  */
