/* LiTE
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Denis Oliver Kropp <dok@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __LITE__UTIL_H__
#define __LITE__UTIL_H__

#include <directfb.h>

#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif

#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif

#ifndef CLAMP
#define CLAMP(x,l,u) ((x) < (l) ? (l) : ((x) > (u) ? (u) : (x))) 
#endif


DFBResult lite_util_load_image (const char             *filename,
                                DFBSurfacePixelFormat   pixelformat,
                                IDirectFBSurface      **surface,
                                unsigned int           *width,
                                unsigned int           *height,
                                DFBImageDescription    *desc);

DFBResult lite_util_tile_image (IDirectFBSurface *surface,
                                const char       *filename,
                                int               x,
                                int               y,
                                int               nx,
                                int               ny);

IDirectFBSurface *lite_util_sub_surface (IDirectFBSurface *surface,
                                         int               x,
                                         int               y,
                                         int               width,
                                         int               height);

#endif /*  __LITE__UTIL_H__  */
