/* LiTE
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Denis Oliver Kropp <dok@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __LITE__TEXTLINE_H__
#define __LITE__TEXTLINE_H__

#include "box.h"

#define LITE_TEXTLINE(l) ((LiteTextLine*)(l))


typedef struct _LiteTextLine LiteTextLine;

typedef void (*TextLineEnterFunc) (const char *text, void *data);
typedef void (*TextLineAbortFunc) (void *data);

LiteTextLine *lite_new_textline (LiteBox *parent,
                                 int      x,
                                 int      y,
                                 int      width,
                                 int      height);

void lite_set_textline_text (LiteTextLine      *textline,
                             const char        *text);

void lite_on_textline_enter (LiteTextLine      *textline,
                             TextLineEnterFunc  func,
                             void              *funcdata);

void lite_on_textline_abort (LiteTextLine      *textline,
                             TextLineAbortFunc  func,
                             void              *funcdata);


#endif /*  __LITE__TEXTLINE_H__  */
