/* LiTE
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Denis Oliver Kropp <dok@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include <pthread.h>
#include <directfb.h>

#include "lite_internal.h"

#include "font.h"
#include "window.h"
#include "lite.h"

IDirectFB             *lite_dfb   = NULL;
IDirectFBDisplayLayer *lite_layer = NULL;

static int lite_refs = 0;

DFBResult lite_open()
{
     if (!lite_refs) {
          DFBResult ret;

          ret = DirectFBInit (NULL, NULL);
          if (ret) {
               DirectFBError ("lite_init: DirectFBInit", ret);
               return ret;
          }

          ret = DirectFBCreate (&lite_dfb);
          if (ret) {
               DirectFBError ("lite_init: DirectFBCreate", ret);
               lite_dfb = NULL;
               return ret;
          }

          ret = lite_dfb->GetDisplayLayer (lite_dfb, DLID_PRIMARY, &lite_layer);
          if (ret) {
               DirectFBError ("lite_init: GetDisplayLayer", ret);
               lite_layer = NULL;
               lite_dfb->Release (lite_dfb);
               lite_dfb = NULL;
               return ret;
          }

          _lite_font_init();

          if (!getenv ("LITE_NO_THEME"))
               lite_load_theme();

          lite_load_cursor();
     }

     lite_refs++;

     return DFB_OK;
}

void lite_close ()
{
     if (lite_refs) {
          if (!--lite_refs) {
               lite_free_theme();
               lite_free_cursor();

               lite_layer->Release (lite_layer);
               lite_layer = NULL;

               lite_dfb->Release (lite_dfb);
               lite_dfb   = NULL;
          }
     }
}
