/* LiTE
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Denis Oliver Kropp <dok@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __LITE__IMAGE_H__
#define __LITE__IMAGE_H__

#include "box.h"

#define LITE_IMAGE(l) ((LiteImage*)(l))


typedef struct _LiteImage LiteImage;


LiteImage *lite_new_image (LiteBox *parent,
                           int      x,
                           int      y,
                           int      width,
                           int      height);


int     lite_load_image (LiteImage  *image,
                         const char *filename);
                        
#endif /*  __LITE__IMAGE_H__  */
