/* LiTE
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Denis Oliver Kropp <dok@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include "lite_internal.h"

#include "util.h"
#include "image.h"


struct _LiteImage {
     LiteBox           box;

     int               width, height;

     IDirectFBSurface *surface;
};


static void draw_image (LiteBox *box, DFBRegion *region, DFBBoolean clear);
static void destroy_image (LiteBox *box);

LiteImage *lite_new_image (LiteBox *parent, int x, int y, int width, int height)
{
     LiteImage *image;

     image = calloc (1, sizeof(LiteImage));

     image->box.parent = parent;

     image->box.rect.x = x;
     image->box.rect.y = y;
     image->box.rect.w = width;
     image->box.rect.h = height;

     if (lite_init_box (LITE_BOX (image))) {
          free (image);
          return NULL;
     }

     image->box.Draw    = draw_image;
     image->box.Destroy = destroy_image;

     return image;
}

int lite_load_image (LiteImage *image, const char *filename)
{
     if (!filename || !image)
          return -1;

     if (lite_util_load_image (filename, DSPF_UNKNOWN, &image->surface,
                               &image->width, &image->height, NULL))
          return -1;

     lite_redraw_box (LITE_BOX (image));

     return 0;
}


/* file internals */

static void destroy_image (LiteBox *box)
{
     LiteImage *image = LITE_IMAGE (box);

     if (!image)
          return;

     if (image->surface)
          image->surface->Release (image->surface);

     lite_destroy_box (box);
}

static void draw_image (LiteBox *box, DFBRegion *region, DFBBoolean clear)
{
     LiteImage        *image   = LITE_IMAGE (box);
     IDirectFBSurface *surface = box->surface;

     surface->SetClip (surface, region);

     if (image->surface) {
          surface->SetBlittingFlags (surface, DSBLIT_BLEND_ALPHACHANNEL);
          surface->StretchBlit (surface, image->surface, NULL, NULL);
     }
     else if (clear)
          lite_clear_box (box, region);
}
