#ifndef __LITE__FONT_H__
#define __LITE__FONT_H__


typedef enum {
  LITE_FONT_PLAIN  = 0,
  LITE_FONT_BOLD   = 1,
  LITE_FONT_ITALIC = 2
} LiteFontStyle;

typedef struct _LiteFont LiteFont;

LiteFont *lite_get_font     (const char    *spec,
                             LiteFontStyle  style,
                             int            size);

LiteFont *lite_get_font_from_file (const char    *file,
                                   int            size);

void      lite_release_font (LiteFont      *font);


IDirectFBFont *lite_font (LiteFont *font);

#endif
