/* LiTE
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Denis Oliver Kropp <dok@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __LITE__BUTTON_H__
#define __LITE__BUTTON_H__

#include "box.h"

#define LITE_BUTTON(l) ((LiteButton*)(l))


typedef struct _LiteButton LiteButton;

typedef enum { 
  BS_NORMAL,
  BS_PRESSED,
  BS_HILITE,
  BS_DISABLED
} ButtonState;

typedef void (*ButtonPressFunc) (LiteButton *button, void *ctx);


LiteButton *lite_new_button (LiteBox *parent,
                             int      x,
                             int      y,
                             int      width,
                             int      height);


void    lite_enable_button (LiteButton *button,
                            int         enabled);

int     lite_set_button_state (LiteButton       *button,
                               ButtonState       state);
int     lite_set_button_image (LiteButton       *button,
                               ButtonState       state,
                               char             *filename);

int     lite_on_button_press (LiteButton      *button,
                              ButtonPressFunc  func,
                              void            *funcdata);
                        
#endif /*  __LITE__BUTTON_H__  */
