/* LiTE
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Denis Oliver Kropp <dok@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __LITE__BOX_H__
#define __LITE__BOX_H__

#include <directfb.h>

#define LITE_BOX(l) ((LiteBox*)(l))

typedef enum {
  LITE_TYPE_BOX = 0,
  LITE_TYPE_WINDOW
} LiteBoxType;

typedef struct _LiteBox {
  struct _LiteBox   *parent;

  int                n_children;
  struct _LiteBox  **children;

  LiteBoxType        type;

  DFBRectangle       rect;
  IDirectFBSurface  *surface;

  void              *user_data;

  int                is_focused;

  int  (*OnFocusIn)   (struct _LiteBox *self);
  int  (*OnFocusOut)  (struct _LiteBox *self);

  int  (*OnEnter)     (struct _LiteBox *self, int x, int y);
  int  (*OnLeave)     (struct _LiteBox *self, int x, int y);
  int  (*OnMotion)    (struct _LiteBox *self, int x, int y);
  int  (*OnButtonDown)(struct _LiteBox *self, int x, int y,
                       DFBInputDeviceButtonIdentifier button);
  int  (*OnButtonUp)  (struct _LiteBox *self, int x, int y,
                       DFBInputDeviceButtonIdentifier button);
  int  (*OnKeyDown)   (struct _LiteBox *self, DFBWindowEvent *evt);
  int  (*OnKeyUp)     (struct _LiteBox *self, DFBWindowEvent *evt);

  void (*Draw)   (struct _LiteBox *self, DFBRegion *region, DFBBoolean clear);
  void (*Destroy)(struct _LiteBox *self);
} LiteBox;
  


LiteBox *lite_new_box     (LiteBox *parent,
                           int      x,
                           int      y,
                           int      width,
                           int      height);

void     lite_redraw_box  (LiteBox *box);

void     lite_destroy_box (LiteBox *box);



int lite_init_box (LiteBox *box);
void lite_clear_box (LiteBox *box, DFBRegion *region);
void lite_draw_box_and_children (LiteBox *box, DFBBoolean clear);

#endif /*  __LITE__BOX_H__  */
