/* LiTE
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Denis Oliver Kropp <dok@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __LITE__ANIMATION_H__
#define __LITE__ANIMATION_H__

#include "box.h"

#define LITE_ANIMATION(l) ((LiteAnimation*)(l))


typedef struct _LiteAnimation LiteAnimation;


LiteAnimation *lite_new_animation (LiteBox *parent,
                                   int      x,
                                   int      y,
                                   int      width,
                                   int      height);


int  lite_load_animation    (LiteAnimation *animation,
                             const char    *filename,
                             int            still_frame,
                             int            frame_width,
                             int            frame_height);

void lite_start_animation   (LiteAnimation *animation,
                             unsigned int   ms_timeout);

int  lite_update_animation  (LiteAnimation *animation);

void lite_stop_animation    (LiteAnimation *animation);

int  lite_animation_running (LiteAnimation *animation);


                        
#endif /*  __LITE__ANIMATION_H__  */
