#include <stddef.h>

#include <lite/button.h>
#include <lite/image.h>
#include <lite/label.h>
#include <lite/lite.h>
#include <lite/textline.h>
#include <lite/window.h>

static void
button_pressed( LiteButton *button, void *ctx )
{
     lite_close_window( LITE_WINDOW(ctx) );
}

int
main (int argc, char *argv[])
{
     LiteButton   *button;
     LiteImage    *image;
     LiteLabel    *label;
     LiteTextLine *textline;
     LiteWindow   *window;

     /* initialize */
     if (lite_open())
          return 1;

     /* create a window */
     window = lite_new_window( NULL, 300, 200, DWCAPS_ALPHACHANNEL, "Simple" );
     
     
     /* setup the label */
     label = lite_new_label( LITE_BOX(window), 10, 10, 100, 20 );
     
     lite_set_label_text( label, "Hello World" );
     
     /* setup the textline */
     textline = lite_new_textline( LITE_BOX(window), 10, 40, 100, 20 );

     /* setup the button */
     button = lite_new_button( LITE_BOX(window), 230, 130, 50, 50 );

     lite_set_button_image( button, BS_NORMAL, EXAMPLESDATADIR "/stop.png" );
     lite_set_button_image( button, BS_DISABLED, EXAMPLESDATADIR "/stop_disabled.png" );
     lite_set_button_image( button, BS_HILITE, EXAMPLESDATADIR "/stop_highlighted.png" );
     lite_set_button_image( button, BS_PRESSED, EXAMPLESDATADIR "/stop_pressed.png" );

     lite_on_button_press( button, button_pressed, window );

     /* setup the image */
     image = lite_new_image( LITE_BOX(window), 200, 20, 64, 50 );

     lite_load_image( image, EXAMPLESDATADIR "/D.png" );

     
     /* show the window */
     lite_set_window_opacity( window, 0xff );

     /* run the default event loop */
     lite_window_event_loop( window );

     /* destroy the window with all this children and resources */
     lite_destroy_window( window );

     /* deinitialize */
     lite_close();

     return 0;
}
