#include <stdio.h>

#include <directfb.h>

#include <lite/button.h>
#include <lite/image.h>
#include <lite/label.h>
#include <lite/lite.h>
#include <lite/window.h>

     
static void
button_pressed( LiteButton *button, void *ctx )
{
     lite_close_window( LITE_WINDOW(ctx) );
}

int
main (int argc, char *argv[])
{
     LiteButton   *button;
     LiteImage    *image;
     LiteLabel    *label;
     LiteWindow   *window;

     if (DirectFBInit( &argc, &argv ))
          return 1;

     if (argc < 3) {
          printf( "\n  Usage: msgbox <title> <text>\n\n" );
          return 2;
     }

     if (lite_open())
          return 3;
     
     window = lite_new_window( NULL, 300, 100, DWCAPS_ALPHACHANNEL, argv[1] );
     

     /* setup image */
     image = lite_new_image( LITE_BOX(window), 7, 3, 64, 50 );

     lite_load_image( image, EXAMPLESDATADIR "/D.png" );
     
     /* setup label */
     label = lite_new_label( LITE_BOX(window), 80, 15, 200, 14 );
     
     lite_set_label_text( label, argv[2] );
     
     /* setup button */
     button = lite_new_button( LITE_BOX(window), 240, 43, 50, 50 );

     lite_set_button_image( button, BS_NORMAL, EXAMPLESDATADIR "/stop.png" );
     lite_set_button_image( button, BS_DISABLED, EXAMPLESDATADIR "/stop_disabled.png" );
     lite_set_button_image( button, BS_HILITE, EXAMPLESDATADIR "/stop_highlighted.png" );
     lite_set_button_image( button, BS_PRESSED, EXAMPLESDATADIR "/stop_pressed.png" );

     lite_on_button_press( button, button_pressed, window );

     
     
     lite_set_window_opacity( window, 0xff );

     lite_window_event_loop( window );

     lite_destroy_window( window );

     lite_close();

     return 0;
}
