#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <lite/button.h>
#include <lite/image.h>
#include <lite/label.h>
#include <lite/lite.h>
#include <lite/textline.h>
#include <lite/window.h>

static LiteWindow *window;

static void
on_enter( const char *text, void *ctx )
{
     int   i = 0;
     char *buf, *p, *args[strlen(text)+1];

     buf = p = strdup( text );

     /* destroy the window with all this children and resources */
     lite_destroy_window( window );

     /* deinitialize */
     lite_close();
     
     
     while (*p) {
          if (*p == ' ') {
               *p++ = 0;
               continue;
          }

          args[i++] = p++;

          while (*p && *p != ' ')
               p++;
     }

     args[i] = NULL;

     execvp( args[0], args );
     perror( "execvp" );
     
     exit(-1);
}

static void
on_abort( void *ctx )
{
     window->window->Close( window->window );
}

int
main (int argc, char *argv[])
{
     LiteLabel    *label;
     LiteTextLine *textline;

     /* initialize */
     if (lite_open())
          return 1;

     /* create a window */
     window = lite_new_window( NULL, 300, 40, DWCAPS_ALPHACHANNEL, "Run program..." );
     
     
     /* setup the label */
     label = lite_new_label( LITE_BOX(window), 10, 12, 60, 16 );
     
     lite_set_label_text( label, "Program" );
     
     /* setup the textline */
     textline = lite_new_textline( LITE_BOX(window), 70, 9, 220, 22 );

     lite_on_textline_enter( textline, on_enter, NULL );
     lite_on_textline_abort( textline, on_abort, NULL );

     lite_focus_box( window, LITE_BOX(textline) );
     
     /* show the window */
     lite_set_window_opacity( window, 0xff );

     window->window->RequestFocus( window->window );

     /* run the default event loop */
     lite_window_event_loop( window );

     /* destroy the window with all this children and resources */
     lite_destroy_window( window );

     /* deinitialize */
     lite_close();

     return 0;
}
