/*
 * directfb.c
 * directfb interfaces -- based on sdl.c 
 *
 * (C) 2010 Hans-Werner Hilse <hilse@web.de>
 *
 * Licensed under the GPLv2, or later.
 */

#include <stdlib.h>
#include <stdio.h>

#include <directfb.h>


#include "fb.h"
#include "input.h"
#include "rc.h"

struct fb fb;

static IDirectFB *dfb = NULL;
static IDirectFBSurface *primary = NULL;

#define DFBCHECK(x...)                                         \
  {                                                            \
    DFBResult err = x;                                         \
                                                               \
    if (err != DFB_OK)                                         \
      {                                                        \
        fprintf( stderr, "%s <%d>:\n\t", __FILE__, __LINE__ ); \
        DirectFBErrorFatal( #x, err );                         \
      }                                                        \
  }

static int vmode[3] = { 0, 0, 32 };

rcvar_t vid_exports[] =
{
	RCV_VECTOR("vmode", &vmode, 3),
	RCV_END
};

void vid_init()
{
	DFBSurfaceDescription dsc;

	if (!vmode[0] || !vmode[1])
	{
		int scale = rc_getint("scale");
		if (scale < 1) scale = 1;
		vmode[0] = 160 * scale;
		vmode[1] = 144 * scale;
	}

	DFBCHECK (DirectFBInit (NULL, NULL));
	DFBCHECK (DirectFBCreate (&dfb));
	DFBCHECK (dfb->SetCooperativeLevel (dfb, DFSCL_FULLSCREEN));  

	dsc.flags = (DFBSurfaceDescriptionFlags) (DSDESC_CAPS | DSDESC_PIXELFORMAT);
	dsc.caps = (DFBSurfaceCapabilities) (DSCAPS_PRIMARY | DSCAPS_FLIPPING);
	dsc.pixelformat = DSPF_RGB32;

	DFBCHECK (dfb->CreateSurface( dfb, &dsc, &primary ));
	DFBCHECK (primary->GetSize (primary, &fb.w, &fb.h));

	fprintf(stderr, "DirectFB setup succeeded. Got Screen %d x %d\n", fb.w, fb.h);

	DFBCHECK (primary->Lock (primary, DSLF_WRITE, (void**) &fb.ptr, &fb.pitch));
	
	fb.pelsize = 4; /* We always use 24bit color in 32bit uints */
	fb.indexed = 0;
	fb.cc[0].r = 0; /* R: 8bit @16 */
	fb.cc[0].l = 16;
	fb.cc[1].r = 0; /* G: 8bit @8 */
	fb.cc[1].l = 8;
	fb.cc[2].r = 0; /* B: 8bit @0 */
	fb.cc[2].l = 0;

	DFBCHECK (primary->Unlock (primary)); 

	fb.enabled = 1;
	fb.dirty = 0;

	joy_init();
}

void vid_setpal(int i, int r, int g, int b)
{
#if 0
	SDL_Color col;

	col.r = r; col.g = g; col.b = b;

	SDL_SetColors(screen, &col, i, 1);
#endif
}

void vid_preinit()
{
}

void vid_close()
{
	joy_close();
	primary->Release( primary );
	dfb->Release( dfb );
	fb.enabled = 0;
}

void vid_settitle(char *title)
{
}

void vid_begin()
{
	DFBCHECK (primary->Lock (primary, DSLF_WRITE, (void**) &fb.ptr, &fb.pitch));
}

void vid_end()
{
	DFBCHECK (primary->Unlock (primary)); 
	if (fb.enabled) DFBCHECK (primary->Flip (primary, NULL, (DFBSurfaceFlipFlags) (DSFLIP_ONSYNC)));
}

void ev_poll()
{
	joy_poll();
}


