{   XPM: Liest XPM-Grafiken in ein TBitmap ein  }
{   EasyStream: ein Streaming-Client fr VDR (VideoDiskRecorder)
    Copyright (C) [2008]  [Werner Sigrist] sigvdr@online.de

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see <http://www.gnu.org/licenses/>.
}
unit XPM;

interface

uses Graphics, Classes, SysUtils, Forms, StrUtils;

type
TXpm = class(TBitmap)
 public
   BildName:String;
   TransparenteFarbe:TColor;
   procedure LoadFromFile(const FileNameOrig:String);
 end;

const
   XPM_HEADER = '/* XPM */';
   STD_ICON:array[0..75] of string  =
             ('/* XPM */',
              'static char * monitor_xpm[] = { ',
              '"32 32 41 1",',
              '" 	c None",',
              '".	c #193564",',
              '"+	c #34566B",',
              '"@	c #305C9C",',
              '"#	c #3F5D8E",',
              '"$	c #3668B0",',
              '"%	c #3E69A6",',
              '"&	c #416EA5",',
              '"*	c #696B68",',
              '"=	c #4E70A0",',
              '"-	c #4273B0",',
              '";	c #4272BB",',
              '">	c #567CAC",',
              '",	c #777976",',
              '"T	c #4C7FCD",',
              '")	c #4D80C4",',
              '"!	c #5385BD",',
              '"~	c #6889B8",',
              '"{	c #758FA3",',
              '"]	c #748EB7",',
              '"^	c #8B8C89",',
              '"/	c #7694B6",',
              '"(	c #7DA1BC",',
              '"_	c #8E9FAF",',
              '":	c #9C9E9B",',
              '"<	c #80A8B2",',
              '"[	c #A8AAA7",',
              '"}	c #8DB3B2",',
              '"|	c #B5BAB7",',
              '"1	c #A1C6B9",',
              '"2	c #ACCEB5",',
              '"3	c #C2C7BE",',
              '"4	c #CDCFCC",',
              '"5	c #BBD9C0",',
              '"6	c #C3E0BC",',
              '"7	c #D7D9D6",',
              '"8	c #E0E2DF",',
              '"9	c #D8EFD1",',
              '"0	c #E9EBE7",',
              '"a	c #DBF5C9",',
              '"b	c #FCFEFB",',
              '"  [[::::::^^^^^^^^,,,,,,,,,,,   ",',
              '" [8bbbbbbbbbbbbbbbbbbbbbbbb03*  ",',
              '"[8b00000000000000000088877778|* ",',
              '"[b0{.......................{78* ",',
              '"[b0.#=====>===============#.40* ",',
              '"[b0.=/////_///]/]]]]]]]]]]=.70* ",',
              '"[b0.=//]/_|]]]]]]]]]]]]]]~=.78* ",',
              '"[b0.=]]]]|5/]]]]~~~~~~~~~~=.78* ",',
              '"[b0.=]]~/59/~~/~~~~~~~~~>&@.78* ",',
              '"[b0.=~~~_99<~/<~~~~~~>&%@@@.78* ",',
              '"[b0.@%&><99}~<5~!--%%@@@@@@.78* ",',
              '"[b0.@@@&1aa1>1a{%%&&&&&&&&&.78* ",',
              '"[b0.&&&/6665/6a1-/112222222+77* ",',
              '"[b0+2222a21a}a2a<5aaaaaaaaa+77* ",',
              '"[b0+25656}<a26<66a1<<<<<<<<+87* ",',
              '"[b0.&&----/aa5!1a1~)-;;$%%@.87* ",',
              '"[b0.@$$$$;!6a})/1~;;;;;$$$$.87* ",',
              '"[b0.@$$$;;)1a(T)~)TT;;;;$$$.87* ",',
              '"[b0.@$$$;;;<6!'''''';;;;$$$.84* ",',
              '"[b0.$$$$;;;(1)TTTTTTT;;;$$$.84* ",',
              '"[b0.$$$$;;;!<)TTTTTT;;;;$$$.84* ",',
              '"[b0.@$$$;;;)~TTTTTTT;;;;$$@.84* ",',
              '"[b0_......................._84* ",',
              '"[b0000088887778888888888888844* ",',
              '"[b0888774433333|333|333||33334* ",',
              '"[b88877443333|:[:3[::||:[:|333* ",',
              '"[b08774433333||8:3[44[|[8:3333* ",',
              '"[8b87744433343::[3|::|3::[333[* ",',
              '" [8bbb000000887477744444|443[*  ",',
              '"  ::::::::^^^^^^^^,,,,,,,,,**   ",',
              '"                                ",',
              '"                                "}');

procedure SaveStdIcon;

implementation

procedure SaveStdIcon;
var
    i:Integer;
    List:TStringList;
begin
   List := TStringList.Create;
   if FileExists('logos\monitor.xpm') then
      exit;
   if not DirectoryExists('logos') then
      CreateDir('logos');
   for i := 0 to 75 do
      List.Add(STD_ICON[i]);
   List.SaveToFile('logos\monitor.xpm');
   List.Free;
end;


procedure TXpm.LoadFromFile(const FileNameOrig:String);
var
   List:TStringList;
   Colors:Array[0..65535] of TColor;
   Zeile,i,j,x,y,p1,p2 : integer;
   grau : byte;
   s,Farbe : String;
   Zeichen : Integer;
   Farben,Zeilen,Spalten,BytesPerPixel:integer;
   TrColor:TColor;
   FileName:String;
begin
   FileName := AnsiReplaceStr(FileNameOrig,'*','');
   if LeftStr(FileName,8) = 'logos\D ' then
      FileName := LeftStr(FileName,9)+'.xpm';
   if not FileExists(FileName) then
      FileName := 'logos\monitor.xpm';
   TrColor := TransparenteFarbe;
   Zeile := 1;
   if not FileExists(FileName) then
      exit;
   PixelFormat := pf24bit;
   if pos('ORF1',Filename) > 0 then
      PixelFormat := pf24bit;
   Transparent := True;
   TransparentMode := tmFixed;
   TransparentColor := TrColor;
   List := TStringList.Create;
   List.LoadFromFile(FileName);
   if List[0] <> XPM_HEADER then
      exit;
   repeat
      s := List[Zeile];
      inc(Zeile);
   until s[1] <> '/';

   p1 := pos('*',s);
   p2 := pos('=',s);
   BildName := Copy(s,p1+2,p2-p1-5);
   repeat
      s := List[Zeile];
      inc(Zeile);
   until s[1] <> '/';

   p1 := pos(' ',s);
   Spalten := StrToInt(copy(s,2,p1-2));
   s := Copy(s,p1+1,Length(s));
   Width := Spalten;

   p1 := pos(' ',s);
   Zeilen := StrToInt(copy(s,1,p1-1));
   s := Copy(s,p1+1,Length(s));
   Height := Zeilen;

   p1 := pos(' ',s);
   Farben := StrToInt(copy(s,1,p1-1));
   s := Copy(s,p1+1,Length(s));

   p1 := pos('"',s);
   BytesPerPixel := StrToInt(copy(s,1,p1-1));
   s := Copy(s,p1+1,Length(s));

   for i := Zeile to Zeile+Farben-1 do begin
      s := List[i];
      case BytesPerPixel of
         1: Zeichen := Ord(s[2]);
         2: Zeichen := Ord(s[2]) shl 8 + Ord(s[3]);
       else
         Application.MessageBox(PChar('do not use *.XPM pictures with more then 65535 colors'),pchar(FileName),$00000000);
         exit;
      end;
      Farbe := copy(s,2+BytesPerPixel+3,Length(s));
      p1 := pos('"',Farbe);
      if p1 > 0 then
         Farbe := LeftStr(Farbe,p1-1);
      if Farbe[1] = '#' then
         // Rot und Blau vertauschen
         Colors[Zeichen] := StringToColor('$'+Farbe[6]+Farbe[7]+Farbe[4]+Farbe[5]+Farbe[2]+Farbe[3])
      else if UpperCase(Farbe) = 'NONE' then
             Colors[Zeichen] := TrColor
           else if UpperCase(LeftStr(Farbe,4)) = 'GRAY' then begin
                  try
                     grau := round(StrToInt(copy(Farbe,5,Length(Farbe)))*2.55);
                  except
                     grau := 127;
                  end;
                  Colors[Zeichen] := grau shl 16 + grau shl 8 + grau;
                end else
                  try
                     Colors[Zeichen] := StringToColor('cl'+Farbe);
                  except
                     Colors[Zeichen] := TrColor;
                  end;
   end;
   y := 0;
   Zeile := Zeile+Farben;
   repeat
      s := List[Zeile];
      if s[1] = '/' then
         inc(Zeile);
   until s[1] <> '/';
   for i := Zeile to Zeile+Zeilen-1 do begin
      s := List[i];
      for j := 0 to Spalten-1 do begin
         case BytesPerPixel of
            1: begin
                 x := 2+j;
                 Zeichen := Ord(s[x]);
               end;

            2: begin
                 x := 2+(j shl 1);
                 Zeichen := Ord(s[x]) shl 8 + Ord(s[x+1]);
               end;
         end;
         Canvas.Pixels[j,y] := Colors[Zeichen];
      end;
      inc(y);
   end;
   List.Free;
end;

end.
