{   EasyStream: ein Streaming-Client fr VDR (VideoDiskRecorder)
    Copyright (C) [2008]  [Werner Sigrist] sigvdr@online.de

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see <http://www.gnu.org/licenses/>.
}
unit SiForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, IniFiles, Valedit;

type

TCloseNotifyEvent =
   procedure(Sender:TObject; var CanClose:Boolean) of object;

  TWForm = class(TForm)
  private
    { Private-Deklarationen}
    FBeforeClose:TCloseNotifyEvent;
    Procedure HandleMessage(var Msg:TMessage);
  protected
    { Protected-Deklarationen}
  public
    constructor Create(X:TComponent); override;
    destructor Destroy; override;
    { Public-Deklarationen}
  published
    { Published-Deklarationen }
    property OnBeforeClose: TCloseNotifyEvent read FBeforeClose write FBeforeClose;
  end;

  TWForm2 = class(TWForm)
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SetAlwaysOnTop(mode:boolean);
  private
    { Private-Deklarationen }
    _params:TCreateParams;
    procedure CreateParams(var Params: TCreateParams);override;
  end;

function GetCaption(s:String):String;

implementation

Function FindFileF(FileName : String):String;
var
  SearchRec : TSearchRec;
begin
  if FindFirst(FileName, faAnyFile, SearchRec ) = 0 then                  // if found
     Result := SearchRec.Name
  else
     Result := '';
  FindClose(SearchRec);                                                   // close the find
end;

function GetCaption(s:String):String;
var
   i:Integer;
begin
   Result := s;
   for i := 1 to length(s) do
      if s[i] in [' ',':',';','-'] then begin
         result := Copy(s,1,i-1);
         exit;
      end;

end;

constructor TWForm.Create(X:TComponent);
var
   ini:TIniFile;
   sCaption:String;
   ProjektName,FileName, OldFileName:String;
begin
   inherited Create(x);
   self.WindowProc := self.HandleMessage;
   sCaption := GetCaption(Caption);
    ProjektName := ExtractFilePath(Application.ExeName)+'EasyStream';
    FileName := ProjektName+'.csi';
    if not FileExists(FileName) then begin
       OldFileName := FindFileF('easystream*.csi');
       if OldFileName <> '' then begin
          OldFileName :=ExtractFilePath(FileName)+OldFileName;
          RenameFile(OldFileName, FileName);
       end;
    end;
   ini := TIniFile.Create(FileName);
   if ini.SectionExists(sCaption) then begin
     Top := ini.ReadInteger(sCaption,'TOP',Top);
     Left := ini.ReadInteger(sCaption,'LEFT',Left);
     Height := ini.ReadInteger(sCaption,'HEIGHT',Height);
     Width := ini.ReadInteger(sCaption,'WIDTH',Width);
   end else begin
     if sCaption = 'EasyStream' then begin
        Top := 0;
        Left := 1;
        Height := 750;
        Width := 406;
     end;
   end;
   ini.Free;
end;

destructor TWForm.Destroy;
var
   ini:TIniFile;
   sCaption:String;
begin
   sCaption := GetCaption(Caption);
   ini := TIniFile.Create(ExtractFilePath(Application.ExeName)+'easystream.csi');
   ini.WriteInteger(sCaption,'TOP',top);
   ini.WriteInteger(sCaption,'LEFT',left);
   ini.WriteInteger(sCaption,'HEIGHT',height);
   ini.WriteInteger(sCaption,'WIDTH',width);
   ini.UpdateFile;
   ini.Free;
   inherited Destroy;
end;

Procedure TWForm.HandleMessage(var Msg:TMessage);
var CanClose:Boolean;
begin
  CanClose := True;
  if Msg.Msg = WM_CLOSE then
     if Assigned(FBeforeClose) then begin
        FBeforeClose(self,CanClose);
     end;
  if CanClose then
     WndProc(Msg);
end;

procedure TWForm2.CreateParams(var Params: TCreateParams);
begin
  inherited;
  _Params := Params;
  with Params do
  begin
//    ExStyle := ExStyle or WS_EX_TOPMOST;
    WndParent := 0;
  end;
end;

procedure TWForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TWForm2.SetAlwaysOnTop(mode:boolean);
begin
   with _Params do begin
      if mode = true then begin
         ExStyle := ExStyle or WS_EX_TOPMOST
       end else begin
         ExStyle := ExStyle or WS_EX_TOPMOST;
         ExStyle := ExStyle xor WS_EX_TOPMOST;
      end;
   end;
end;

end.



