{   EasyStream: ein Streaming-Client fr VDR (VideoDiskRecorder)
    Copyright (C) [2008]  [Werner Sigrist] sigvdr@online.de

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see <http://www.gnu.org/licenses/>.
}
unit EasyVideo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, SiForm, OleCtrls,
  Buttons, Registry, Math, AXVLC_TLB ;

type

  TForm2 = class(TWForm2)
    Panel1: TPanel;
    SBPlay: TSpeedButton;
    SBStop: TSpeedButton;
    TBVlc: TTrackBar;
    TBAudio: TTrackBar;
    Timer1: TTimer;
    SBAudio: TSpeedButton;
    SBPrev: TSpeedButton;
    SBNext: TSpeedButton;
    EPlayListItem: TEdit;
    SBAudioTrack: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SBShowMainForm: TSpeedButton;
    Splitter1: TSplitter;
    SpeedButton7: TSpeedButton;
    SBPause: TSpeedButton;
    SBStayOnTop: TSpeedButton;
    procedure PlayList;
    procedure PlayVLC(url,options:String);
    procedure AddUrl(url,options:String;position:integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure SBPlayClick(Sender: TObject);
    procedure SBStopClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure VLCPlugin1play(Sender: TObject);
    procedure VLCPlugin1stop(Sender: TObject);
    procedure SBPrevClick(Sender: TObject);
    procedure SBNextClick(Sender: TObject);
    procedure TBVlcChange(Sender: TObject);
    procedure TBAudioChange(Sender: TObject);
    procedure SBAudioClick(Sender: TObject);
    procedure AppMessage(var Msg: TMsg; var handled: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure VlcPlugCreate;
    procedure VlcPlugDestroy;
    procedure FormCreate(Sender: TObject);
    procedure SBAudioTrackClick(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SBShowMainFormClick(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SBPauseClick(Sender: TObject);
    procedure SBStayOnTopClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    VLCPlugin1: TVLCPlugin;
    blVLCPlugFound: boolean;
  end;

  VLCPlaylistMode = TOleEnum;
const
  VLCPlayListInsert      = $00000001;
  VLCPlayListReplace     = $00000002;
  VLCPlayListAppend      = $00000004;
  VLCPlayListGo          = $00000008;
  VLCPlayListCheckInsert = $00000010;

var
  Form2: TForm2;

implementation

{$R *.dfm}

procedure TForm2.AddUrl(url,options:String;position:integer);
var p:integer;
    s:array of string;
begin
   setlength(s,2);
   s[0] := ':vout-filter=deinterlace';
   s[1] := options;
   VLCPlugin1.stop;
   if Position = 0 then begin
      VLCPlugin1.playlistClear;
   end;
   VLCPlugin1.addTarget(url,s , VLCPlayListInsert, position);
   p := pos('rec/',url);
end;

procedure TForm2.PlayList;
begin
   SBPause.Down := False;
   SBPause.Enabled := True;
   VLCPlugin1.stop;
   VLCPlugin1.Volume := (TBAudio.Position * TBAudio.Position) div 100;
   VLCPlugin1.play;
   if not Visible then
      Show;
end;

procedure TForm2.PlayVLC(url,options:String);
var
  s:array of string;
begin
   SBPause.Down := false;
   SBPause.Enabled := false;
   setlength(s,2);
   s[0] := ':vout-filter=deinterlace';
   s[1] := options;
{
   setlength(s,2);
   s[0] := ':vout-filter=deinterlace';
   s[1] := options;
}
   VLCPlugin1.stop;
   VLCPlugin1.playlistClear;
   VLCPlugin1.addTarget(url,s , VLCPlayListInsert, 0);
   VLCPlugin1.Volume := (TBAudio.Position * TBAudio.Position) div 100;
   VLCPlugin1.play;
   if not Visible then
      Show;
   // ':deinterlace-mode=bob'
end;

procedure TForm2.FormKeyPress(Sender: TObject; var Key: Char);
begin
   Form2.Close;
end;

procedure TForm2.SBPlayClick(Sender: TObject);
begin
   if SBPause.Down then begin
      SBPause.Down := false;
      VLCPlugin1.pause;
    end else
      VLCPlugin1.play;
end;

procedure TForm2.SBPauseClick(Sender: TObject);
begin
   VLCPlugin1.pause;
end;

procedure TForm2.SBStopClick(Sender: TObject);
begin
   VLCPlugin1.stop;
end;


procedure TForm2.Timer1Timer(Sender: TObject);
var i:integer;
    eventTB:TNotifyEvent;
begin
   eventTB := TBVlc.OnChange;
   TBVlc.OnChange := nil;
   TBVlc.Position := round(VLCPlugin1.Position * 1000) ;
   i := VLCPlugin1.playlistIndex+1;
   EPlayListItem.Text := 'Teil:'+IntToStr(i);
   TBVlc.OnChange := eventTB;
end;

procedure TForm2.VLCPlugin1play(Sender: TObject);
begin
//   Application.MainForm.AlphaBlendValue := 100;
//   Application.MainForm.FormStyle := fsNormal;
   TBVlc.Position := 0;
   Timer1.Enabled :=True;
end;

procedure TForm2.VLCPlugin1stop(Sender: TObject);
begin
//   Application.MainForm.AlphaBlendValue := 255;
//   Application.MainForm.FormStyle := fsStayOnTop;
   Timer1.Enabled := False;
end;

procedure TForm2.TBVlcChange(Sender: TObject);
begin
   VLCPlugin1.Position := TBVlc.Position / TBVlc.Max;
end;

procedure TForm2.TBAudioChange(Sender: TObject);
begin
   VLCPlugin1.Volume := (TBAudio.Position * TBAudio.Position) div 100;
end;

procedure TForm2.SBAudioClick(Sender: TObject);
begin
   if not SBAudio.Down then begin
      SBAudio.Tag := TBAudio.Position;
      SBAudio.Caption := 'Off';
      TBAudio.Position := 0;
   end else begin
      SBAudio.Caption := 'On';
      TBAudio.Position := SBAudio.Tag;
   end;
end;

procedure TForm2.AppMessage(var Msg: TMsg; var handled: Boolean);
begin
  if (Msg.Message = WM_SYSCOMMAND) then begin
    if (Msg.wParam = SC_SCREENSAVE) then
       Handled := True;
    if (Msg.wParam = SC_MONITORPOWER) then
       Handled := True;
  end;     
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  // VLCPlugin1.Stop;
  VlcPlugDestroy;
  // Bildschirmschoner ausschalten
  Application.OnMessage := nil;
end;

procedure TForm2.VlcPlugCreate;
var
  Reg: TRegistry;
begin
//   blVLCPlugFound := false;
  if  not blVLCPlugFound then begin
  // Is VLC ActiveX Plugin installed on this PC?
     Reg := TRegistry.Create;
     try
       Reg.RootKey := HKEY_LOCAL_MACHINE;
       if Reg.OpenKeyReadOnly('\Software\Classes\VideoLAN.VLCPlugin.1\') then begin
           blVLCPlugFound := true;
       end;
     finally
       FreeAndNil(Reg);
     end;
  end;
  // Bildschirmschoner ausschalten
  Application.OnMessage := AppMessage;

  // Zuerst die alte Instanz lschen
  if VLCPlugin1 <> nil then
     VlcPlugDestroy;

  if blVLCPlugFound then begin
    VLCPlugin1 := TVLCPlugin.Create(Self);
    VLCPlugin1.Parent := Self; // Means: Place the VLC-Player into Form1
    VLCPlugin1.Align := alClient;
    VLCPlugin1.Onplay := VLCPlugin1Play;
    VLCPlugin1.OnStop := VLCPlugin1Stop;
  end else begin
    ShowMessage('I am really sorry, but VLC (or its ActiveX Plugin) is currently not installed on this PC!');
  end;
end;

procedure TForm2.VlcPlugDestroy;
begin
  if VLCPlugin1 <> nil then begin
    VLCPlugin1.stop;
    FreeAndNil(VLCPlugin1);
  end;
end;


procedure TForm2.FormCreate(Sender: TObject);
begin
  blVLCPlugFound := false;
  SpeedButton7Click(Sender);
end;

procedure TForm2.SBAudioTrackClick(Sender: TObject);
var k:integer;
begin
   if assigned(Form2.VLCPlugin1) then begin
      k := Form2.VLCPlugin1.GetVariable('key-audio-track');
      Form2.VLCPlugin1.SetVariable('key-pressed',k);
   end;
end;

procedure TForm2.SBPrevClick(Sender: TObject);
var k:integer;
begin
   if assigned(Form2.VLCPlugin1) then begin
      k := Form2.VLCPlugin1.GetVariable('key-prev');
      Form2.VLCPlugin1.SetVariable('key-pressed',k);
   end;
end;

procedure TForm2.SBNextClick(Sender: TObject);
var k:integer;
begin
   if assigned(Form2.VLCPlugin1) then begin
      k := Form2.VLCPlugin1.GetVariable('key-next');
      Form2.VLCPlugin1.SetVariable('key-pressed',k);
   end;
end;


procedure TForm2.SpeedButton3Click(Sender: TObject);
var k:integer;
begin
   if assigned(Form2.VLCPlugin1) then begin
      k := Form2.VLCPlugin1.GetVariable('key-faster');
      Form2.VLCPlugin1.SetVariable('key-pressed',k);
   end;
end;

procedure TForm2.SpeedButton4Click(Sender: TObject);
var k:integer;
begin
   if assigned(Form2.VLCPlugin1) then begin
      k := Form2.VLCPlugin1.GetVariable('key-slower');
      Form2.VLCPlugin1.SetVariable('key-pressed',k);
   end;
end;

procedure TForm2.SpeedButton5Click(Sender: TObject);
var k:integer;
begin
   if assigned(Form2.VLCPlugin1) then begin
      k := Form2.VLCPlugin1.GetVariable('key-jump-5min');
      Form2.VLCPlugin1.SetVariable('key-pressed',k);
   end;
end;

procedure TForm2.SpeedButton6Click(Sender: TObject);
var k:integer;
begin
   if assigned(Form2.VLCPlugin1) then begin
      k := Form2.VLCPlugin1.GetVariable('key-jump+5min');
      Form2.VLCPlugin1.SetVariable('key-pressed',k);
   end;
end;

procedure TForm2.SBShowMainFormClick(Sender: TObject);
begin
   Application.MainForm.Visible := True;
end;

procedure TForm2.SpeedButton7Click(Sender: TObject);
begin
   with Panel1 do begin
   if Height <> 20 then begin
      Form2.Height := Form2.Height-53;
      Height := 20
    end else begin
      Height := 73;
      Form2.Height := Form2.Height+53;
    end;
   end;
end;

procedure TForm2.SBStayOnTopClick(Sender: TObject);
begin
   if SBStayOnTop.Down then
      FormStyle := fsStayOnTop
   else
      FormStyle := fsNormal;
end;

end.
