{   EasyStream: ein Streaming-Client fr VDR (VideoDiskRecorder)
    Copyright (C) [2008]  [Werner Sigrist] sigvdr@online.de

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see <http://www.gnu.org/licenses/>.
}
unit EasyMain;

interface


uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Psock, NMHttp, StrUtils, ShellApi, ComCtrls, Buttons,
  SiForm, IniFiles, ImgList, DateUtils, EasyVideo, ExtCtrls, ScktComp,
  IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient, Grids,
  OleCtrls, SHDocVw, ActnList, TLHelp32, jpeg, TypInfo, IdUDPBase,
  IdUDPClient, IdEcho, IdRawBase, IdRawClient, IdIcmpClient, Xpm, uPing,
  EasyDVB, Beschreibung, Mask;


const
    ButtonHeight=20;
    DblClickTime=500;
    CH_Logo=1;
    CH_Nr=0;
    CH_Name=2;
    CH_Zeit=3;
    CH_Titel=3;
    CH_TTitel=3;
    CH_Gruppe=CH_TTitel+1;
    CH_Frequenz=CH_TTitel+2;
    CH_Parameter=CH_TTitel+3;
    CH_TVRadio=CH_Parameter;
    CH_Quelle=CH_TTitel+4;
    CH_SRate=CH_TTitel+5;
    CH_VPID=CH_TTitel+6;
    CH_APID=CH_TTitel+7;
    CH_TPID=CH_TTitel+8;
    CH_CA=CH_TTitel+9;
    CH_SID=CH_TTitel+10;
    CH_NID=CH_TTitel+11;
    CH_TID=CH_TTitel+12;
    CH_RID=CH_TTitel+13;
    EPG_KANAL=0;
    EPG_DAUER=1;
    EPG_TITEL=2;
    EPG_ZEIT=3;
    EPG_TEXT=4;
    EPG_NR=5;
    RowPixel=20;
    WochenTage : array[1..7] of string = ('Mo','Di','Mi','Do','Fr','Sa','So');

type

  TSbId = (sbMouseLeft,sbMouseRight,sbMouseMove);
  TProgrammTyp = (PrgTV,PrgRadio,PrgDaten);
  TSVDRPMode = (SVDRP_NoQuit,SVDRP_Quit);
  
  TUserSG = class(TCustomGrid); // protected procedure MoveRow verfgbar machen

  TForm1 = class(TWForm)
    PageControl1: TPageControl;
    TSKanaele: TTabSheet;
    TSRecord: TTabSheet;
    ImageList1: TImageList;
    TSTimer: TTabSheet;
    IdTCPClient1: TIdTCPClient;
    TimerSGProgrammDblClick: TTimer;
    SGProgramm: TStringGrid;
    TSOptionen: TTabSheet;
    SGTimer: TStringGrid;
    SGRecord: TStringGrid;
    Panel1: TPanel;
    SBLoadChannel: TSpeedButton;
    SBTV: TSpeedButton;
    SBRadio: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Splitter2: TSplitter;
    Panel2: TPanel;
    SpeedButton3: TSpeedButton;
    Splitter3: TSplitter;
    SBRecordPlay: TSpeedButton;
    Panel3: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SBRecDelete: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SBRecToggle: TSpeedButton;
    Splitter4: TSplitter;
    cs: TClientSocket;
    Action: TActionList;
    Kanaele: TAction;
    Aufnahmen: TAction;
    Timer: TAction;
    Auf: TAction;
    Ab: TAction;
    OK: TAction;
    TProgramm: TTimer;
    TAufnahmen: TTimer;
    ListeLaden: TAction;
    Audio: TAction;
    PageControl2: TPageControl;
    TSOStreaming: TTabSheet;
    TSOProgramm: TTabSheet;
    TSOPlayer: TTabSheet;
    TSORemote: TTabSheet;
    ERemote: TEdit;
    SBRemote: TSpeedButton;
    SGRemote: TStringGrid;
    Label4: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    EVlcOptions: TEdit;
    Label16: TLabel;
    EPlayList: TEdit;
    Label23: TLabel;
    Splitter1: TSplitter;
    TSOTest: TTabSheet;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    SVDRP: TButton;
    Edit6: TEdit;
    Memo2: TMemo;
    Memo1: TMemo;
    Label22: TLabel;
    TSEpg: TTabSheet;
    Panel5: TPanel;
    Splitter5: TSplitter;
    SGEpgNow: TStringGrid;
    Epg: TAction;
    SBEpgLeft: TSpeedButton;
    SBEpgRight: TSpeedButton;
    SBAufnahme: TSpeedButton;
    Aufnahme: TAction;
    Links: TAction;
    Right: TAction;
    TV: TAction;
    Radio: TAction;
    Abschalten: TAction;
    BildFormat: TAction;
    TForm1Visible: TTimer;
    PrgScreenShoot: TAction;
    MEpg: TRichEdit;
    TSOAbout: TTabSheet;
    Memo3: TMemo;
    VolUp: TAction;
    VolDown: TAction;
    Mute: TAction;
    SBEpgNow: TSpeedButton;
    SBEpgNext: TSpeedButton;
    SBEpgChannel: TSpeedButton;
    EpgToggle: TAction;
    TVRadio: TAction;
    MainFormClose: TAction;
    Panel4: TPanel;
    SpeedButton8: TSpeedButton;
    Label24: TLabel;
    Label17: TLabel;
    Label25: TLabel;
    SpeedButton2: TSpeedButton;
    Button1: TButton;
    CBDeInterlace: TComboBox;
    Label31: TLabel;
    SBEpgPlay: TSpeedButton;
    LDiskFree: TLabel;
    GroupBox1: TGroupBox;
    Label19: TLabel;
    Label18: TLabel;
    ERecDir: TEdit;
    ELaufwerk: TEdit;
    Label20: TLabel;
    Label21: TLabel;
    EPassword: TEdit;
    EUser: TEdit;
    Label35: TLabel;
    Label36: TLabel;
    EIpAdr: TEdit;
    Label37: TLabel;
    Label38: TLabel;
    EPort: TEdit;
    Label39: TLabel;
    Label40: TLabel;
    ESvdrp: TEdit;
    Label7: TLabel;
    MHelp: TMemo;
    Pause: TAction;
    Play: TAction;
    Stop: TAction;
    BFemonSVDRP: TButton;
    IdUDP_WOL: TIdUDPClient;
    IdIcmpClient1: TIdIcmpClient;
    BVdrConnect: TButton;
    CBNetDisconnect: TCheckBox;
    PConnecting: TPanel;
    GroupBox6: TGroupBox;
    Label6: TLabel;
    Label2: TLabel;
    Label10: TLabel;
    ENumRadio: TEdit;
    ENumTV: TEdit;
    Label13: TLabel;
    Label15: TLabel;
    Label14: TLabel;
    ERecVor: TEdit;
    Label11: TLabel;
    ERecNach: TEdit;
    Label12: TLabel;
    Label26: TLabel;
    EEpgIntervall: TEdit;
    Label27: TLabel;
    TBFontSize: TTrackBar;
    LFontHeight: TLabel;
    Button8: TButton;
    SpeedButton5: TSpeedButton;
    TSOAllgemein: TTabSheet;
    GroupBox4: TGroupBox;
    Label8: TLabel;
    BSaveLanguage: TButton;
    Button7: TButton;
    CBSprache: TComboBox;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label5: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    ETelnet: TEdit;
    ETelnetParameter: TEdit;
    CBResizeVideo: TCheckBox;
    BVTPSend: TButton;
    EVTP: TEdit;
    Label9: TLabel;
    SBChannelSearch: TSpeedButton;
    Label53: TLabel;
    LVTPStd: TLabel;
    Button6: TButton;
    SGVDR: TStringGrid;
    CBUseExtern: TCheckBox;
    PBDiskFree: TProgressBar;
    PDevice1: TPanel;
    imgDVB: TImage;
    imgRed: TImage;
    imgGreen: TImage;
    SBVDRCheck: TSpeedButton;
    Panel6: TPanel;
    ImgKanal: TImage;
    LTVName: TLabel;
    LProgName: TLabel;
    CBVlc: TCheckBox;
    EMacAdr: TMaskEdit;
    LMacAdr: TLabel;
    LMacAdr2: TLabel;
    LMacAdr3: TLabel;
    B_WOL: TButton;
    CB_WOL: TCheckBox;
    CBVDRSwitch: TCheckBox;
    Splitter6: TSplitter;
    Panel7: TPanel;
    Label34: TLabel;
    Label33: TLabel;
    SBSgVdrNew: TSpeedButton;
    BVdrConnect2: TSpeedButton;
    Label56: TLabel;
    SBSgVdrDelete: TSpeedButton;
    procedure SmbConnect(Ein:boolean);
    procedure GetDvbStatus;
    procedure GetFreeSpace;
    procedure EasyStreamInit;
    procedure ReadVdrList(ini:TIniFile);
    procedure SaveVdrList(ini:TIniFile);
    procedure FormCreate(Sender: TObject);
    procedure OpenProgram(prog, params: string);
    function ReadSGCols(ini:TIniFile;SG:TStringGrid;Name:String):boolean;
    procedure SaveSGCols(ini:TIniFile;SG:TStringGrid;Name:String);
    procedure FormDestroy(Sender: TObject);
    procedure SVDRPClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure SGProgrammDoppelKlick(ARow:longint);
    procedure SGProgrammMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SBLoadChannelClick(Sender: TObject);
    procedure LoadChannel(PrgTyp:TProgrammTyp);
    procedure TimerSGProgrammDblClickTimer(Sender: TObject);
    procedure ReadEpgSvdrp(ARow:Integer);
    procedure SGProgrammSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    function RecString(ZeitStr,Titel:String):String;
    procedure ReadTimer;
    procedure ReadRecText;
    procedure ReadRecord;
    procedure SpeedButton1Click(Sender: TObject);
    procedure IdTCPClient1Connected(Sender: TObject);
    procedure IdTCPClient1Disconnected(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SGRecordClick(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    function GetRecPath(Aufnahme:String;index:Integer):string;
    procedure SBRecordPlayClick(Sender: TObject);
    procedure SGRecordMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SGTimerMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SBRecDeleteClick(Sender: TObject);
    procedure SGDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SBRecToggleClick(Sender: TObject);
    procedure csConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure csConnecting(Sender: TObject; Socket: TCustomWinSocket);
    procedure csDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure csError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure csLookup(Sender: TObject; Socket: TCustomWinSocket);
    procedure csRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure KanaeleExecute(Sender: TObject);
    procedure AufnahmenExecute(Sender: TObject);
    procedure TimerExecute(Sender: TObject);
    procedure AufExecute(Sender: TObject);
    procedure AbExecute(Sender: TObject);
    procedure OKExecute(Sender: TObject);
    procedure TProgrammTimer(Sender: TObject);
    procedure TAufnahmenTimer(Sender: TObject);
    procedure SBRemoteClick(Sender: TObject);
    procedure ListeLadenExecute(Sender: TObject);
    procedure AudioExecute(Sender: TObject);
    procedure EpgExecute(Sender: TObject);
    procedure SBEpgRightClick(Sender: TObject);
    procedure SBEpgLeftClick(Sender: TObject);
    procedure SGEpgClick(Sender: TObject);
    procedure SBAufnahmeClick(Sender: TObject);
    procedure AufnahmeExecute(Sender: TObject);
    procedure LinksExecute(Sender: TObject);
    procedure RightExecute(Sender: TObject);
    procedure TVExecute(Sender: TObject);
    procedure RadioExecute(Sender: TObject);
    procedure AbschaltenExecute(Sender: TObject);
    procedure BildFormatExecute(Sender: TObject);
    procedure TForm1VisibleTimer(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure PrgScreenShootExecute(Sender: TObject);
    procedure VolUpExecute(Sender: TObject);
    procedure VolDownExecute(Sender: TObject);
    procedure MuteExecute(Sender: TObject);
    procedure SBEpgNowClick(Sender: TObject);
    procedure SBEpgNextClick(Sender: TObject);
    procedure SBEpgChannelClick(Sender: TObject);
    procedure EpgToggleExecute(Sender: TObject);
    procedure TVRadioExecute(Sender: TObject);
    procedure MainFormCloseExecute(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SBEpgPlayClick(Sender: TObject);
    procedure PrintControls(Name:String;Control:TWinControl);
    procedure BSaveLanguageClick(Sender: TObject);
    procedure ReadControls(Name:String;Control:TWinControl);
    procedure Button7Click(Sender: TObject);
    procedure FindLanguages;
    procedure CBSpracheChange(Sender: TObject);
    procedure PauseExecute(Sender: TObject);
    procedure PlayExecute(Sender: TObject);
    procedure StopExecute(Sender: TObject);
    procedure BFemonSVDRPClick(Sender: TObject);
    procedure B_WOLClick(Sender: TObject);
    function TestVDR:boolean;
    procedure IdIcmpClient1Reply(ASender: TComponent;
      const AReplyStatus: TReplyStatus);
    procedure BVdrConnectClick(Sender: TObject);
    procedure TBFontSizeChange(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure BVTPSendClick(Sender: TObject);
    procedure SBChannelSearchClick(Sender: TObject);
    function TestVdr1:Boolean;
    procedure Button6Click(Sender: TObject);
    procedure ETextChange(Sender: TObject);
    procedure EPasswordChange(Sender: TObject);
    procedure CBNetDisconnectClick(Sender: TObject);
    procedure SGVDRClick(Sender: TObject);
    procedure SBSgVdrDeleteClick(Sender: TObject);
    procedure SBSgVdrNewClick(Sender: TObject);
    procedure BVdrConnect2Click(Sender: TObject);
    procedure SBVDRCheckClick(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure ScanVideo(Path:string);
    procedure SGTimerMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TimerEPG;
    procedure SGTimerClick(Sender: TObject);
  private
    { Private-Deklarationen }
    aDVB:array of TDVB;
    function SVDRPSend(Cmd:String):boolean;   overload;
    function SVDRPSend(Cmd:String;Quitmode:TSVDRPMode):boolean; overload;
    function VTPSend(Cmd:String;Quitmode:TSVDRPMode):boolean; overload;
    procedure InitRemote(SGRemote:TStringGrid);

  public
    { Public-Deklarationen }
    Records:TStringList;
    RecordsPath:TStringList;
    SVDRPList:TStringList;
    Locale:TStringList;
    SGEpg:TStringGrid;
    VDRExists:boolean;
    FontHeight:integer;
    InitDone:Boolean;
    EpgKanalWidth,EpgDauerWidth : integer;
  end;

const

  // Define the Separator  fr SortStringGrid
  TheSeparator = '@';
  H_EPG_Kanal = 16;
  H_EPG_Zeit = 16;
  H_EPG_Titel = 22;
  H_EPG_Text = 15;
  L_Form2Caption=0;
  L_ConnectError=1;
  L_RemoteError=2;
  L_OSDInfo=3;
  LOC_Nr=4;
  LOC_JetztLaeuft=5;
  LOC_Name=6;
  LOC_Gruppe=7;
  LOC_Freq=8;
  LOC_Datum=9;
  LOC_Dauer=10;
  LOC_Titel=11;
  LOC_SpracheFehlt=12;
  LOC_RecDelete=13;
  L_ConnectError2=14;
  L_ConnectError3=15;
  LOC_PowerOff=16;
  L_ChannelNotAvailable=17;
  LOC_DeleteVDRList=18;
  LOC_DeleteVDRListConfirm=19;
  LOC_NoEPG=20;
  LOC_NoRecDir=21;
  // LocaleStr[LOC_NoEPG]
var
  Form1: TForm1;
  FirstStart:Boolean;
  ProjektName: string;
  SortTag:integer;
  ZeitZone:integer;
  TV_Format,REC_Format:String;
  aSnapshotHandle: THandle;
  aProcessEntry32: TProcessEntry32;
  PassWordKey:String;
  LocaleStr: Array[0..25] of string = (
    'Aufnahme',
    'keine Verbindung zur Adresse tcp://',
    'Keine Fernbedienung aktiv',
    'Achtung! Benutzung des OSD ist etwas Fehleranfllig. Achten Sie darauf das OSD-Fenster immer mit <Strg-c> zu schlieen. Wenn Sie anschlieend ein leeres Fenster sehen aktivieren Sie das OSD mit der OSD-Men-Taste (blicherweise Taste <m>).',
    'Nr.',
    'Jetzt luft',
    'Name',
    'Gruppe',
    'Freq.',
    'Datum',
    'Dauer',
    'Titel',
    'keine Sprachdatei ausgewhlt',
    'Aufnahme wirklich lschen?',
    'VDR ist nicht bereit, soll der VDR ber Wake On Lan gestartet werden ?',
    'VDR ist nicht bereit, bitte einschalten oder neu starten',
    'VDR Server ausschalten ?',
    'kann nicht zu diesem Kanal umschalten, alle DVB-Karten belegt',
    'der letzte Eintrag kann nicht gelscht werden',
    'VDR-Eintrag wirklich lschen',
    'keine EPG-Daten verfgbar',
    'keine Aufnahmen im Aufnahmeverzeichniss gefunden. Bitte Einstellungen in Optionen-Streaming berprfen',
    '',
    '',
    '',
    ''
    );



function IsNum(s:string):boolean;
function IsDate(s:string):boolean;
procedure SortStringGrid(var GenStrGrid: TStringGrid; ThatCol: Integer);
function ReadVDRTimeStr(s:string; var Tag,Start,Dauer:String):integer;

implementation

{$R *.dfm}
uses pw;

function AlphaNumString(s:String):String;
const
     charset=['a'..'z','A'..'Z','0'..'9'];
var i,n:integer;
begin
   result := '';
   n := 0;
   for i := 1 to Length(s) do begin
      dec(n);
      if n > 0 then continue;
      if s[i] = '#' then
         n :=3;
      if s[i] in charset then
         result := result+s[i];
   end;
end;

function max(a,b:Integer):integer;
begin
   if a > b then
     result := a
   else
     result := b;
end;

function GetVersion:String;
var
  i:integer;
  aInternalName, aFileVersion, aDepends: ShortString;
  VersionInfoSize, VerInfoSize, GetInfoSizeJunk: DWORD;
  VersionInfo, Translation, InfoPointer: Pointer;
  VersionValue: AnsiString;
begin
  Result := '';
  VerInfoSize := GetFileVersionInfoSize(PChar(Application.ExeName), GetInfoSizeJunk);
  if VerInfoSize > 0 then
  begin
    GetMem(VersionInfo, VerInfoSize);
    try
      GetFileVersionInfo(PChar(Application.ExeName), 0, VerInfoSize, VersionInfo);
      VerQueryValue(
        VersionInfo, '\\VarFileInfo\\Translation', Translation, VerInfoSize
      );
      VersionValue :=
        '\\StringFileInfo\\' + IntToHex(LoWord(LongInt(Translation^)), 4) +
        IntToHex(HiWord(LongInt(Translation^)), 4) + '\\';
      VersionInfoSize := 0;

      VerQueryValue(
        VersionInfo, PChar(VersionValue + 'InternalName'), InfoPointer,
        VersionInfoSize
      );
      aInternalName := AnsiString(PChar(InfoPointer));

      VerQueryValue(
        VersionInfo, PChar(VersionValue + 'FileVersion'), InfoPointer,
        VersionInfoSize
      );
      aFileVersion := AnsiString(PChar(InfoPointer));

      if VerQueryValue(
        VersionInfo, PChar(VersionValue + 'Depend'), InfoPointer,
        VersionInfoSize
      ) then
        aDepends := AnsiString(PChar(InfoPointer))
      else
        aDepends := '';
    finally
      FreeMem(VersionInfo);
    end;
    aInternalName := Trim(aInternalName);
    aFileVersion := Trim(aFileVersion);
    for i := length(AFileVersion) downto 1 do begin
       if AFileVersion[i] in ['1'..'9'] then break;
         AFileVersion[i] := ' ';
    end;
    Result := AFileVersion;
  end;
end;

procedure SGInit(SG:TStringGrid;Height:integer;Widths:array of integer);
var i:Integer;
begin
   SG.DefaultRowHeight := Height;
   for i := 0 to High(Widths) do
      SG.ColWidths[i] := Widths[i];
end;


function FindProc(FileNamePath:String):boolean;
var
  bContinue: BOOL;
  FileName,Name,Id,User:String;
begin
  Result := True;
  if Trim(FileNamePath) = '' then exit;
  FileName := UpperCase(ExtractFileName(FileNamePath));
  aSnapshotHandle := CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
  aProcessEntry32.dwSize := SizeOf(aProcessEntry32);
  bContinue := Process32First(aSnapshotHandle, aProcessEntry32);
  while Integer(bContinue) <> 0 do
  begin
    Name := UpperCase(ExtractFileName(aProcessEntry32.szExeFile));
    if Name = FileName then exit;
    Id := IntToHex(aProcessEntry32.th32ProcessID, 4);
    User := IntToHex(aProcessEntry32.th32ParentProcessID,4);
    bContinue := Process32Next(aSnapshotHandle, aProcessEntry32);
  end;
  CloseHandle(aSnapshotHandle);
  Result := False;
end;

Function FileSize(FileName : String) : Int64;
var
  SearchRec : TSearchRec;
begin
  if FindFirst(FileName, faAnyFile, SearchRec ) = 0 then                  // if found
     Result := Int64(SearchRec.FindData.nFileSizeHigh) shl Int64(32) +    // calculate the size
               Int64(SearchREc.FindData.nFileSizeLow)
  else
     Result := 0;
  FindClose(SearchRec);                                                   // close the find
end;

Function FindFile(FileName : String):String;
var
  SearchRec : TSearchRec;
begin
  if FindFirst(FileName, faAnyFile, SearchRec ) = 0 then                  // if found
     Result := SearchRec.Name
  else
     Result := '';
  FindClose(SearchRec);                                                   // close the find
end;

function GetTimeZone:integer;
var
   tz_info:TTimeZoneInformation;
begin
  case GetTimeZoneInformation(tz_info) of //Sommerzeit - Winterzeit
    1: result := (tz_info.StandardBias + tz_info.Bias)*(-60);
    2: result := (tz_info.DaylightBias + tz_info.Bias)*(-60);
  else
    result := 0;
  end;
end;

function IsNum(s:string):boolean;
var
   i:integer;

begin
   s := Trim(s);
   Result := (s <>'');
   for i := 1 to length(s) do
      if not (s[i] in ['0'..'9']) then begin
         result := False;
         exit;
      end;
end;

function IsDate(s:string):boolean;
begin
   result := true;
   try
      StrToDate(s);
   except
      result := False;
   end;
end;

function nPos(s,text:string;n:integer):integer;
var i,p:integer;
begin
   p := 0;
   result := 0;
   for i := 1 to n do begin
      p := pos(s,text);
      if p = 0 then exit;
      text[p] := '';
   end;
   result := p;
end;

function CompareUp(List: TStringList; Index1, Index2: Integer): Integer;
var s1,s2:String;
    p,p1:integer;
    done:Boolean;
begin
   result := 0;
   done := False;
   p := pos(TheSeparator,List[Index1]);
   s1 := LeftStr(List[Index1],p-1);
   p := pos(TheSeparator,List[Index2]);
   s2 := LeftStr(List[Index2],p-1);
   if ( pos('min.',s1) > 0 ) and ( pos('min.',s2) > 0 ) then begin
      s1 := LeftStr(s1,pos('min.',s1)-1);
      s2 := LeftStr(s2,pos('min.',s2)-1);
   end;
   if IsNum(s1) and IsNum(s2) then begin
     result := StrToInt(s1)-StrToInt(s2);
     done := True;
   end;
   if not done and IsDate(s1) and IsDate(s2) then begin
     if StrToDate(s1) > StrToDate(s2) then result := 1;
     if StrToDate(s1) < StrToDate(s2) then result := -1;
     done := True;
   end;
   if not done then
      result := AnsiCompareStr(s1,s2);
   if result = 0 then begin
      p := pos(TheSeparator,List[Index1]);
      p1 := pos(#13#10,List[Index1]);
      s1 := copy(List[Index1],p+1,p1-p-1);
      p := pos(TheSeparator,List[Index2]);
      p1 := pos(#13#10,List[Index2]);
      s2 := copy(List[Index2],p+1,p1-p-1);
      if IsNum(s1) and IsNum(s2) then
         result := StrToInt(s1)-StrToInt(s2)
      else
         result := AnsiCompareStr(s1,s2);
   end;
end;

function CompareDown(List: TStringList; Index1, Index2: Integer): Integer;
var s1,s2:String;
    p,p1:integer;
    done:Boolean;
begin
   result := 0;
   done := False;
   p := pos(TheSeparator,List[Index1]);
   s1 := LeftStr(List[Index1],p-1);
   p := pos(TheSeparator,List[Index2]);
   s2 := LeftStr(List[Index2],p-1);
   if ( pos('min.',s1) > 0 ) and ( pos('min.',s2) > 0 ) then begin
      s1 := LeftStr(s1,pos('min.',s1)-1);
      s2 := LeftStr(s2,pos('min.',s2)-1);
   end;
   if IsNum(s1) and IsNum(s2) then begin
     result := StrToInt(s2)-StrToInt(s1);
     done := True;
   end;
   if IsDate(s1) and IsDate(s2) then begin
     if StrToDate(s2) > StrToDate(s1) then result := 1;
     if StrToDate(s2) < StrToDate(s1) then result := -1;
     done := True;
   end;
   if not done then
     result := AnsiCompareStr(s2,s1);
   if result = 0 then begin
      p := pos(TheSeparator,List[Index1]);
      p1 := pos(#13#10,List[Index1]);
      s1 := copy(List[Index1],p+1,p1-p-1);
      p := pos(TheSeparator,List[Index2]);
      p1 := pos(#13#10,List[Index2]);
      s2 := copy(List[Index2],p+1,p1-p-1);
      if IsNum(s1) and IsNum(s2) then
        result := StrToInt(s2)-StrToInt(s1)
      else
         result := AnsiCompareStr(s2,s1);
   end;
end;


procedure SortStringGrid(var GenStrGrid: TStringGrid; ThatCol: Integer);
var
  CountItem, I, J, K, ThePosition: integer;
  MyList: TStringList;
  MyString, TempString, SortStr: string;
  isTVRadio : boolean;
begin
  // Give the number of rows in the StringGrid
  CountItem := GenStrGrid.RowCount;
  //Create the List
  isTVRadio := False;
  MyList := TStringList.Create;
  MyList.Sorted := False;
  try
    begin
      for I := 1 to (CountItem - 1) do begin
        SortStr := GenStrGrid.Rows[I].Strings[ThatCol];
        if SortStr = 'TV' then begin
           if SortTag = 1 then SortStr := '1' else SortStr := '2';
           isTVRadio := True;
        end;
        if SortStr = 'Radio' then begin
           if SortTag = 1 then SortStr := '2' else SortStr := '1';
           isTVRadio := True;
        end;
        MyList.Add(SortStr + TheSeparator + GenStrGrid.Rows[I].Text);
       end;
      //Sort the List
      //Mylist.Sort;
      if SortTag = 0 then begin
         MyList.CustomSort(CompareUp);
         SortTag := 1;
       end else begin
         if isTVRadio then
            MyList.CustomSort(CompareUP)
          else
            MyList.CustomSort(CompareDown);
         SortTag := 0;
      end;

      for K := 1 to Mylist.Count do
      begin
        //Take the String of the line (K  1)
        MyString := MyList.Strings[(K - 1)];
        //Find the position of the Separator in the String
        ThePosition := Pos(TheSeparator, MyString);
        TempString  := '';
        {Eliminate the Text of the column on which we have sorted the StringGrid}
        TempString := Copy(MyString, (ThePosition + 1), Length(MyString));
        MyList.Strings[(K - 1)] := '';
        MyList.Strings[(K - 1)] := TempString;
      end;

      // Refill the StringGrid
      for J := 1 to (CountItem - 1) do
        GenStrGrid.Rows[J].Text := MyList.Strings[(J - 1)];
    end;
  finally
    //Free the List
    MyList.Free;
  end;
end;


function ReadVDRTimeStr(s:string; var Tag,Start,Dauer:String):integer;
var p1,p2,p3:Integer;
    StartZeit:TDateTime;
    Vorbei:LongInt;
    Anfang,Laenge:LongInt;
begin
    p1 := npos(' ',s,2);
    p2 := npos(' ',s,3);
    p3 := npos(' ',s,4);
    Anfang := StrToInt(copy(s,p1+1,p2-p1-1))+ZeitZone;
    Laenge := StrToInt(copy(s,p2+1,p3-p2-1));
    StartZeit := IncSecond(EncodeDateTime(1970,1,1,0,0,0,0),Anfang);
    Vorbei := SecondsBetween(now,StartZeit);
    if Vorbei < 0 then Vorbei := 0;
    DateTimeToString(Start,'hh:nn',StartZeit);
    DateTimeToString(Tag,'dd.mm.yyyy',StartZeit);
    Tag := Wochentage[DayOfTheWeek(StartZeit)]+' '+Tag;
    Dauer := IntToStr(Laenge div 60);
    if Laenge > 0 then
       result := (Vorbei * 100) div Laenge
     else
       result := 0;
end;

procedure TForm1.SmbConnect(Ein:boolean);
var LW,Ip,RecDir,User,Passwd,s:string;
    Disconnect:Boolean;
begin
  if not VDRExists then exit;
  LW := ELaufwerk.Text;
  IP := EIpAdr.Text;
  RecDir := ERecDir.Text;
  PassWd := EPassWord.Text;
  User := EUser.Text;
  DisConnect := CBNetDisConnect.Checked;
  if not (Ein or DisConnect) then exit;
  if Ein then
     s := 'use '+LW+' \\'+Ip+'\'+RecDir+' '+Passwd+' /user:'+User+' /PERSISTENT:NO /Y'
   else
     s := 'use '+LW+' /DELETE';
  ShellExecute(Application.Handle, 'open', pchar('net'), pchar(s),  nil, SW_NORMAL);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   Memo2.Lines.SaveToFile(ProjektName+'.txt');
end;

procedure TForm1.FindLanguages;
var
  SearchRec : TSearchRec;
  FileName:String;
begin
  CBSprache.Items.Clear;
  if FindFirst('EasyStream.lang.*', faAnyFile, SearchRec ) = 0 then    // if found
     repeat
        FileName := UpperCase(SearchRec.Name);
        if pos('.EXE',FileName)+pos('.CSI',FileName) = 0 then
           CBSprache.Items.Add(SearchRec.Name);
     until FindNext(SearchRec) <> 0;
  FindClose(SearchRec);                                       // close the find
end;

function IntFromString(s,trenn:String):integer;
// z.B. "Wert=225" oder "Tage:25" 
var
  p:integer;
begin
  result := -1;
  if s[1] <> '2' then exit;
  p := pos(trenn,s);
  if p > 0 then
     result := StrToInt(copy(s,p+1,Length(s)));
end;

procedure TForm1.GetDvbStatus;
var
  n,i:integer;
  s:String;
begin
   if not VDRExists then exit;
   svdrpsend('PLUG vdrinfo DEVICES');
   s := SVDRPList[0];
   if s[1] = '2' then  begin
      n := IntFromString(s,'=');
      if Length(aDvb) < n then
         SetLength(aDvb,n);
      SBVDRCheck.Visible := True;
      for i := 0 to n-1 do begin
         if not assigned(aDVB[i]) then begin
            aDVB[i] := TDVB.Create(self);
            aDVB[i].Parent := Panel4;
            aDVB[i].Init(128,i,imgDVB,ImgRed,ImgGreen);
         end;
         aDVB[i].Visible:= True;
         svdrpsend('PLUG vdrinfo DEVSTATUS '+IntToStr(i));
         s := SVDRPList[0];
         aDVB[i].Use( not (pos('Used=0',s) > 0) );
         aDVB[i].Rec( not (pos('Rec=0',s) > 0) );
      end;
      svdrpsend('PLUG vdrinfo PRIMDEV ');
      n := IntFromString(SVDRPList[0],'=')-1;
      if not (n = -2) then begin
         aDVB[n].Color := clBtnShadow;
         aDVB[n].Hint := 'Primres DVB-Interface-'+IntToStr(n);
      end;   
   end else begin
      for i := 0 to High(aDVB) do
         aDVB[i].Visible := False;
      SBVDRCheck.Visible := False;
   end;

end;

procedure TForm1.GetFreeSpace;
var
  s:String;
  i,gb,gesamt:integer;
begin
   if not VDRExists then exit;
   PBDiskFree.Visible := False;
   LDiskFree.Visible := False;
   if svdrpsend('STAT DISK') then  begin
      s := SVDRPList.Strings[0];
      i := pos('MB',s);
      gesamt :=  StrToInt(copy(s,5,i-5)) div 1024;
      s := copy(s,i+3,Length(s));
      i := pos('MB',s);
      gb :=  StrToInt(LeftStr(s,i-1)) div 1024;
      PBDiskFree.Brush.Color  := clBtnShadow;
      PBDiskFree.Height := 20;
      PBDiskFree.Max := gesamt;
      PBDiskFree.Position := gesamt-gb;
      LDiskFree.Parent := PBDiskFree;
      LDiskFree.Left := 43;
      LDiskFree.Align := alClient;
      LDiskFree.Alignment := taCenter;
      LDiskFree.Top := 1;
      LDiskFree.Caption := IntToStr(round(gb/1.82))+' h';
      PBDiskFree.Visible := True;
      LDiskFree.Visible := True;
    end;
end;

procedure TForm1.EasyStreamInit;
begin
   // Wake On Lan
   if not InitDone then exit;
   SGInit(SGProgramm,FontHeight*2+10,[SGProgramm.ColWidths[0],FontHeight*2+10]);
   SGInit(SGRecord,FontHeight+10,[]);
   SGInit(SGTimer,FontHeight+10,[]);
   SGInit(SGEPG,FontHeight+10,[]);
   SaveStdIcon;
   PConnecting.Visible := True;
   VDRExists := False;
   TestVDR1;
   if not VDRExists then begin
      if CB_WOL.Checked then begin
         if Application.MessageBox(PChar(LocaleStr[L_ConnectError2]),PChar('VDR Streaming-Server'),MB_YESNO) = IDYES then
            B_WOLClick(nil);
       end else
         Application.MessageBox(PChar(LocaleStr[L_ConnectError3]),PChar('VDR Streaming-Server'),MB_OK);
   end;
   BVdrConnect.Visible := not VDRExists;
   FindLanguages;
   Button7Click(Self);
   LoadChannel(PrgTV);
   if FindProc(ERemote.Text) then
      cs.Active := true;
   GetFreeSpace;
   GetDVBStatus;
   SmbConnect(True);
   PageControl1.ActivePage := TSKanaele;
   TForm1Visible.Enabled := True;
   PConnecting.Visible := False;
end;

procedure TForm1.ReadVdrList(ini:TIniFile);
var i:integer;
    VdrStr,VdrNr:String;
begin
    i := 1;
    repeat
       VdrStr := Ini.ReadString('VDRLIST','VDR'+IntToStr(i),'');
       inc(i);
       if VdrStr <> '' then begin
          SGVdr.RowCount := i;
          SGVdr.Rows[i-1].Text := AnsiReplaceStr(VdrStr,';',#13#10);
       end;
    until VdrStr = '';
    if i = 2 then begin // da war nichts : Alte Methode
       SGVdr.RowCount := 2;
       EIpAdr.Text := Ini.ReadString('CONFIG','VDRIP','easyvdr');
       ESvdrp.Text := Ini.ReadString('CONFIG','SVDRP-PORT','2001');
       EPort.Text := Ini.ReadString('CONFIG','STREAMPORT','3000');
       EVTP.Text := Ini.ReadString('CONFIG','VTP-PORT','2004');
       ELaufwerk.Text:= Ini.ReadString('CONFIG','LAUFWERK','V:');
       ERecDir.Text:= Ini.ReadString('CONFIG','RECDIR','video0');
       EUser.Text:= Ini.ReadString('CONFIG','USER','root');
       EPassword.Text := Ini.ReadString('CONFIG','PASSWORD','easyvdr');
       CBNetDisConnect.Checked := Ini.ReadBool('CONFIG','USE_DISCONNECT',false);
       VdrStr := 'VDR-1;'+EIPAdr.Text+';'+ESvdrp.Text+';'+EPort.Text+';'+EVtp.Text+';'
             +ELaufwerk.Text+';'+ERecDir.Text+';'+EUser.Text+';'+EPassword.Text+';';
       if CBNetDisConnect.Checked then
          VdrStr := VdrStr+'JA'
        else
          VdrStr := VdrStr+'NEIN';
       SGVdr.Rows[1].Text := AnsiReplaceStr(VdrStr,';',#13#10);

       EIpAdr.Text := Ini.ReadString('CONFIG','VDRIP2','');
       ESvdrp.Text := Ini.ReadString('CONFIG','SVDRP-PORT2','2001');
       EPort.Text := Ini.ReadString('CONFIG','STREAMPORT2','3000');
       EVTP.Text := Ini.ReadString('CONFIG','VTP-PORT2','2004');
       ELaufwerk.Text:= Ini.ReadString('CONFIG','LAUFWERK2','V:');
       ERecDir.Text:= Ini.ReadString('CONFIG','RECDIR2','video0');
       EUser.Text:= Ini.ReadString('CONFIG','USER2','root');
       EPassword.Text := Ini.ReadString('CONFIG','PASSWORD2','easyvdr');
       CBNetDisConnect.Checked := Ini.ReadBool('CONFIG','USE_DISCONNECT2',false);
       VdrStr := 'VDR-2;'+EIPAdr.Text+';'+ESvdrp.Text+';'+EPort.Text+';'+EVtp.Text+';'
             +ELaufwerk.Text+';'+ERecDir.Text+';'+EUser.Text+';'+EPassword.Text+';';
       if CBNetDisConnect.Checked then
          VdrStr := VdrStr+'JA'
        else
          VdrStr := VdrStr+'NEIN';
       if EIpAdr.Text <> '' then begin
          SGVdr.RowCount := 3;
          SGVdr.Rows[2].Text := AnsiReplaceStr(VdrStr,';',#13#10);
       end;
    end;
    SGVdr.FixedRows := 1;
    VDRNr := Ini.ReadString('CONFIG','VDRNr','VDR-1');
    for i := 1 to SGVdr.RowCount-1 do
       if SGVdr.Cells[0,i] = VDRNr then
          if SGVdr.Row = i then
             SGVdrClick(nil)
           else
             SGVdr.Row := i;
end;

procedure TForm1.SaveVdrList(ini:TIniFile);
var i:integer;
    VdrStr:String;
begin
   for i := 1 to SGVdr.RowCount-1 do begin
      VdrStr:= SGVdr.Rows[i].Text;
      ini.WriteString('VDRLIST','VDR'+IntToStr(i),AnsiReplaceStr(VdrStr,#13#10,';'));
   end;
   ini.WriteString('CONFIG','VDRNR',SGVdr.Cells[0,SGVdr.Row]);
end;

procedure TForm1.FormCreate(Sender: TObject);
var ini:TIniFile;
    i:integer;
    VLC_Deinterlace,FileName,OldFileName:String;
begin
    FirstStart := True;
    Records := TStringList.Create;
    RecordsPath := TStringList.Create;
    InitDone := False;
    SGEpg := SGEpgNow;
    Memo3.Text := GPL;
    MHelp.Text := Description;
    ProjektName := ExtractFilePath(Application.ExeName)+'EasyStream';
    FileName := ProjektName+'.csi';
    if not FileExists(FileName) then begin
       OldFileName := FindFile('easystream*.csi');
       if OldFileName <> '' then begin
          OldFileName :=ExtractFilePath(FileName)+OldFileName;
          RenameFile(OldFileName, FileName);
       end;
    end;
    Form1.Caption := 'EasyStream - '+GetVersion;
    ZeitZone := GetTimeZone;
    SortTag := 0;
    SVDRPList := TStringList.Create;
    ini := TIniFile.Create(ProjektName+'.csi');

    ReadVDRList(ini);

    ENumTV.Text:= Ini.ReadString('CONFIG','NUMTV','100');
    ENumRadio.Text:= Ini.ReadString('CONFIG','NUMRADIO','50');
    ERecVor.Text:= Ini.ReadString('CONFIG','REC_VOR','5');
    ERecNach.Text:= Ini.ReadString('CONFIG','REC_NACH','10');
    EEPGIntervall.Text:= Ini.ReadString('CONFIG','EPGINTERVALL','5');
    TBFontSize.Position := Ini.ReadInteger('CONFIG','FONTSIZE',12);
    FontHeight := TBFontSize.Position;
    CBResizeVideo.Checked := Ini.ReadBool('CONFIG','USE_RESIZETV',true);

    ETelnet.Text:= Ini.ReadString('CONFIG','TELNET','telnet');
    ETelnetParameter.Text:= Ini.ReadString('CONFIG','TELNETPARAMETER','easyvdr 2002');

    CBSprache.Text:= Ini.ReadString('CONFIG','SPRACHE','default');

    CBVlc.Checked := Ini.ReadBool('CONFIG','USE_VLC_EXTERN',false);
    Edit2.Text:= Ini.ReadString('CONFIG','PLAYER','C:\Programme\VideoLan\vlc\vlc.exe');
    VLC_Deinterlace := Ini.ReadString('CONFIG','VLCDEINTERLACE','bob');
    CBDeInterlace.ItemIndex := CBDeInterlace.Items.IndexOf(VLC_DeInterlace);
    EPlayList.Text:= Ini.ReadString('CONFIG','PLAYLIST','vcl_playlist.m3u');
    EVlcOptions.Text:= AnsiReplaceStr(Ini.ReadString('CONFIG','VLCOPTIONS',':deinterlace=bob'),'&&','=');

    ERemote.Text:= Ini.ReadString('CONFIG','REMOTE','C:\WinLirc\WinLirc.exe');
    InitRemote(SGRemote);
    for i := 1 to SGRemote.RowCount-1 do
       SGRemote.Cells[1,i] := Ini.ReadString('REMOTE',SGRemote.Cells[0,i],'');
    if not ReadSGCols(ini,SGProgramm,'PROGRAMM') then
       SGInit(SGProgramm,FontHeight*2+10,[35,FontHeight*2+10,150,200,100,100,0,0]);
    if not ReadSGCols(ini,SGRecord,'RECORD')then
       SGInit(SGRecord,FontHeight+10,[35,60,65,500]);
    if not ReadSGCols(ini,SGTimer,'TIMER')then
       SGInit(SGTimer,FontHeight+10,[35,30,30]);
    if not ReadSGCols(ini,SGEPG,'EPG')then
       SGInit(SGEPG,FontHeight+10,[50,50,150,200,400]);
    EpgKanalWidth := SGEpg.ColWidths[EPG_KANAL];
    EpgDauerWidth := SGEpg.ColWidths[EPG_DAUER];
    Ini.Free;
    if not FindProc(ERemote.Text) then
       ShellExecute(Application.Handle, 'open', PChar(ERemote.Text), PChar(''), nil, SW_NORMAL);
    PageControl1.ActivePage := TSOptionen;
    PageControl2.ActivePage := TSOAbout;
end;

function TForm1.ReadSGCols(ini:TIniFile;SG:TStringGrid;Name:String):boolean;
var p,i,count:integer;
    List:TStringList;
    s:string;
begin
   List := TStringList.Create;
   ini.ReadSectionValues(Name,List);
   result := True;
   if List.Count > 0 then begin
      if List.Count > SG.ColCount then
         Count := SG.ColCount-1
       else
         Count := List.Count-1;
      for i := 0 to Count do begin
         s := List[i];
         p := pos('=',s);
         s := copy(s,p+1,Length(s));
         SG.Colwidths[i] := StrToInt(s);
      end;
    end else begin
      result := False;
   end;
   List.Free;
end;

procedure TForm1.SaveSGCols(ini:TIniFile;SG:TStringGrid;Name:String);
var i,w:integer;
begin
   for i := 0 to SG.ColCount-1 do begin
      w := SG.Colwidths[i];
      if Name = 'EPG' then begin
         if i = EPG_KANAL then
            w := EpgKanalWidth;
         if i = EPG_DAUER then
            w := EpgDauerWidth;
      end;
      Ini.WriteInteger(Name,'C'+IntToStr(i),w);
   end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var ini:TIniFile;
    i:Integer;
begin
    SMBConnect(False);
    ini := TIniFile.Create(ProjektName+'.csi');
    ini.EraseSection('CONFIG');
    ini.EraseSection('REMOTE');
    ini.EraseSection('VDRLIST');
    SaveVdrList(ini);

    ini.WriteString('CONFIG','NUMTV',ENumTV.Text);
    ini.WriteString('CONFIG','NUMRADIO',ENumRadio.Text);
    ini.WriteString('CONFIG','REC_VOR',ERecVor.Text);
    ini.WriteString('CONFIG','REC_NACH',ERecNach.Text);
    ini.WriteString('CONFIG','EPGINTERVALL',EEPGIntervall.Text);
    Ini.WriteInteger('CONFIG','FONTSIZE',TBFontSize.Position);
    Ini.WriteBool('CONFIG','USE_RESIZETV',CBResizeVideo.Checked);

    ini.WriteString('CONFIG','TELNET',ETelnet.Text);
    ini.WriteString('CONFIG','TELNETPARAMETER',ETelnetParameter.Text);

    ini.WriteString('CONFIG','SPRACHE',CBSprache.Text);

    Ini.WriteBool('CONFIG','USE_VLC_EXTERN',CBVLC.Checked);
    ini.WriteString('CONFIG','PLAYER',Edit2.Text);
    ini.WriteString('CONFIG','VLCDEINTERLACE',CBDeInterlace.Text);
    ini.WriteString('CONFIG','PLAYLIST',EPlayList.Text);

    ini.WriteString('CONFIG','REMOTE',ERemote.Text);

    for i := 0 to SGRemote.RowCount-1 do begin
        ini.WriteString('REMOTE',SGRemote.Cells[0,i],SGRemote.Cells[1,i]);
    end;
    // Spaltenbreiten speichern
    SaveSGCols(ini,SGProgramm,'PROGRAMM');
    SaveSGCols(ini,SGRecord,'RECORD');
    SaveSGCols(ini,SGTimer,'TIMER');
    SaveSGCols(ini,SGEPG,'EPG');

    ini.Free;
    Records.Free;
    RecordsPath.Free;
    SVDRPList.Free;
end;

procedure TForm1.OpenProgram(prog, params: string);
var
  c, p: array[0..800] of Char;
begin
  StrPCopy(c, prog);
  if pos('VLC',UpperCase(prog)) > 0 then
     StrPCopy(p, '--deinterlace-mode='+CBDeInterlace.Text+' --extraintf=http '+params)
  else
     StrPCopy(p, params);
  ShellExecute(Application.Handle, 'open', c, p, nil, SW_NORMAL);
end;

function TForm1.SVDRPSend(Cmd:String):boolean;
begin
   Result := SVDRPSend(Cmd,SVDRP_Quit);
end;

function TForm1.SVDRPSend(Cmd:String;Quitmode:TSVDRPMode):boolean;
var
  n:integer;
  s:string;
  ReturnCode:Integer;
begin
  result := false;
  if not VDRExists then exit;
  SVDRPList.Clear;
  result := True;
   with IdTCPClient1 do begin
      Host := EIpAdr.Text;
      Port := StrToInt(ESvdrp.Text);
      if Tag = 0 then
         try
            Connect;
         except
            Application.MessageBox(PChar(LocaleStr[L_ConnectError]+Host+':'+IntToStr(Port)),'VDR Streaming-Server');
            Result := False;
            exit;
         end;
      WriteLn(Cmd);
      s := ReadLn(#10,2000);
      while length(s) > 0 do begin
         s := ReadLn(#10,1000);
         n := Length(s);
         if n > 0 then begin
            ReturnCode := StrToInt(LeftStr(s,3));
            if ( ReturnCode > 499 ) and ( ReturnCode <> 550 ) then
               result := false;
            if s[n] = #$D then s := LeftStr(s,n-1);
            SVDRPList.Add(s);
         end;
      end;
      if QuitMode = SVDRP_Quit then begin
         WriteLn('QUIT');
         s := ReadLnWait;
         DisConnect;
      end;
   end;
   Memo2.Lines.Text := SVDRPList.Text;
end;

function TForm1.VTPSend(Cmd:String;Quitmode:TSVDRPMode):boolean;
var
  n,i:integer;
  s:string;
  ReturnCode:Integer;
  List:TStringList;
begin
  result := false;
  if not VDRExists then exit;
  SVDRPList.Clear;
  result := True;
   with IdTCPClient1 do begin
      Host := EIpAdr.Text;
      Port := StrToInt(EVTP.Text);
      if Tag = 0 then
         try
            Connect;
         except
            Application.MessageBox(PChar(LocaleStr[L_ConnectError]+Host+':'+IntToStr(Port)),'VDR Streaming-Server');
            Result := False;
            exit;
         end;
      List := TStringList.Create;
      List.Text := Cmd;
      s := ReadLnWait;
      SVDRPList.Add(s);
      for i := 0 to List.Count-1 do begin
         WriteLn(List[i]);
         s := ReadLnWait;
         SVDRPList.Add(s);
      end;
      while length(s) > 0 do begin
         s := ReadLn(#10,100);
         n := Length(s);
         if n > 0 then begin
            ReturnCode := StrToInt(LeftStr(s,3));
            if ( ReturnCode > 499 ) and ( ReturnCode <> 550 ) then
               result := false;
            if s[n] = #$D then s := LeftStr(s,n-1);
            SVDRPList.Add(s);
         end;
      end;
      if QuitMode = SVDRP_Quit then begin
         WriteLn('QUIT');
         s := ReadLnWait;
         SVDRPList.Add(s);
         DisConnect;
      end;
      List.Free;
   end;
   Memo2.Lines.Text := SVDRPList.Text;
end;

procedure TForm1.IdIcmpClient1Reply(ASender: TComponent;
  const AReplyStatus: TReplyStatus);
begin
  // Ping war erfolgreich !!
  VDRExists := True;
end;

function TForm1.TestVdr1:boolean;
var Host:String;
begin
   result := false;
   Host := EIpAdr.Text;
   Application.ProcessMessages;
   If Ping(Host) then
       result := True;
   VDRExists := result;    
end;

function TForm1.TestVDR:boolean;
begin
  // Ping an VDR senden
  result := True;
   with IdIcmpClient1 do begin
      Host := EIpAdr.Text;
      try
         IdIcmpClient1.Ping;
         Application.ProcessMessages;
       except
         // keine Antwort kam zurck
         result := false;
      end;
   end;
end;

procedure TForm1.BFemonSVDRPClick(Sender: TObject);
var
  i,n:integer;
  s:string;
const Cmd: Array[0..10] of string = (
   'PLUG femon OPEN','PLUG femon INFO','PLUG femon NAME','PLUG femon STAT','PLUG femon QUIT','','','','','','');
begin
  SVDRPList.Clear;
   with IdTCPClient1 do begin
      Host := EIpAdr.Text;
      Port := StrToInt(ESvdrp.Text);
      if Tag = 0 then
         try
            Connect;
         except
            Application.MessageBox(PChar(LocaleStr[L_ConnectError]+Host+':'+IntToStr(Port)+' ist nicht mglich !'),'VDR Streaming-Server');
            exit;
         end;
   for i := 0 to High(Cmd) do begin
      if cmd[i] = '' then break;
      WriteLn(Cmd[i]);
      s := ReadLnWait;
      while length(s) > 0 do begin
         s := ReadLn(#10,100);
         n := Length(s);
         if n > 0 then begin
            if s[n] = #$D then s := LeftStr(s,n-1);
            SVDRPList.Add(s);
         end;
      end;
   end;
      WriteLn('QUIT');
      s := ReadLnWait;
      DisConnect;
   end;
   Memo2.Lines.Text := SVDRPList.Text;
end;


procedure TForm1.SVDRPClick(Sender: TObject);
begin
   SVDRPSend(Edit6.Text);
end;


procedure TForm1.Button2Click(Sender: TObject);
begin
   SVDRPSend('LSTC');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   SVDRPSend('LSTE now');
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
   SVDRPSend('LSTR');
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
   SVDRPSend('LSTT');
end;

procedure TForm1.SGProgrammDoppelKlick(ARow:longint);
var Stream,Kanal:String;
    VTPResult:String;
begin
   Form2.VlcPlugDestroy;
   Kanal := SGProgramm.Cells[CH_Nr,ARow];
   SBChannelSearch.Down := False;
   SBChannelSearchClick(nil);
   if not CBVdrSwitch.Checked then begin
      VTPSend('PROV 50 '+Kanal,SVDRP_QUIT);
      VTPResult := SVDRPList.Text;
      if pos('Channel available',VTPResult) = 0 then begin
         Application.MessageBox(PChar(LocaleStr[L_ChannelNotAvailable]),PChar('VDR Streaming-Server'),MB_OK);
         exit;
      end;
   end;   
   if CBVDRSwitch.Checked then begin
      SVDRPSend('CHAN '+Kanal,SVDRP_NoQuit);
      sleep(1000);
   end;
   if CBVlc.Checked then begin
      OpenProgram(Edit2.Text,SGProgramm.Cells[CH_Quelle,ARow]);
      exit;
   end;

   Form2.VlcPlugCreate;
   if CBResizeVideo.Checked or FirstStart then begin
      FirstStart := False;
      if pos('16:9',TV_Format) > 0 then begin
         Form2.Width := 968;
         Form2.Height := 616;
      end else begin
         Form2.Width := 728;
         Form2.Height := 652;
      end;
   end;
   Stream := SGProgramm.Cells[CH_Quelle,ARow];
   if CBUseExtern.Checked then
      Stream := AnsiReplaceStr(Stream,'PES','Extern');
   Form2.PlayVLC(Stream,':deinterlace-mode='+CBDeInterlace.Text);
   Form2.Caption := 'VLC: '+Stream+' -- '+SGProgramm.Cells[CH_Name,ARow];
end;

procedure TForm1.SGProgrammMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  ACol,ARow : LongInt;
begin
  SGProgramm.MouseToCell(X, Y,ACol,ARow);
  if ARow = 0 then
     SortStringGrid(SGProgramm,ACol)
   else
     if SGProgramm.Tag = 999 then
        SGProgrammDoppelklick(ARow)
      else begin
        SGProgramm.Tag := 999;
        TimerSGProgrammDblClick.Enabled := True;
     end;
end;

procedure TForm1.TimerSGProgrammDblClickTimer(Sender: TObject);
begin
   TimerSGProgrammDblClick.Enabled := False;
   SGProgramm.Tag := 0;
end;


procedure TForm1.SBLoadChannelClick(Sender: TObject);
begin
   SBEpgNow.Down := True;
   if SBTv.Down then
      LoadChannel(PrgTV)
    else
      LoadChannel(PrgRadio);
   ReadEpgSvdrp(0);
end;

procedure TForm1.LoadChannel(PrgTyp:TProgrammTyp);
var p,i,ii:integer;
    nTV,nRadio,nTVmax,nRadiomax:integer;
    s:String;
    typ:String;
    IPStr:String;
begin
   IPStr := 'http://'+EIpAdr.Text+':'+EPort.Text+'/PES/';
   nTVMax := StrToInt(ENumTV.Text);
   nRadioMax := StrToInt(ENumRadio.Text);
   nTV := 0;
   nRadio := 0;
   with SGProgramm do begin
     RowHeights[0] := FontHeight+6;
     Cells[CH_Nr,0] := LocaleStr[LOC_Nr];
     Cells[CH_Logo,0] := '';
     Cells[CH_Zeit,0] := '';
     Cells[CH_Titel,0] := LocaleStr[LOC_JetztLaeuft];
     Cells[CH_Name,0] := LocaleStr[LOC_Name];
     Cells[CH_Gruppe,0] := LocaleStr[LOC_Gruppe];
     Cells[CH_Frequenz,0] := LocaleStr[LOC_Freq];
   end;
   if not SVDRPSend('LSTC') then exit;
   SGProgramm.ColCount := 19;
   SGProgramm.RowCount := SVDRPList.Count;
   i := 1;
   for ii := 1 to SVDRPList.Count do begin
      s := copy(SVDRPList[ii-1],5,Length(SVDRPList[ii-1]));
      p := pos(';',s);
      if pos(':',s) < p then p := 0;
      if p > 0 then
         s[p] := ':'
       else begin
         p := pos(':',s);
         s := LeftStr(s,p-1)+':'+copy(s,p,Length(s));
      end;
      p := pos(':',s);
      s := LeftStr(s,p-1)+':'+copy(s,p,Length(s));
      p := pos(' ',s);
      s := LeftStr(s,p-1)+'::'+copy(s,p,Length(s));
      s := AnsiReplaceStr(s,':',#13#10);
      // Hier werden die Basistaten einer Zeile hinzugefgt
      SGProgramm.Rows[i].Text := s;
      s := Trim(SGProgramm.Cells[CH_Name,i]);
      p := pos(',',s);
      if p > 0 then
         s := LeftStr(s,p-1);
      SGProgramm.Cells[CH_Name,i] := s;
      with SGProgramm do begin
         typ := 'TV';
         Cells[CH_Quelle,i] := IPStr+Cells[CH_Quelle,i]+'-'+Cells[CH_NID,i]+'-'+Cells[CH_TID,i]+'-'+Cells[CH_SID,i];
         if Cells[CH_VPID,i] = '0' then typ := 'Radio';
         Cells[CH_TVRadio,i] := Typ;
         if not ((Cells[CH_VPID,i] = '0') and (Cells[CH_APID,i] = '0')) then begin
            if (Cells[CH_VPID,i] <> '0') then begin
               if (PrgTyp = PrgTV)and (nTV < nTVMax) then begin
                  inc(i);
                  inc(nTV);
               end;
            end else
               if ((PrgTyp = PrgRadio) and (Cells[CH_APID,i] <> '0') and (nRadio < nRadioMax)) then begin
                  inc(i);
                  inc(nRadio);
               end;
         end;
      end;
   end;
   SGProgramm.ColCount := 8;
   SGProgramm.RowCount := i;
   SGProgramm.Invalidate;
   ReadEpgSvdrp(SGProgramm.Row);
end;

procedure TForm1.TimerEPG;
var
   ch:string;
begin
   ch := SGTimer.Cells[3,SGTimer.Row];
   if not SVDRPSend('LSTE '+ch) then exit;
end;

procedure TForm1.ReadEpgSvdrp(ARow:Integer);

   function EpgSearchName(Name:String):integer;
    var i:integer;
        s:String;
   begin
      if pos('MDR F',name) > 0 then
         Name := Trim(Name);
      for i := 1 to SGProgramm.RowCount-1 do begin
          s := SGProgramm.Cells[CH_Name,i];
          if pos(Name,s) > 0  then begin
             result := i;
             exit;
          end;
      end;
      result := 0;
   end;

   function EpgSearchChannelId(Id:String):integer;
    var i:integer;
        s:String;
   begin
      for i := 1 to SGProgramm.RowCount-1 do begin
          s := SGProgramm.Cells[CH_Quelle,i];
          if pos(Id,s) > 0  then begin
             result := i;
             exit;
          end;
      end;
      result := 0;
   end;
var
   gelaufen,i,j,n : integer;
   ChannelId,TVName,Titel,Zeit,TextZeile:String;
   s,Start,Dauer,Tag:String;
   EpgChannel,EpgSearch:String;
   EPGAktuell:boolean;
   List:TStringList;
begin
   if ARow > 0 then
      SBEpgChannel.Caption := LeftStr(SGProgramm.Cells[CH_Name,ARow],10);
   List := TStringList.Create;
   EpgAktuell := True;

   EpgSearch := '';
   if SBEpgNow.Down then EpgSearch := 'now';
   if SBEpgNext.Down then EpgSearch := 'next';

   EpgChannel := '';
   if EpgSearch = '' then EpgChannel := SGProgramm.Cells[CH_Nr,ARow];

   SGEpg.FixedRows := 0;
   SGEpg.RowCount := 1;

   if not SVDRPSend('LSTE '+EpgChannel+' '+EpgSearch) then exit;
   if LeftStr(SVDRPList[0],3) = '550' then begin
      SGEpg.Cells[EPG_KANAL,0] := 'keine';
      SGEpg.Cells[EPG_TITEL,0] := 'EPG-Daten';
      SGEpg.Cells[EPG_ZEIT,0] := 'verfgbar';
      MEpg.Lines.Clear;
      LTVName.Caption := SBEpgChannel.Caption;
      LProgName.Caption := LocaleStr[LOC_NoEPG];
      ImgKanal.Visible := False;
      exit;
   end;

   if EpgSearch = '' then   // EPG fr einen Kanal
      SGEpg.RowCount := 1
    else begin
      // alte EPG-Daten lschen
      SGEpg.RowCount := SGProgramm.RowCount;
      for i := 1 to SGEpg.RowCount-1 do begin
         SGEpg.Cells[EPG_KANAL,i] := SGProgramm.Cells[CH_Name,i];
         for j := 1 to SGEpg.ColCount-1 do
            SGEpg.Cells[j,i] := '';
      end;
   end;
   MEpg.Tag := 0;
   n := 0;
   for i := 0 to SVDRPList.Count - 1 do begin
       s := SVDRPList[i];
       if s[4] = '-' then
          case s[5] of
             'C':       begin
                           TVName := Trim(copy(s,nPos(' ',s,2)+1,Length(s)));
                           ChannelId := Trim(copy(s,7,nPos(' ',s,2)-7));
                        end;
             'E':       begin
                           gelaufen := ReadVDRTimeStr(s,Tag,Start,Dauer);
                           if EpgSearch = '' then begin
                              inc(n);
                              SGEpg.RowCount := n+1;
                           end else
                              n := EpgSearchChannelId(ChannelId);
                              //n := EpgSearchName(TVName);
                           Zeit := Tag+': '+Start +'-'+Dauer+'min';
                           SGEpg.Cells[EPG_KANAL,n] := TVName;
                           SGEpg.Cells[EPG_ZEIT,n] := Zeit;
                           SGEpg.Cells[EPG_NR,n] := SGProgramm.Cells[CH_NR,n];
                           SGEpg.Cells[EPG_DAUER,n] := IntToStr(Gelaufen);
                        end;
             'T':       begin
                           Titel := copy(s,Pos(' ',s)+1,Length(s));
                           SGEpg.Cells[EPG_TITEL,n] := Titel;
                           if ( n > 0 ) and SBEpgNow.Down then
                              SGProgramm.Cells[CH_Titel,n] := Titel+'@@'+SGEpg.Cells[EPG_DAUER,n];
                        end;
             'D':       begin
                           TextZeile := copy(s,Pos(' ',s)+1,Length(s));
                           List.Add(TextZeile);
                        end;
             'X':       begin
                           if EpgAktuell then
                              if s[7] = '1' then
                                 TV_Format :=  copy(s,9,Length(s));
                        end;
             'e':       begin
                           if List.Count > 0 then
                              SGEpg.Cells[EPG_TEXT,n] := List.Text
                            else
                              SGEpg.Cells[EPG_TEXT,n] := '';
                           List.Clear;
                           EpgAktuell := False;
                        end;
          end;
   end;
   if SGEpg.RowCount > 0 then begin
      SGEpg.Cells[EPG_KANAL,0] := 'Kanal';
      SGEpg.Cells[EPG_DAUER,0] := '';
      SGEpg.Cells[EPG_TITEL,0] := 'Titel';
      SGEpg.Cells[EPG_ZEIT,0] := 'Zeit';
   end;
   if SGEpg.RowCount > 1 then begin
      SGEpg.FixedRows := 1;
      SGEpg.Row := 1;
   end;
   if SGEpg.RowCount > 2 then begin
      if SGEpg.Cells[EPG_KANAL,1] = SGEpg.Cells[EPG_KANAL,2] then
         SGEPG.ColWidths[EPG_KANAL] := 0
       else
         SGEPG.ColWidths[EPG_KANAL] := EpgKanalWidth;
      if not SBEpgNow.Down then
         SGEPG.ColWidths[EPG_DAUER] := 0
       else
         SGEPG.ColWidths[EPG_DAUER] := EpgDauerWidth;
   end;
   List.Free;
   SGEpgClick(self);
end;

procedure TForm1.SGProgrammSelectCell(Sender: TObject; ACol, ARow: Integer;
  var CanSelect: Boolean);
begin
  // Timer neu starten
  TProgramm.Enabled := False;
  TProgramm.Enabled := True;
end;


function IntToStr2(i:integer):string;
begin
   result := IntToStr(i);
   if Length(Result) = 1 then
      result := '0'+result;
end;

function TForm1.RecString(ZeitStr,Titel:String):String;
var RecStr,s:string;
    Minuten,p:integer;
    Zeit:TDateTime;
begin
   if SBEpgChannel.Down then
      RecStr := SGProgramm.Cells[CH_Nr,SGProgramm.Row]+':'
   else
      RecStr := SGProgramm.Cells[CH_Nr,SGEpg.Row]+':';
   p := pos('min',ZeitStr);
   Minuten := StrToInt(copy(ZeitStr,22,p-22));
   Zeit := StrToDateTime(copy(ZeitStr,4,10)+copy(ZeitStr,16,5));
   DateTimeToString(s,'yyyy-mm-dd:hhnn:',IncMinute(Zeit,-StrToInt(ERecVor.Text)));
   RecStr := RecStr+s;
   DateTimeToString(s,'hhnn:',IncMinute(Zeit,Minuten+StrToInt(ERecNach.Text)));
   RecStr := RecStr+s+'50:99:';
   result := RecStr+Titel+':';
end;

procedure TForm1.IdTCPClient1Connected(Sender: TObject);
begin
   IdTCPClient1.Tag := 99;
end;

procedure TForm1.IdTCPClient1Disconnected(Sender: TObject);
begin
   IdTCPClient1.Tag := 0;
end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
   if PageControl1.ActivePage = TSKanaele then SGEpgClick(Sender);
   if PageControl1.ActivePage = TSEPG then SGEpgClick(Sender);
   if PageControl1.ActivePage = TSRecord then begin
      if SGRecord.Visible = False then begin
            ReadRecord;
            SGRecord.Visible := True;
      end;
      SGRecordClick(Sender);
   end;
   if PageControl1.ActivePage = TSTimer then begin
      if SGTimer.Visible = False then begin
            ReadTimer;
            SGTimer.Visible := True;
      end;
   end;

end;

procedure TForm1.ReadTimer;
var i,p:integer;
    s,TimerStr:String;
    Datum:TDateTime;
    Year,Month,Day:Word;
begin
   if not SVDRPSend('LSTT') then exit;
   SGTimer.FixedRows := 0;
   SGTimer.RowCount := 1;
   SGTimer.Cells[2,0] := 'keine Timer gesetzt';
   if LeftStr(SVDRPList[0],3) = '550' then
      exit;
   SGTimer.RowCount := SVDRPList.Count+1;
   SGTimer.FixedRows := 1;
   SGTimer.Rows[0].Text := AnsiReplaceStr('Nr::Titel:CH:Tag:Start:Stop:Prio:Dauer:Titel',':',#13#10);
   for i := 0 to SVDRPList.Count-1 do begin
      TimerStr := IntToStr(i+1)+':';
      s := SVDRPList[i];
      p := Pos(':',s);
      if p = 0 then exit;
      if s[p-1] = '0' then
         TimerStr := TimerStr+'Aus'+':'
       else
         TimerStr := TimerStr+'Ein'+'::';
      TimerStr := TimerStr+copy(s,p+1,length(s)-p-1);
      SGTimer.Rows[i+1].Text := AnsiReplaceStr(TimerStr,':',#13#10);
      SGTimer.Cells[2,i+1] := SGTimer.Cells[9,i+1];
      s := SGTimer.Cells[4,i+1];
      try
         year := StrToInt(LeftStr(s,4));
         Month := StrToInt(Copy(s,6,2));
         Day := StrToInt(Copy(s,9,2));
      except
         year := 2000;
         Month := 1;
         Day := 1;
      end;
      Datum := EncodeDate(Year,Month,Day);
      SGTimer.Cells[4,i+1] := DateToStr(Datum);
   end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   ReadTimer;
   SGTimer.Visible := True;
end;

procedure TForm1.ReadRecText;
var
   i : integer;
   s,Start,Dauer,Tag:String;
   Ende:Boolean;
begin
   Panel6.Visible := False;
   Ende := False;
   if not SVDRPSend('LSTR '+SGRecord.Cells[0,SGRecord.Row]) then exit;
   MEpg.Tag := 99;
   MEpg.Lines.Clear;
   for i := 0 to SVDRPList.Count - 1 do begin
       s := SVDRPList[i];
       if s[4] = '-' then
          case s[5] of
             'T':       begin
                           MEpg.SelAttributes.Color := clRed;
                           MEpg.SelAttributes.Height := H_EPG_Titel;
                           MEpg.Lines.Add(copy(s,Pos(' ',s)+1,Length(s)));
                        end;
             'D':       begin
                           MEpg.SelAttributes.Color := clBlack;
                           MEpg.SelAttributes.Height := FontHeight;
                           MEpg.Lines.Add(copy(s,Pos(' ',s)+1,Length(s)));
                        end;
             'E':       begin
                           MEpg.SelAttributes.Color := clBlue;
                           MEpg.SelAttributes.Height := H_EPG_Zeit;
                           ReadVDRTimeStr(s,Tag,Start,Dauer);
                           MEpg.Lines.Add(Tag+': '+Start +'-'+Dauer+'min');
                        end;
             'X':       begin
                           MEpg.SelAttributes.Color := clBlue;
                           if not Ende then MEpg.Lines.Add('>');
                           Ende := True;
                           if s[7] = '1' then
                              REC_Format :=  copy(s,9,Length(s));
                        end;
          end;
   end;
end;

function TForm1.GetRecPath(Aufnahme:String;index:Integer):string;
var
   i:integer;
   Titel:String;
begin
   result := '';
   if Records.Count = 0 then exit;
   Titel := AlphaNumString(Aufnahme);
   // Falls keine (halb) gelschten Aufnahmen existieren
   // sollte index gleich auf die richtige Zeile zeigen
   for i := index to Records.Count-1 do begin
       if pos(Titel,Records[i]) > 0 then begin
          result := RecordsPath[i]+'\';
          exit;
       end;
   end;      
   // nichts gefunden also versuchen wir das abwrts
   // erwartungsgem sollte das gar nicht vorkommen
   for i := index-1 downto 0 do begin
       if pos(Titel,Records[i]) > 0 then begin
          result := RecordsPath[i]+'\';
          exit;
       end;
   end;      
end;

procedure TForm1.ReadRecord;
var i,p:integer;
    s,RecDir:String;
begin
   // Video0 Verzeichnis auslesen
   Records.Clear;
   RecordsPath.Clear;
   ScanVideo('\\'+EIpAdr.Text+'\'+ERecDir.Text);
   if not SVDRPSend('LSTR') then exit;

   if Records.Count = 0 then
      Application.MessageBox(PChar(LocaleStr[LOC_NoRecDir]),PChar('VDR Aufnahmen'),MB_OK);

   SGRecord.RowCount := SVDRPList.Count+1;
   if SGRecord.RowCount > 1 then
      SGRecord.FixedRows := 1;
   SGRecord.Cells[0,0] := LocaleStr[LOC_Nr];
   SGRecord.Cells[1,0] := LocaleStr[LOC_Datum];
   SGRecord.Cells[2,0] := LocaleStr[LOC_Dauer];
   SGRecord.Cells[3,0] := LocaleStr[LOC_Titel];
   for i := 0 to SVDRPList.Count-1 do begin
      SGRecord.Cells[0,i+1] := IntToStr(i+1);
      s := SVDRPList[i];
      p := Pos(':',s);
      if p = 0 then exit;
      SGRecord.Cells[1,i+1] := copy(s,p-11,8);
      SGRecord.Cells[2,i+1] := copy(s,p-2,5);
      s := copy(s,p+5,length(s)-p-4);
      s := AnsiReplaceStr(s,'@','');
      s := AnsiReplaceStr(s,'~','\');
      SGRecord.Cells[3,i+1] := s;
      RecDir := GetRecPath(s,i)+'index.vdr';
      if FileExists(RecDir) then
         SGRecord.Cells[2,i+1] := IntToStr(FileSize(RecDir) div 12000)+'min.'
       else
         SGRecord.Cells[2,i+1] := '---?---';
      if RecDir <> '' then
         RecDir := '' ;
   end;
   ReadRecText;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
   ReadRecord;
   SGRecord.Visible := True;
end;

procedure TForm1.SGRecordClick(Sender: TObject);
begin
  TAufnahmen.Enabled := False;
  TAufnahmen.Enabled := True;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
var
  PlayList:TStringList;
  i:integer;
begin
  PlayList := TStringList.Create;
  with PlayList do begin
     Add('#EXTM3U');
     for i := 1 to SGProgramm.RowCount-1 do begin
         Add('#EXTINF:0,'+SGProgramm.Cells[CH_Name,i]);
         Add(SGProgramm.Cells[CH_Quelle,i]);
     end;
  end;
  PlayList.SaveToFile(EPlayList.Text);
  PlayList.Free;
end;

procedure TForm1.SBRecordPlayClick(Sender: TObject);
var nRow,i:integer;
    Aufnahme,FileName,FilePath,RecDir:String;
    sr: TSearchRec;
    FileAttrs: Integer;
    List:TStringList;
    s:String;
begin
   List:=TStringList.Create;
   List.Sorted := True;
   nRow := SGRecord.Row;
   Aufnahme := SGRecord.Cells[3,nRow];
   FilePath := GetRecPath(Aufnahme,StrToInt(SGRecord.Cells[0,nRow])-1);
   if not FileExists(FilePath+'\index.vdr') then begin
      Application.MessageBox(PChar(LocaleStr[LOC_NoRecDir]),PChar('VDR Aufnahmen'),MB_OK);
      exit;
   end;
   FileAttrs := 0;
   Aufnahme := AnsiReplaceStr(Aufnahme,'\','/');
   if FindFirst(FilePath+'\*.*', FileAttrs, sr) = 0 then begin
      repeat
        if sr.Name[1] = '0' then begin
           List.Add(FilePath+sr.Name);
        end;
      until FindNext(sr) <> 0;
      FindClose(sr);
   end;
   if CBVlc.Checked then begin
      s := '"'+List[0]+'"';
      for i := 1 to List.Count-1 do
         s := s+' "'+List[i]+'"';
      OpenProgram(Edit2.Text,s);
      exit;
   end;

   Form2.VlcPlugCreate;
   if CBResizeVideo.Checked or FirstStart then
      FirstStart := False; 
      if pos('16:9',REC_Format) > 0 then begin
         Form2.Width := 968;
         Form2.Height := 616;
      end else begin
         Form2.Width := 728;
         Form2.Height := 652;
      end;
   Form2.Caption := 'VLC: '+' '+LocaleStr[L_Form2Caption]+'  -- '+ SGRecord.Cells[3,nRow];
   for i := 0 to List.Count-1 do
      Form2.AddUrl(List[i],':deinterlace-mode='+CBDeInterlace.Text,i);
   Form2.PlayList;
   List.Free;
end;


procedure TForm1.SGRecordMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  ACol,ARow : LongInt;
begin
  SGRecord.MouseToCell(X, Y,ACol,ARow);
  if ARow = 0 then
     SortStringGrid(SGRecord,ACol);
end;

procedure TForm1.SGTimerMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  ACol,ARow : LongInt;
begin
  SGTimer.MouseToCell(X, Y,ACol,ARow);
  if ARow = 0 then
     SortStringGrid(SGTimer,ACol);
end;

function GetIndex(SG:TStringGrid):string;
begin
   result := SG.Cells[0,SG.Row];
end;

procedure TForm1.SBRecDeleteClick(Sender: TObject);
begin
   if Application.MessageBox(PChar(LocaleStr[LOC_RecDelete]), 'EasyStream', MB_OKCANCEL) = IDCANCEL then
      exit;
   if not SVDRPSend('DELR '+GetIndex(SGRecord)) then exit;
   ReadRecord;
end;

function IsInteger(s:String):boolean;
var i:integer;
const charset=['0'..'9'];
begin
  result := false;
  if s = '' then exit;
  for i := 1 to length(s) do
     if not (s[i] in charset) then
        exit;
  result := true;
end;

procedure TForm1.SGDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  DrawBox:Boolean;
  LaufzeitStr,TextStr:string;
  p,Laufzeit:integer;
  nRect:TRect;
  Farbe:TColor;
  isProgramm:boolean;
  Bild:TXpm;
  s:String;
  TopBorder:Integer;
const border=3;
      IconBorder=2;
begin
  IsProgramm := (Sender as TStringGrid) = SGProgramm;
  TopBorder := 2;
  if IsProgramm then TopBorder := ( Rect.Bottom - Rect.Top ) div 4;
  with (Sender as TStringGrid) do
  begin
      DrawBox := ((Name = 'SGEpgNow') and (ACol = Epg_Dauer));
      DrawBox := DrawBox or (IsProgramm and (ACol = CH_Titel));
      Canvas.Font.Height := -FontHeight;
      if IsProgramm and (not DrawBox) and ( aRow > 0 )then Canvas.Font.Height := - round(FontHeight * 1.2);
      if FontHeight > 11 then
         Canvas.Font.Style := [fsBold]
       else
         Canvas.Font.Style := [];
      if ARow mod 2 = 0 then
        Canvas.Brush.Color := $00E1FFF9
      else
        Canvas.Brush.Color := $00FFEBDF;
      if ARow = Row then begin
         Canvas.Font.Color := clHighLightText;
         Canvas.Brush.Color := clHighLight;
      end;
      if (ARow < FixedRows) or (ACol < FixedCols) then begin
         Canvas.Font.Color := clBtnText;
         Canvas.Brush.Color := clBtnFace;
      end;

      if DrawBox and (aRow > 0 ) then begin  // and IsInteger(cells[aCol,aRow])
         LaufZeitStr := cells[aCol,aRow];
         p := pos('@@',LaufZeitStr);
         if p > 0 then begin
            TextStr := LeftStr(LaufZeitStr,p-1);
            LaufZeitStr := Copy(LaufZeitStr,p+2,Length(LaufZeitStr));
         end;
         LaufZeit := 0;
         if IsInteger(LaufZeitStr) then
            LaufZeit := StrToInt(LaufZeitStr);
         Farbe := Canvas.Brush.Color;
         Canvas.FillRect(Rect);
         if IsProgramm then begin
            SetTextAlign(Canvas.Handle,TA_LEFT);
            Canvas.TextRect(Rect, Rect.Left + 2, Rect.Top + 2, TextStr);
         end;
         nRect.Left := Rect.Left+border;
         nRect.Right := Rect.Right-border;
         nRect.Top := Rect.Top+border;
         nRect.Bottom := Rect.Bottom-border;
         if aRow = Row then
            Canvas.Brush.Color := clGray
          else
            Canvas.Brush.Color := $00a66239;
         //Canvas.Pen.Color := Canvas.Brush.Color;
         if IsProgramm then nRect.Top := nRect.Bottom + 2-(nRect.Bottom-nRect.Top) div 2;
         Canvas.FrameRect(nRect);
         nRect.Right := nRect.Left+((nRect.Right-nRect.Left)* Laufzeit) div 100;
         Canvas.FillRect(nRect);
         //Canvas.RoundRect(nRect.Left,nRect.Top,nRect.Right,nRect.Bottom,4,4);
         p := (nRect.Bottom-nRect.Top) div 4;
         nRect.Top := nRect.Top + p;
         nRect.Bottom := nRect.Bottom - p;
         if aRow = Row then
            Canvas.Brush.Color := clSilver
          else
            Canvas.Brush.Color := $00D7A181;
         Canvas.FillRect(nRect);
         Canvas.Brush.Color := Farbe;
      end else begin
         if (cells[aCol, aRow] <> 'NV') then
            if ('Dauer' = cells[aCol, 0])  then begin
               SetTextAlign(Canvas.Handle,TA_RIGHT);
               Canvas.TextRect(Rect, Rect.Right - 2, Rect.Top + TopBorder, cells[acol, arow]);
              end else begin
               SetTextAlign(Canvas.Handle,TA_LEFT);
               Canvas.TextRect(Rect, Rect.Left + 2, Rect.Top + TopBorder, cells[acol, arow]);
             end;
         end;
      Canvas.FrameRect(Rect);
      if isProgramm and (aCol = CH_LOGO) and (aRow > 0)then begin
         nRect.Left := Rect.Left+Iconborder;
         nRect.Right := Rect.Right-Iconborder;
         nRect.Top := Rect.Top+Iconborder;
         nRect.Bottom := Rect.Bottom-Iconborder;
         Bild := TXpm.Create;
         s := Cells[CH_Name,aRow];
         s := 'logos\'+s+'.xpm';
         Bild.TransparenteFarbe := Canvas.Brush.Color;
         Bild.LoadFromFile(s);
         Canvas.StretchDraw(nRect,Bild);
         Bild.Free;
         if SBChannelSearch.Down and (cells[aCol, aRow] = 'NV') then begin
            Canvas.Pen.Color := clRed;
            Canvas.Pen.Width := 3;
            Canvas.MoveTo(nRect.Left,nRect.Top);
            Canvas.LineTo(nRect.Right,nRect.Bottom);
            Canvas.MoveTo(nRect.Left,nRect.Bottom);
            Canvas.LineTo(nRect.Right,nRect.Top);
         end;
      end;
  end;
end;


procedure TForm1.SpeedButton7Click(Sender: TObject);
begin
   if not SVDRPSend('DELT '+GetIndex(SGTimer)) then exit;
   ReadTimer;
end;

procedure TForm1.SBRecToggleClick(Sender: TObject);
var s:string;
begin
   s := SGTimer.Cells[1,SGTimer.Row];
   if s = 'Ein' then
      SVDRPSend('MODT '+GetIndex(SGTimer)+' off')
    else
      SVDRPSend('MODT '+GetIndex(SGTimer)+' on');
   ReadTimer;
end;

procedure TForm1.csConnect(Sender: TObject; Socket: TCustomWinSocket);
begin
memo1.lines.add('Status: Connected');
end;

procedure TForm1.csConnecting(Sender: TObject; Socket: TCustomWinSocket);
begin
memo1.lines.add('Status: Connecting');
end;

procedure TForm1.csDisconnect(Sender: TObject; Socket: TCustomWinSocket);
begin
memo1.lines.add('Status: Disconnected');
end;

procedure TForm1.csError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
   memo1.lines.add('Status: Error: '+inttostr(errorcode));
   Application.MessageBox(PChar(LocaleStr[L_RemoteError]),'EasyStream - WINLIRC',MB_OK );
   ErrorCode := 0;
end;

procedure TForm1.csLookup(Sender: TObject; Socket: TCustomWinSocket);
begin
memo1.lines.add('Status: Lookup');
end;

procedure TForm1.csRead(Sender: TObject; Socket: TCustomWinSocket);
var s,t,Taste:string;
    i,partend:Integer;
    params:array[1..4] of string;
begin
s := socket.ReceiveText;
memo1.lines.add('Recieved: '+s);

t:=s;
  for i := 1 to 3 do begin
    partend := Pos(' ', t); 
    params[i] := Copy(t, 1, partend - 1); 
    Delete(t, 1, partend); 
  end; 
  params[4] := t;
  delete(params[4],length(params[4]),1);

  if (params[2] <> '00') then exit;

  if (params[2] = '00') and ( pos(params[3,1],'0123456789') > 0 )  then
     Taste := label22.Caption+params[3]
   else
     Taste := params[3];

   if SBRemote.Down then begin
      SGRemote.Cells[1,SGRemote.Row] := Taste;
      exit;
   end;
  label22.Caption := Taste;
  for i := 1 to SGRemote.RowCount -1 do begin
     if params[3] = SGRemote.Cells[1,i] then  begin
        Action[i-1].Execute;
        if Action[i-1].Name <> MainFormClose.Name then
           Form1.Visible := True;
     end;      
  end;
end;

procedure TForm1.InitRemote(SGRemote:TStringGrid);
  procedure WriteTab(sAction,sTaste:String);
   var p:integer;
  begin
   with SGRemote do begin
      p := RowCount-1;
      RowCount := RowCount+1;
      cells[0,p] := sAction;
      cells[1,p] := sTaste;
   end;
  end;
var
  i:Integer;
begin
   SGRemote.RowCount := 0;
   SGRemote.ColCount := 2;
   WriteTab('Aktion','Taste der Fernbedienung');
   for i := 0 to Action.ActionCount-1 do
     WriteTab((Action.Actions[i] as TAction).Caption,'');
   SGRemote.FixedRows := 1;
   SGRemote.FixedCols := 0;
   SGRemote.RowCount := SGRemote.RowCount-1;
end;

procedure TForm1.KanaeleExecute(Sender: TObject);
begin
   PageControl1.ActivePage :=  TSKanaele;
end;

procedure TForm1.AufnahmenExecute(Sender: TObject);
begin
   PageControl1.ActivePage :=  TSRecord;
   PageControl1Change(Sender);
end;

procedure TForm1.TimerExecute(Sender: TObject);
begin
   PageControl1.ActivePage :=  TSTimer;
   PageControl1Change(Sender);
end;

procedure TForm1.EpgExecute(Sender: TObject);
begin
   PageControl1.ActivePage :=  TSEpg;
end;

procedure TForm1.AufExecute(Sender: TObject);
var sg:TStringGrid;
begin
   SG := nil;
   if  PageControl1.ActivePage = TSKanaele then
     SG := SGProgramm;
   if  PageControl1.ActivePage = TSRecord then
     SG := SGRecord;
   if  PageControl1.ActivePage = TSTimer then
     SG := SGTimer;
   if  PageControl1.ActivePage = TSEpg then
     SG := SGEpg;

   if assigned(SG) and (SG.Row > 1) then
      SG.Row := SG.Row-1;
end;

procedure TForm1.AbExecute(Sender: TObject);
var sg:TStringGrid;
begin
   SG := nil;
   if  PageControl1.ActivePage = TSKanaele then
     SG := SGProgramm;
   if  PageControl1.ActivePage = TSRecord then
     SG := SGRecord;
   if  PageControl1.ActivePage = TSTimer then
     SG := SGTimer;
   if  PageControl1.ActivePage = TSEpg then
     SG := SGEpg;

   if assigned(SG) and (SG.Row < SG.RowCount-1) then
      SG.Row := SG.Row+1;
end;

procedure TForm1.OKExecute(Sender: TObject);
begin
   if  PageControl1.ActivePage = TSKanaele then
     SpeedButton6Click(Sender);
   if  PageControl1.ActivePage = TSRecord then
     SBRecordPlayClick(Sender);
end;

procedure TForm1.ListeLadenExecute(Sender: TObject);
begin
   if  PageControl1.ActivePage = TSKanaele then
     SBLoadChannelClick(Sender);
   if  PageControl1.ActivePage = TSRecord then
     SpeedButton3Click(Sender);
   if  PageControl1.ActivePage = TSTimer then
     SpeedButton1Click(Sender);
end;


procedure TForm1.TProgrammTimer(Sender: TObject);
begin
  TProgramm.Enabled := False;
  SBEpgChannel.Down := True;
  ReadEpgSvdrp(SGProgramm.Row);
end;

procedure TForm1.TAufnahmenTimer(Sender: TObject);
begin
   TAufnahmen.Enabled := False;
   ReadRecText;
end;

procedure TForm1.SBRemoteClick(Sender: TObject);
begin
   if SBRemote.Down then
     SGRemote.Color := clWindow
    else
     SGRemote.Color := clBtnFace; 
end;

procedure TForm1.AudioExecute(Sender: TObject);
begin
   Form2.SBAudioTrackClick(Sender);
end;

procedure TForm1.SBEpgRightClick(Sender: TObject);
begin
   if (SGProgramm.Row < SGProgramm.RowCount-1) then
      SGProgramm.Row := SGProgramm.Row+1;
end;

procedure TForm1.SBEpgLeftClick(Sender: TObject);
begin
   if (SGProgramm.Row > 1) then
      SGProgramm.Row := SGProgramm.Row-1;
end;

procedure TForm1.SGEpgClick(Sender: TObject);
var
   Bild:TXpm;
   s:string;
begin
   Panel6.Visible := True;
   MEpg.Lines.Clear;
   MEpg.SelAttributes.Color := clBlue;
   MEpg.SelAttributes.Height := H_EPG_Kanal;
   s := SGEpg.Cells[EPG_KANAL,SGEpg.Row];
   MEpg.Lines.Add('');
   MEpg.Lines.Add('');
   MEpg.Lines.Add('');
   LTVName.Caption := s;

         Bild := TXpm.Create;
         s := 'logos\'+s+'.xpm';
         Bild.TransparenteFarbe := Panel6.Color;
         Bild.LoadFromFile(s);
         ImgKanal.Canvas.Brush.Color := Panel6.Color;
         ImgKanal.Canvas.FillRect(Rect(0,0,ImgKanal.Width,ImgKanal.Height));
         ImgKanal.Canvas.StretchDraw(Rect(0,0,ImgKanal.Width,ImgKanal.Height),Bild);
         ImgKanal.Visible := True;
         Bild.Free;


   MEpg.SelAttributes.Color := clBlue;
   MEpg.SelAttributes.Height := H_EPG_Zeit;
   MEpg.Lines.Add(SGEpg.Cells[EPG_ZEIT,SGEpg.Row]);
   LProgName.Caption := SGEpg.Cells[EPG_TITEL,SGEpg.Row];
   MEpg.SelAttributes.Color := clBlack;
   MEpg.SelAttributes.Height := FontHeight;
   MEpg.Lines.Add(SGEpg.Cells[EPG_TEXT,SGEpg.Row]);
end;

procedure TForm1.SBAufnahmeClick(Sender: TObject);
var s,Nr,RecMode:string;
    i,aRow:Integer;
begin
    aRow := SGEpg.Row;
    s := RecString(SGEpg.Cells[EPG_ZEIT,aRow],SGEpg.Cells[EPG_TITEL,aRow]);
    if not SVDRPSend('LSTT') then exit;
    i := pos(s,SVDRPList.Text);
    if i > 0 then begin
       Nr := copy(SVDRPList.Text,i-10,9);
       if Nr[9] = '0' then
          RecMode := ' on'
         else
          RecMode := ' off';
       i := pos('250',Nr);
       if i > 0 then begin
          Nr := copy(Nr,i+4,3);
          i := pos(' ',Nr);
          if i > 0 then
             Nr := LeftStr(Nr,i-1);
          SVDRPSend('MODT '+Nr+RecMode);
       end;
     end else
       SVDRPSend('NEWT 1:'+s);
    ReadTimer;
    PageControl1.ActivePage := TSTimer;

end;

procedure TForm1.AufnahmeExecute(Sender: TObject);
begin
   if PageControl1.ActivePage = TSEpg then
      SBAufnahmeClick(Sender);
   if PageControl1.ActivePage = TSTimer then
      SBRecToggleClick(Sender);
end;

procedure TForm1.LinksExecute(Sender: TObject);
var rows:Integer;
begin
   if PageControl1.ActivePage = TSKanaele then begin
      Rows := SGProgramm.VisibleRowCount;
      if SGProgramm.Row > Rows then
         SGProgramm.Row := SGProgramm.Row-Rows
       else
         SGProgramm.Row := 1;
   end;
   if PageControl1.ActivePage = TSEpg then
      SBEpgLeftClick(Sender);
end;

procedure TForm1.RightExecute(Sender: TObject);
var rows:Integer;
begin
   if PageControl1.ActivePage = TSKanaele then begin
      Rows := SGProgramm.VisibleRowCount;
      if SGProgramm.Row+Rows < SGProgramm.RowCount then
         SGProgramm.Row := SGProgramm.Row+Rows
       else
         SGProgramm.Row := SGProgramm.RowCount-1;
   end;
   if PageControl1.ActivePage = TSEpg then
      SBEpgRightClick(Sender);
end;

procedure TForm1.TVExecute(Sender: TObject);
begin
   if PageControl1.ActivePage = TSKanaele then begin
      SBTv.Down := True;
      SBTv.Click;
   end;
end;

procedure TForm1.RadioExecute(Sender: TObject);
begin
   if PageControl1.ActivePage = TSKanaele then begin
      SBRadio.Down := True;
      SBRadio.Click;
   end;
end;

procedure TForm1.TVRadioExecute(Sender: TObject);
begin
      if SBRadio.Down then
         TVExecute(Sender)
       else
         RadioExecute(Sender);
end;

procedure TForm1.AbschaltenExecute(Sender: TObject);
begin
  Form1.Close;
end;

procedure TForm1.BildFormatExecute(Sender: TObject);
var k:integer;
begin
   Form2.Show;
   if assigned(Form2.VLCPlugin1) then begin
      k := Form2.VLCPlugin1.GetVariable('key-fullscreen');
      Form2.VLCPlugin1.SetVariable('key-pressed',k);
   end;
end;

procedure TForm1.TForm1VisibleTimer(Sender: TObject);
begin
   if TForm1Visible.Tag = 0 then
      TForm1Visible.Tag :=  StrToInt(EEpgIntervall.Text) * 60000 div TForm1Visible.Interval
    else
      TForm1Visible.Tag := TForm1Visible.Tag - 1;
   if TForm1Visible.Tag = 0 then begin
      SBEPGNow.Down := True;
      SBLoadChannelClick(nil);
      GetDVBStatus;
   end;
   if not (Form1.Visible or Form2.Visible) then Form1.Visible := True;
   Form2.SBShowMainForm.Visible := not Form1.Visible;
   SBEpgPlay.Visible := SBEpgNow.Down;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  if pos('telnet',LowerCase(ETelnet.text+ETelnetParameter.text)) > 0 then
     ShowMessage(LocaleStr[L_OSDInfo]);
  ShellExecute(Application.Handle, 'open', PChar(ETelnet.text), PChar(ETelnetParameter.text), nil, SW_NORMAL);
end;

procedure ScreenShotActiveWindow(Bild: TBitMap);
var
  c: TCanvas;
  r, t: TRect;
  h: THandle;
begin
  c := TCanvas.Create;
  c.Handle := GetWindowDC(GetDesktopWindow);
  h := GetForeGroundWindow;
  if h <> 0 then
    GetWindowRect(h, t);
  try
    r := Rect(0, 0, t.Right - t.Left, t.Bottom - t.Top);
    Bild.Width  := t.Right - t.Left;
    Bild.Height := t.Bottom - t.Top;
    Bild.Canvas.CopyRect(r, c, t);
  finally
    ReleaseDC(0, c.Handle);
    c.Free;
  end;
end;

procedure TForm1.PrgScreenShootExecute(Sender: TObject);
var
  c: TCanvas;
  r, t: TRect;
  h: THandle;
  Bitmap: TBitmap;
  JPEG: TJPEGImage;
begin
  Bitmap := TBitmap.Create;
  c := TCanvas.Create;
  c.Handle := GetWindowDC(GetDesktopWindow);
  h := GetForeGroundWindow;
  if h <> 0 then
    GetWindowRect(h, t);
  try
    r := Rect(0, 0, t.Right - t.Left, t.Bottom - t.Top);
    Bitmap.Width  := t.Right - t.Left;
    Bitmap.Height := t.Bottom - t.Top;
    Bitmap.Canvas.CopyRect(r, c, t);
  finally
    ReleaseDC(0, c.Handle);
    c.Free;
  end;
  JPEG := TJPEGImage.Create;
  JPEG.Assign(Bitmap);
  JPEG.SaveToFile('C:\EasyStream.'+PageControl1.ActivePage.Caption+'.jpg');
  JPEG.Free;
  Bitmap.Free;
end;

procedure TForm1.VolUpExecute(Sender: TObject);
begin
   if  Form2.TBAudio.Position < Form2.TBAudio.Max-5 then
       Form2.TBAudio.Position := Form2.TBAudio.Position +5
     else
       Form2.TBAudio.Position := Form2.TBAudio.Max;
end;

procedure TForm1.VolDownExecute(Sender: TObject);
begin
   if  Form2.TBAudio.Position > 4 then
      Form2.TBAudio.Position := Form2.TBAudio.Position -5
     else
      Form2.TBAudio.Position := 0; 
end;

procedure TForm1.MuteExecute(Sender: TObject);
begin
  Form2.SBAudio.Down := not Form2.SBAudio.Down;
  Form2.SBAudio.Click;
end;

procedure TForm1.SBEpgNowClick(Sender: TObject);
begin
   ReadEpgSvdrp(0);
end;

procedure TForm1.SBEpgNextClick(Sender: TObject);
begin
   ReadEpgSvdrp(0);
end;

procedure TForm1.SBEpgChannelClick(Sender: TObject);
begin
   ReadEpgSvdrp(SGProgramm.Row);
end;

procedure TForm1.EpgToggleExecute(Sender: TObject);
var Button:TSpeedButton;
begin
   Button := SBEpgNext;
   if SBEpgNext.Down then
      Button := SBEpgChannel;
   if SBEpgChannel.Down then
      Button := SBEpgNow;
   Button.Down := True;
   Button.Click;   
end;


procedure TForm1.MainFormCloseExecute(Sender: TObject);
begin
  if Form2.Visible or (not Form1.Visible) then
     Form1.Visible := not Form1.Visible;
end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
begin
   if Form2.Visible then Form1.Visible := False;
end;

procedure TForm1.SBEpgPlayClick(Sender: TObject);
var i:integer;
begin
   for i := 1 to SGEpg.RowCount-1 do
      if SGProgramm.Cells[CH_NR,i] = SGEpg.Cells[EPG_NR,SGEpg.Row] then begin
         SGProgrammDoppelklick(i);
         exit;
      end;
end;

procedure TForm1.PrintControls(Name:String;Control:TWinControl);
var i:Integer;
  procedure ChkProperty(PropertyName:String);
  var
    Info: PPropInfo;
    s:String;
  begin
     Info := GetPropInfo( (Control.Controls[I] as TObject).ClassInfo, PropertyName);
     if assigned(Info) then begin
        s := GetStrProp(Control.Controls[I], Info);
        if s <> '' then
           Locale.Add(Name+'.'+Control.Controls[I].Name+'.'+Info.Name+'='+s);
     end;
  end;

begin
  for i := 0 to Control.ControlCount -1 do begin
     if (Control.Controls[I] is  TWinControl) then
        PrintControls(Name,Control.Controls[I] as TWinControl);
     ChkProperty('Caption');
     ChkProperty('Hint');
  end;
end;

function GetHelpFile(FileName:String):String;
var
  p:Integer;
begin
  p := pos('lang',LowerCase(FileName));
  if p > 0 then
    result := LeftStr(FileName,p-1)+'help'+Copy(FileName,p+4,Length(FileName))
   else
    Result := FileName+'.help';
end;

procedure TForm1.BSaveLanguageClick(Sender: TObject);
var i:integer;
begin
  Locale := TStringList.Create;
  PrintControls('Form1',Form1);
  PrintControls('Form2',Form2);
  Locale.Sort;
  for i := 0 to High(LocaleStr) do
     if LocaleStr[i] <> '' then
        Locale.Add('Message'+IntToStr(i)+'='+LocaleStr[i]);
  if CBSprache.Text = 'default' then begin
     Locale.SaveToFile(ProjektName+'.lang.de');
     MHelp.Lines.SaveToFile(ProjektName+'.help.de');
   end else begin
     Locale.SaveToFile(CBSprache.Text);
     MHelp.Lines.SaveToFile(GetHelpFile(CBSprache.Text));
  end;
end;

procedure TForm1.ReadControls(Name:String;Control:TWinControl);
var j:integer;
  procedure SetProperty(Form,Name:String);
  var p,l,i:integer;
      s,ComponentName,PropertyName,StrValue:String;
      Info: PPropInfo;
  begin
     ComponentName := Form+'.'+Name;
     l := Length(ComponentName);
     for i := 0 to Locale.Count-1 do begin
        s := Locale.Strings[i];
        if LeftStr(s,l) = ComponentName then begin
           p := pos('=',s);
           if p > 0 then begin
              PropertyName := copy(s,l+2,p-l-2);
              StrValue := copy(s,p+1,Length(s));
              Info := GetPropInfo( (Control.Controls[j] as TObject).ClassInfo, PropertyName);
              if assigned(Info) then
                  SetStrProp(Control.Controls[j], Info, StrValue);
           end;
        end;
     end;
  end;
begin
  for j := 0 to Control.ControlCount -1 do begin
     if (Control.Controls[j] is  TWinControl) then
        ReadControls(Name,Control.Controls[j] as TWinControl);
     SetProperty(Name,Control.Controls[j].Name);
  end;
end;

procedure TForm1.Button7Click(Sender: TObject);
var i,n:integer;
begin
  Locale := TStringList.Create;
  if (CBSprache.Text = '') or (CBSprache.Text = 'default') then begin
     if Sender is TButton then
        ShowMessage(LocaleStr[LOC_SpracheFehlt]);
     exit;   
   end else begin
     Locale.LoadFromFile(CBSprache.Text);
     MHelp.Lines.LoadFromFile(GetHelpFile(CBSprache.Text));
  end;
  ReadControls('Form1',Form1);
  ReadControls('Form2',Form2);
  n := 0;
  For i := 0 to Locale.Count-1 do
     if LeftStr(Locale.Strings[i],7) = 'Message' then begin
        LocaleStr[n] := Copy(Locale.Strings[i],pos('=',Locale.Strings[i])+1,Length(Locale.Strings[i]));
        inc(n);
     end;
  Locale.Free;
end;

procedure TForm1.CBSpracheChange(Sender: TObject);
begin
   Button7Click(Button7);
end;

procedure TForm1.PauseExecute(Sender: TObject);
begin
   Form2.SBPause.Down := not Form2.SBPause.Down;
   Form2.SBPause.Click;
end;

procedure TForm1.PlayExecute(Sender: TObject);
begin
   Form2.SBPlay.Click;
end;

procedure TForm1.StopExecute(Sender: TObject);
begin
   Form2.SBStop.Click;
end;

procedure TForm1.B_WOLClick(Sender: TObject);
var
  Data, temp: string;
  k, n: integer;
begin
  Data := '';
  for k := 0 to 5 do
  begin
    Data := Data + Chr(StrToInt('$FF'));  // 6x add a FF / 6x ein FF hinzufgen
  end;
  temp := StringReplace(EMacAdr.Text, '-', '', [rfReplaceAll]);
  for k := 0 to 15 do
  begin
    temp := StringReplace(EMacAdr.Text, '-', '', [rfReplaceAll]);
    for n := 0 to 5 do
    begin
      // 16x add Target-Mac-Adress / 16x die Ziel-Macadresse hinzufgen
      Data := Data + Chr(StrToInt('$' + temp[1] + temp[2]));
      Delete(temp, 1, 2);
    end;
 end;
  IdUDP_WOL.BroadCast(Data,9);  // Send it / Verschick es
end;

procedure TForm1.BVdrConnectClick(Sender: TObject);
begin
  EasyStreamInit;
end;

procedure TForm1.TBFontSizeChange(Sender: TObject);
begin
  FontHeight := TBFontSize.Position;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  EasyStreamInit;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
   if Application.MessageBox(PChar(LocaleStr[LOC_PowerOff]), 'Stream Server', MB_OKCANCEL) = IDCANCEL then
      exit;
   svdrpsend('HITK POWER')
end;

procedure TForm1.BVTPSendClick(Sender: TObject);
begin
   VTPSend(Edit6.Text,SVDRP_Quit);
end;

procedure TForm1.SBChannelSearchClick(Sender: TObject);
var i:integer;
    Cmd:TStringList;
begin
   if not SBChannelSearch.Down then begin
      for i := 1 to SGProgramm.RowCount-1 do
         SGProgramm.Cells[CH_LOGO,i] := '';
      exit;
   end;   
   Cmd := TStringList.Create;
   Form2.VlcPlugDestroy;
   for i := 1 to SGProgramm.RowCount-1 do
     Cmd.Add('PROV 50 '+SGProgramm.Cells[CH_NR,i]);
   VTPSend(Cmd.Text,SVDRP_Quit);
   Cmd.Free;
   for i := 1 to SGProgramm.RowCount-1 do
      if LeftStr(SVDRPList.Strings[i],3) = '220' then
        SGProgramm.Cells[CH_LOGO,i] := ''
       else
        SGProgramm.Cells[CH_LOGO,i] := 'NV'
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  TestVdr1;
end;

procedure TForm1.ETextChange(Sender: TObject);
begin
   if SGVdr.Tag = 0 then
      SGVdr.Cells[(Sender as TCustomEdit).Tag,SGVdr.Row] := (Sender as TCustomEdit).Text;
end;

procedure TForm1.EPasswordChange(Sender: TObject);
begin
   if SGVdr.Tag = 0 then
      SGVdr.Cells[EPassword.Tag,SGVdr.Row] := Crypt(EPassword.Text);
end;

procedure TForm1.CBNetDisconnectClick(Sender: TObject);
begin
   if SGVdr.Tag = 0 then
      if (Sender as TCheckBox).Checked then
         SGVdr.Cells[(Sender as TCheckBox).Tag,SGVdr.Row] := 'JA'
       else
         SGVdr.Cells[(Sender as TCheckBox).Tag,SGVdr.Row] := 'NEIN';
end;

procedure TForm1.SGVDRClick(Sender: TObject);
var aRow:Integer;
begin
  ARow := SGVdr.Row;
  SGVdr.Tag := 99;
  EIpAdr.Text := SGVdr.Cells[EIpAdr.Tag,ARow];
  ESvdrp.Text := SGVdr.Cells[ESvdrP.Tag,ARow];
  EPort.Text := SGVdr.Cells[EPort.Tag,ARow];
  EVTP.Text := SGVdr.Cells[EVTP.Tag,ARow];
  ELaufwerk.Text := SGVdr.Cells[ELaufwerk.Tag,ARow];
  ERecDir.Text := SGVdr.Cells[ERecDir.Tag,ARow];
  EUser.Text := SGVdr.Cells[EUser.Tag,ARow];
  EPassword.Text := DeCrypt(SGVdr.Cells[EPassword.Tag,ARow]);
  CBNetDisConnect.Checked := SGVdr.Cells[CBNetDisConnect.Tag,ARow] = 'JA';
  CBUseExtern.Checked := SGVdr.Cells[CBUseExtern.Tag,ARow] = 'JA';
  EMacAdr.Text := SGVdr.Cells[EMacAdr.Tag,ARow];
  CB_WOL.Checked := SGVdr.Cells[CB_WOL.Tag,ARow] = 'JA';
  CBVDRSwitch.Checked := SGVdr.Cells[CBVDRSwitch.Tag,ARow] = 'JA';
  SGVdr.Tag := 0;
end;

procedure TForm1.SBSgVdrDeleteClick(Sender: TObject);
var n,i:integer;
begin
   if SGVdr.RowCount < 3 then begin
      Application.MessageBox(PChar(LocaleStr[LOC_DeleteVDRList]),'EasyStream',MB_Ok);
      exit;
   end;
   if Application.MessageBox(PChar(LocaleStr[LOC_DeleteVDRListConfirm]),'EasyStream',MB_YESNO)= IDNO then
      exit;
   n := SGVdr.Row;
   for i := n to SGVdr.RowCount-2 do
      SGVdr.Rows[i].Text := SGVdr.Rows[i+1].Text;
   SGVdr.RowCount := SGVdr.RowCount-1;
   SGVdrClick(nil);
end;

procedure TForm1.SBSgVdrNewClick(Sender: TObject);
begin
   SGVdr.RowCount := SGVdr.RowCount+1;
   SGVdr.Rows[SGVdr.RowCount-1].Text := SGVdr.Rows[SGVdr.Row].Text;
   SGVdr.Cells[0,SGVdr.RowCount-1] := 'VDR-'+IntToStr(SGVdr.RowCount-1);
   SGVdr.Row := SGVdr.RowCount-1;

end;

procedure TForm1.BVdrConnect2Click(Sender: TObject);
begin
  EasyStreamInit;
end;

procedure TForm1.SBVDRCheckClick(Sender: TObject);
begin
   GetDVBStatus;
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
   SGProgrammDoppelklick(SGProgramm.Row);
end;

//videoverzeichniss auslesen
procedure TForm1.ScanVideo(Path:string);
var
   SearchRec : TSearchRec;
   FileName:String;
begin
   with RecordsPath do begin
      if FindFirst(Path+'\*.*', faAnyFile, SearchRec ) = 0 then begin                 // if found
         repeat
            if not ((SearchRec.Name = '.') or (SearchRec.Name = '..')) then  begin
               if (SearchRec.Attr and faDirectory) = faDirectory then
                   if pos('.rec',SearchRec.Name) > 0 then begin
                      Add(Path+'\'+SearchRec.Name);
                      Records.Add(AlphaNumString(Path+SearchRec.Name));
                     end else
                      ScanVideo(Path+'\'+SearchRec.Name);
            end;
         until FindNext(SearchRec) <> 0;
         FindClose(SearchRec);   
      end;
   end;
end;

procedure TForm1.SGTimerMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
    if SGEpg.ColWidths[EPG_KANAL] > 0 then
       EpgKanalWidth := SGEpg.ColWidths[EPG_KANAL];
    if SGEpg.ColWidths[EPG_DAUER] > 0 then
       EpgDauerWidth := SGEpg.ColWidths[EPG_DAUER];
end;

procedure TForm1.SGTimerClick(Sender: TObject);
begin
   TimerEpg;
end;

end.
