unit EasyDVB;

interface

uses Classes, SysUtils, ExtCtrls, Controls, Graphics;

type
  TDVB = class(TPanel)
     Card:TImage;
     Red:TImage;
     Green:TImage;
     procedure Init(nLeft,nCard:integer;imgDVB,imgRed,imgGreen:TImage);
     procedure Destroy;
     procedure Rec(Status:Boolean);
     procedure Use(Status:Boolean);
   public
  end;

implementation

procedure TDVB.Rec(Status:Boolean);
begin
   Red.Visible := Status;
end;

procedure TDVB.Use(Status:Boolean);
begin
   Green.Visible := Status;
end;


procedure TDVB.Init(nLeft,nCard:integer;imgDVB,imgRed,imgGreen:TImage);
begin

   Left := nLeft+44*nCard;
   Top := 3;
   Width := 41;
   Height := 25;
   ShowHint := True;
   Hint := 'DVB-'+IntToStr(nCard);
   
   Card := TImage.Create(self);
   Card.Parent := self;
   Card.Top := 1;
   Card.Left := 1;
   Card.Width := 25;
   Card.Height := 20;
   Card.Picture.Bitmap.Assign(imgDVB.Picture.Bitmap);

   Green := TImage.Create(self);
   Green.Parent := self;
   Green.Top := 1;
   Green.Left := 28;
   Green.Width := 11;
   Green.Height := 11;
   Green.ShowHint := True;
   Green.Hint := 'Karte aktiv';
   Green.Picture.Bitmap.Assign(imgGreen.Picture.Bitmap);
   Green.Visible := False;


   Red := TImage.Create(self);
   Red.Parent := self;
   Red.Top := 13;
   Red.Left := 28;
   Red.Width := 11;
   Red.Height := 11;
   Red.ShowHint := True;
   Red.Hint := 'Aufnahme luft';
   Red.Picture.Bitmap.Assign(imgRed.Picture.Bitmap);
   Red.Visible := False;

end;

procedure TDVB.Destroy;
begin
  Red.Free;
  Green.Free;
  Card.Free;
end;


end.
