/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import jakarta.activation.DataHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.attachments.AttachmentsDelegate;
import org.apache.axiom.attachments.IncomingAttachmentStreams;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMException;

class AttachmentSet
extends AttachmentsDelegate {
    private final Map<String, DataHandler> attachmentsMap = new LinkedHashMap<String, DataHandler>();

    AttachmentSet() {
    }

    @Override
    ContentType getContentType() {
        return null;
    }

    @Override
    DataHandler getDataHandler(String contentID) {
        return this.attachmentsMap.get(contentID);
    }

    @Override
    void addDataHandler(String contentID, DataHandler dataHandler) {
        this.attachmentsMap.put(contentID, dataHandler);
    }

    @Override
    void removeDataHandler(String blobContentID) {
        this.attachmentsMap.remove(blobContentID);
    }

    @Override
    InputStream getRootPartInputStream(boolean preserve) throws OMException {
        throw new OMException("Invalid operation. Attachments are created programatically.");
    }

    @Override
    String getRootPartContentID() {
        return null;
    }

    @Override
    String getRootPartContentType() {
        throw new OMException("The attachments map was created programatically. Unsupported operation.");
    }

    @Override
    IncomingAttachmentStreams getIncomingAttachmentStreams() {
        throw new IllegalStateException("The attachments map was created programatically. No streams are available.");
    }

    @Override
    Set<String> getContentIDs(boolean fetchAll) {
        return this.attachmentsMap.keySet();
    }

    @Override
    Map<String, DataHandler> getMap() {
        return Collections.unmodifiableMap(this.attachmentsMap);
    }

    @Override
    long getContentLength() throws IOException {
        return -1L;
    }

    @Override
    MultipartBody getMultipartBody() {
        throw new IllegalStateException("The attachments map was created programatically. MultipartBody is not available.");
    }
}

