/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.xop;

import java.io.IOException;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.xop.AbstractXOPDecodingFilterHandler;
import org.apache.axiom.ext.stax.BlobProvider;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.intf.TextContent;

final class XOPDecodingFilterHandler
extends AbstractXOPDecodingFilterHandler {
    private final OMAttachmentAccessor attachmentAccessor;

    XOPDecodingFilterHandler(XmlHandler parent, OMAttachmentAccessor attachmentAccessor) {
        super(parent);
        this.attachmentAccessor = attachmentAccessor;
    }

    @Override
    protected Object buildCharacterData(String contentID) {
        return new TextContent(contentID, new BlobProviderImpl(this.attachmentAccessor, contentID), true);
    }

    private static class BlobProviderImpl
    implements BlobProvider {
        private final OMAttachmentAccessor attachmentAccessor;
        private final String contentID;

        public BlobProviderImpl(OMAttachmentAccessor attachmentAccessor, String contentID) {
            this.attachmentAccessor = attachmentAccessor;
            this.contentID = contentID;
        }

        public Blob getBlob() throws IOException {
            Blob blob = this.attachmentAccessor.getBlob(this.contentID);
            if (blob == null) {
                throw new OMException("No MIME part found for content ID '" + this.contentID + "'");
            }
            return blob;
        }
    }
}

