/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.common.builder;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.common.builder.SOAPBuilderHelper;
import org.apache.axiom.soap.impl.intf.soap11.AxiomSOAP11FaultCode;
import org.apache.axiom.soap.impl.intf.soap11.AxiomSOAP11FaultDetail;
import org.apache.axiom.soap.impl.intf.soap11.AxiomSOAP11FaultReason;
import org.apache.axiom.soap.impl.intf.soap11.AxiomSOAP11FaultRole;
import org.w3c.dom.Element;

public class SOAP11BuilderHelper
extends SOAPBuilderHelper
implements SOAP11Constants {
    private boolean faultcodePresent = false;
    private boolean faultstringPresent = false;

    @Override
    public Class<? extends AxiomElement> handleEvent(OMElement parent, int elementLevel, String namespaceURI, String localName) throws SOAPProcessingException {
        Class elementType = null;
        if (elementLevel == 4) {
            if ("faultcode".equals(localName)) {
                elementType = AxiomSOAP11FaultCode.class;
                this.faultcodePresent = true;
            } else if ("faultstring".equals(localName)) {
                elementType = AxiomSOAP11FaultReason.class;
                this.faultstringPresent = true;
            } else {
                elementType = "faultactor".equals(localName) ? AxiomSOAP11FaultRole.class : ("detail".equals(localName) ? AxiomSOAP11FaultDetail.class : AxiomElement.class);
            }
        } else if (elementLevel == 5) {
            String parentTagName = "";
            parentTagName = parent instanceof Element ? ((Element)((Object)parent)).getTagName() : parent.getLocalName();
            if (parentTagName.equals("faultcode")) {
                throw new SOAPProcessingException("faultcode element should not have children");
            }
            if (parentTagName.equals("faultstring")) {
                throw new SOAPProcessingException("faultstring element should not have children");
            }
            if (parentTagName.equals("faultactor")) {
                throw new SOAPProcessingException("faultactor element should not have children");
            }
            elementType = AxiomElement.class;
        } else if (elementLevel > 5) {
            elementType = AxiomElement.class;
        }
        return elementType;
    }
}

