/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.IRequestListener;
import org.apache.wicket.core.request.handler.IComponentRequestHandler;
import org.apache.wicket.core.request.handler.IPageAndComponentProvider;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

public class BookmarkableListenerRequestHandler
implements IPageRequestHandler,
IComponentRequestHandler {
    private final IPageAndComponentProvider pageComponentProvider;
    private final Integer behaviorIndex;

    public BookmarkableListenerRequestHandler(IPageAndComponentProvider pageComponentProvider, Integer behaviorIndex) {
        Args.notNull(pageComponentProvider, "pageComponentProvider");
        this.pageComponentProvider = pageComponentProvider;
        this.behaviorIndex = behaviorIndex;
    }

    public BookmarkableListenerRequestHandler(PageAndComponentProvider pageComponentProvider) {
        this(pageComponentProvider, null);
    }

    public boolean includeRenderCount() {
        if (this.behaviorIndex == null) {
            return ((IRequestListener)((Object)this.getComponent())).rendersPage();
        }
        return ((IRequestListener)((Object)this.getComponent().getBehaviorById(this.getBehaviorIndex()))).rendersPage();
    }

    @Override
    public IRequestableComponent getComponent() {
        return this.pageComponentProvider.getComponent();
    }

    @Override
    public final String getComponentPath() {
        return this.pageComponentProvider.getComponentPath();
    }

    @Override
    public IRequestablePage getPage() {
        return this.pageComponentProvider.getPageInstance();
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.pageComponentProvider.getPageClass();
    }

    @Override
    public Integer getPageId() {
        return this.pageComponentProvider.getPageId();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageComponentProvider.getPageParameters();
    }

    @Override
    public void detach(IRequestCycle requestCycle) {
        this.pageComponentProvider.detach();
    }

    public Integer getBehaviorIndex() {
        return this.behaviorIndex;
    }

    @Override
    public void respond(IRequestCycle requestCycle) {
    }

    @Override
    public final boolean isPageInstanceCreated() {
        return true;
    }

    @Override
    public final Integer getRenderCount() {
        return this.pageComponentProvider.getRenderCount();
    }
}

