/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.page.PartialPageUpdate;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class AbstractPartialPageRequestHandler
implements IPartialPageRequestHandler {
    private final Page page;

    protected AbstractPartialPageRequestHandler(Page page) {
        this.page = (Page)Args.notNull((Object)page, (String)"page");
    }

    @Override
    public final void addChildren(MarkupContainer parent, Class<?> childCriteria) {
        Args.notNull((Object)parent, (String)"parent");
        Args.notNull(childCriteria, (String)"childCriteria");
        parent.visitChildren(childCriteria, new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                AbstractPartialPageRequestHandler.this.add(component);
                visit.dontGoDeeper();
            }
        });
    }

    @Override
    public void add(Component ... components) {
        for (Component component : components) {
            Args.notNull((Object)component, (String)"component");
            if (!component.getOutputMarkupId() && !(component instanceof Page)) {
                throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
            }
            this.add(component, component.getMarkupId());
        }
    }

    @Override
    public final Integer getPageId() {
        return this.page.getPageId();
    }

    @Override
    public final Integer getRenderCount() {
        return this.page.getRenderCount();
    }

    @Override
    public final PageParameters getPageParameters() {
        return this.page.getPageParameters();
    }

    @Override
    public final void add(Component component, String markupId) {
        this.getUpdate().add(component, markupId);
    }

    @Override
    public final void prependJavaScript(CharSequence javascript) {
        this.getUpdate().prependJavaScript(javascript);
    }

    @Override
    public final void appendJavaScript(CharSequence javascript) {
        this.getUpdate().appendJavaScript(javascript);
    }

    @Override
    public final void focusComponent(Component component) {
        if (component != null && !component.getOutputMarkupId()) {
            throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
        }
        String id = component != null ? "'" + component.getMarkupId() + "'" : "null";
        this.appendJavaScript("Wicket.Focus.setFocusOnId(" + id + ");");
    }

    @Override
    public final boolean isPageInstanceCreated() {
        return true;
    }

    @Override
    public final IHeaderResponse getHeaderResponse() {
        return this.getUpdate().getHeaderResponse();
    }

    protected abstract PartialPageUpdate getUpdate();

    @Override
    public final Page getPage() {
        return this.page;
    }

    @Override
    public final Class<? extends IRequestablePage> getPageClass() {
        return this.page.getPageClass();
    }
}

